declare_plugin("SAM Sites Asset Pack",
{
installed 	 	  = true, 
displayName  	  = _("SAM Sites Asset Pack"),
shortName	 	  =   "2SAP",
state		 	  = "installed",
developerName	  = "ERO, LetMePickThat",
version		 	  = "Beta 1.8.2",
Skins	=
	{
		{
			name	= "2SAP",
			dir		= "Theme"
		},
	},
info			  = _("This asset pack adds various 3D props and radars for use along the High Digit SAMd mod. Some vehicles are also included. Made by ERO and LetMePickThat"),
})

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_texture_path	(current_mod_path ..  "/Textures")

local function vehicle_file(f)
	if dofile(current_mod_path..f) then
		error("can't load file "..f)
		return
	end
	if(GT) then
		GT.shape_table_data = 
		{
			{
				file  	    = GT.visual.shape;
				username    = GT.Name;
				desrt       = GT.visual.shape_dstr;
			    classname 	= "lLandVehicle";
				positioning = "BYNORMAL";
				life		= GT.life or 5;
			},
			{
				name  = GT.visual.shape_dstr;
				file  = GT.visual.shape_dstr;
			},
		}
		add_surface_unit(GT)
		GT = nil;
	else
		error("GT empty in file "..f)
	end;
end

local function weapon_file(f)
	if dofile(current_mod_path..f) then
		error("can't load file "..f)
		return
	end
end

dofile(current_mod_path..'/Database/PackObjects/Bunkers.lua')
dofile(current_mod_path..'/Database/PackObjects/Objects.lua')
dofile(current_mod_path.."/Database/PackObjects/Revetments.lua")
dofile(current_mod_path.."/Database/Sensors/sensors.lua")



vehicle_file("/Database/Vehicles/radar/EWR_P_37.lua")
vehicle_file("/Database/Vehicles/radar/EWR_55Zh6U.lua")
vehicle_file("/Database/Vehicles/radar/EWR_1L119.lua")
vehicle_file("/Database/Vehicles/radar/EWR_GenericEW.lua")
vehicle_file("/Database/Vehicles/ERO_SA2_SNR75.lua")
vehicle_file("/Database/Vehicles/ERO_SA2_Trailer.lua")
vehicle_file("/Database/Vehicles/ERO_5S99_Trailer.lua")
vehicle_file("/Database/Vehicles/ERO_Toyota_ZU23.lua")
vehicle_file("/Database/Vehicles/ERO_Toyota_ZU23_Armored.lua")
--vehicle_file("/Database/Vehicles/ERO_Toyota_ZPU2.lua")
--vehicle_file("/Database/Vehicles/ERO_Toyota_ZPU2_Armored.lua")
vehicle_file("/Database/Vehicles/ERO_Toyota.lua")
--vehicle_file("/Database/Vehicles/ERO_ZU23_Insurgent.lua")


plugin_done()