--SENSOR TYPE
local SENSOR_OPTICAL = 0
local SENSOR_RADAR = 1
local SENSOR_IRST = 2
local SENSOR_RWR = 3
--RADAR
local RADAR_AS = 0
local RADAR_SS = 1
local RADAR_MULTIROLE = 2
--
local ASPECT_HEAD_ON = 0
local ASPECT_TAIL_ON = 1
--
local HEMISPHERE_UPPER = 0
local HEMISPHERE_LOWER = 1
--IRST
local ENGINE_MODE_FORSAGE = 0
local ENGINE_MODE_MAXIMAL = 1
local ENGINE_MODE_MINIMAL = 2
--OPTIC
local OPTIC_SENSOR_TV = 0
local OPTIC_SENSOR_LLTV = 1
local OPTIC_SENSOR_IR = 2

-- Buk-M1-2 SENSORS


NEBO_SVU =
        {
			Name = "EWR 1L119 Nebo-SVU",
			category = SENSOR_RADAR,
            type = RADAR_AS,
            scan_volume =
            {
                azimuth = {-180.0, 180.0},
                elevation = {-15.0, 60.0}
            },
            max_measuring_distance = 500000.0,
            detection_distance =
            {
                [HEMISPHERE_UPPER] =
                {
                    [ASPECT_HEAD_ON] = 400000.0,
                    [ASPECT_TAIL_ON] = 400000.0
                },
                [HEMISPHERE_LOWER] =
                {
                    [ASPECT_HEAD_ON] = 400000.0,
                    [ASPECT_TAIL_ON] = 400000.0
                }
            },
            lock_on_distance_coeff = 0.75,
			multiple_targets_tracking = true,
            velocity_limits =
            {
                radial_velocity_min = 25.0,
            },
            scan_period = 10.0,
        }

declare_sensor(NEBO_SVU)

NEBO_U =
        {
			Name = "EWR 55G6U NEBO-U",
			category = SENSOR_RADAR,
            type = RADAR_AS,
            scan_volume =
            {
                azimuth = {-180.0, 180.0},
                elevation = {-15.0, 60.0}
            },
            max_measuring_distance = 600000.0,
            detection_distance =
            {
                [HEMISPHERE_UPPER] =
                {
                    [ASPECT_HEAD_ON] = 500000.0,
                    [ASPECT_TAIL_ON] = 500000.0
                },
                [HEMISPHERE_LOWER] =
                {
                    [ASPECT_HEAD_ON] = 500000.0,
                    [ASPECT_TAIL_ON] = 500000.0
                }
            },
            lock_on_distance_coeff = 0.6,
			multiple_targets_tracking = true,
            velocity_limits =
            {
                radial_velocity_min = 25.0,
            },
            scan_period = 10.0,
        }

declare_sensor(NEBO_U)

BAR_LOCK =
        {
			Name = "EWR P-37 BAR LOCK",
			category = SENSOR_RADAR,
            type = RADAR_AS,
            scan_volume =
            {
                azimuth = {-180.0, 180.0},
                elevation = {-15.0, 60.0}
            },
            max_measuring_distance = 450000.0,
            detection_distance =
            {
                [HEMISPHERE_UPPER] =
                {
                    [ASPECT_HEAD_ON] = 300000.0,
                    [ASPECT_TAIL_ON] = 300000.0
                },
                [HEMISPHERE_LOWER] =
                {
                    [ASPECT_HEAD_ON] = 300000.0,
                    [ASPECT_TAIL_ON] = 300000.0
                }
            },
            lock_on_distance_coeff = 0.6,
			multiple_targets_tracking = true,
            velocity_limits =
            {
                radial_velocity_min = 25.0,
            },
            scan_period = 20.0,
        }

declare_sensor(BAR_LOCK)

GENERIC_CIVILIAN =
        {
			Name = "EWR Generic radar tower",
			category = SENSOR_RADAR,
            type = RADAR_AS,
            scan_volume =
            {
                azimuth = {-180.0, 180.0},
                elevation = {-5.0, 60.0}
            },
            max_measuring_distance = 450000.0,
            detection_distance =
            {
                [HEMISPHERE_UPPER] =
                {
                    [ASPECT_HEAD_ON] = 350000.0,
                    [ASPECT_TAIL_ON] = 350000.0
                },
                [HEMISPHERE_LOWER] =
                {
                    [ASPECT_HEAD_ON] = 350000.0,
                    [ASPECT_TAIL_ON] = 350000.0
                }
            },
            lock_on_distance_coeff = 0.6,
			multiple_targets_tracking = true,
            velocity_limits =
            {
                radial_velocity_min = 25.0,
            },
            scan_period = 20.0,
        }

declare_sensor(GENERIC_CIVILIAN)