-- Missile
local function calcPiercingMass(warhead)
	warhead.piercing_mass  = warhead.mass;
	if (warhead.expl_mass/warhead.mass > 0.1) then
		warhead.piercing_mass  = warhead.mass/5.0;
	end
end

local function directional_a2a_warhead(power, caliber) -- See why we use that? ;)
    local res = {};

	res.caliber 			 = caliber
    res.expl_mass 			 = 3.5*power;
	res.mass 				 = res.expl_mass;
    res.other_factors 		 = {1, 1, 1};
    res.obj_factors 		 = {1, 1};
    res.concrete_factors 	 = {1, 1, 1};
    res.cumulative_factor 	 = 0;
    res.concrete_obj_factor	 = 0.0;
    res.cumulative_thickness = 0.0;
    
	calcPiercingMass(res)
    return res;
end

local SA9M96E2 = {
	Name = SA9M96E2, --SA9M96E2
	display_name = _('9M96E2 (SA-21 Growler)'),
	name = "SA9M96E2",
	Escort = 3, -- Escort(Requires tracking?): 0 - no, 1 - launch aircraft, 2 - another aircraft, 3 - from the ground
	Head_Type = 2, -- Seeker type code, in our case 6 is for Semi-active radar homing. 1 = Passive IR homing, 2 = Active Radar Homing
	sigma = {20, 20, 20}, -- maximum aiming error in meters, in target coordinates. x - longitudinal axis of the target, y - vertical axis of the target, z - transverse axis of the target
	M = 420.0, -- Mass of the missile at launch
	H_max = 30000.0, -- Maximum target altitude
	H_min = 5.0, -- minimum target altitude
	Diam = 240.0, -- Missile diameter in mm
	Cx_pil = 8, -- "Cx like pendants" - Moment of inertia??
	D_max = 40000.0, -- Maximum range firing at low altitude, in meters
	D_min = 1000.0, -- minimum range in meters
	Head_Form = 1, -- determines shape of the missile head for drag modeling; 0 for hemispherical, 1 for conical
	Life_Time = 240.0, -- Battery life
	Nr_max = 35, -- Maximum g when turning
	v_min = 50.0, -- Minimum speed in m/s
	v_mid = 1000.0, -- average speed in m/s
	Mach_max = 8.8, -- maximum Mach of the missile. In DCS this seems to assume the missile is not subject to drag, so a little headroom is necessary
	t_b = 0.0, -- Motor start delay
	t_acc = 12.0, -- motor burn time
	t_marsh = 0.0, -- cruise time, 0.0 if not applicable
	Range_max = 120000.0, -- Max range in meters
	H_min_t = 5.0, -- minimum target height above the terrain, m.
	Fi_start = 3.14152, -- angle of tracking and sighting at launch, in radians
	Fi_rak = 3.14152, -- allowable angle of view of the target, in radians
	Fi_excort = 2.0, -- tracking angle (sighting) of the target by the missile.
	Fi_search = 99.9, -- limit angle of free search
	OmViz_max = 99.9, -- line-of-sight speed limit
	warhead = directional_a2a_warhead(24.0),
	exhaust1 = {1, 1, 1, 1},
	X_back = -3.681,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.2,
	KillDistance = 25.0,
	category = CAT_MISSILES,
	ccm_k0       = 0.2, -- Countermeasures effectiveness
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_SA_Missile,WSTYPE_PLACEHOLDER};
	shape_table_data = 
	{
		{
			name	 = "ERO_9M96E2";
			file  	 = "ERO_9M96E2";
			life  	 = 1;
			fire  	 = { 0, 1};
			username = "9M96E2";
			index = WSTYPE_PLACEHOLDER;
		},
	}
};
declare_weapon(SA9M96E2)

GT_t.WS_t.S_400_9M96E2 = {}
GT_t.WS_t.S_400_9M96E2.moveable = false
GT_t.WS_t.S_400_9M96E2.angles = {
					{math.rad(180), math.rad(-180), math.rad(-90), math.rad(90)},
					};
GT_t.WS_t.S_400_9M96E2.reference_angle_Z = math.rad(90)
GT_t.WS_t.S_400_9M96E2.LN = {}
GT_t.WS_t.S_400_9M96E2.LN[1] = {}
GT_t.WS_t.S_400_9M96E2.LN[1].type = 4
GT_t.WS_t.S_400_9M96E2.LN[1].distanceMin = 1000
GT_t.WS_t.S_400_9M96E2.LN[1].distanceMax = 120000
GT_t.WS_t.S_400_9M96E2.LN[1].ECM_K = 0.4;
GT_t.WS_t.S_400_9M96E2.LN[1].reactionTime = 3
GT_t.WS_t.S_400_9M96E2.LN[1].launch_delay = 3;
GT_t.WS_t.S_400_9M96E2.LN[1].reflection_limit = 0.02;
GT_t.WS_t.S_400_9M96E2.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.S_400_9M96E2.LN[1].sensor, GT_t.WSN_t[0])
GT_t.WS_t.S_400_9M96E2.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.S_400_9M96E2.LN[1].PL = {}
GT_t.WS_t.S_400_9M96E2.LN[1].PL[1] = {}
GT_t.WS_t.S_400_9M96E2.LN[1].PL[1].ammo_capacity = 4
GT_t.WS_t.S_400_9M96E2.LN[1].PL[1].type_ammunition = SA9M96E2.wsTypeOfWeapon;
GT_t.WS_t.S_400_9M96E2.LN[1].PL[1].reload_time = 1000000; -- never during the mission
GT_t.WS_t.S_400_9M96E2.LN[1].BR = { {pos = {0, 0, 0} } }