-- Missile
local function calcPiercingMass(warhead)
	warhead.piercing_mass  = warhead.mass;
	if (warhead.expl_mass/warhead.mass > 0.1) then
		warhead.piercing_mass  = warhead.mass/5.0;
	end
end

local function simple_aa_warhead(power, caliber) -- By Saint
    local res = {};

	res.caliber = caliber
	res.mass = power; --old explosion damage effect
    res.expl_mass = power;
    res.other_factors = {1, 1, 1};
    res.obj_factors = {1, 1};
    res.concrete_factors = {1, 1, 1};
    res.cumulative_factor = 0;
    res.concrete_obj_factor = 0.0;
    res.cumulative_thickness = 0.0;
    
	calcPiercingMass(res)
    return res;
end

local SA9M331 = {
	Name = SA9M331, --9M331 Tor-M2E, SA-15D
	display_name = _('9M331 Tor-M2E'),
	name = "SA9M331",
    Escort = 3,
    Head_Type = 6,
	sigma = {15, 15, 15},
    M = 165.0,
    H_max = 7000.0,
    H_min = 10.0,
    Diam = 220.0,
    Cx_pil = 2,
    D_max = 17000.0,
    D_min = 1000.0,
    Head_Form = 1,
    Life_Time = 35.0,
    Nr_max = 30,
    v_min = 170.0,
    v_mid = 430.0,
    Mach_max = 3.0,
    t_b = 0.0,
    t_acc = 3.0,
    t_marsh = 6.0,
    Range_max = 17000.0,
    H_min_t = 10.0,
    Fi_start = 3.14152,
    Fi_rak = 3.14152,
    Fi_excort = 2.0,
    Fi_search = 99.9,
    OmViz_max = 99.9,
    warhead				= simple_aa_warhead(14.5, 100),
    exhaust			= { 0.7, 0.7, 0.7, 0.4 },
	tail_scale			= 0.6,
    X_back = -1.77,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.08,
    KillDistance = 7.0,
	category = CAT_MISSILES,
	ccm_k0       = 0.5,
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_SA_Missile,WSTYPE_PLACEHOLDER};
	shape_table_data = 
	{
		{
			name	 = "ERO_9M331";
			file  	 = "ERO_9M331";
			life  	 = 1;
			fire  	 = { 0, 1};
			username = "SA9M331";
			index = WSTYPE_PLACEHOLDER;
		},
	}
};
declare_weapon(SA9M331)



GT_t.LN_t._9A331 = {} -- Tor-M2E
GT_t.LN_t._9A331.max_number_of_missiles_channels = 1;
GT_t.LN_t._9A331.type = 4;
GT_t.LN_t._9A331.distanceMin = 1000;
GT_t.LN_t._9A331.distanceMax = 17000;
GT_t.LN_t._9A331.inclination_correction_upper_limit = 0;
GT_t.LN_t._9A331.inclination_correction_bias = 0.0;
GT_t.LN_t._9A331.ECM_K = 0.8;
GT_t.LN_t._9A331.reactionTime = 1;
--GT_t.LN_t._9A331.barrels_reload_type = BarrelsReloadTypes.SEQUENTIALY;
GT_t.LN_t._9A331.maxShootingSpeed = 0.0;
GT_t.LN_t._9A331.sensor = {};
set_recursive_metatable(GT_t.LN_t._9A331.sensor, GT_t.WSN_t[0]);
GT_t.LN_t._9A331.launch_delay = 0.1;
GT_t.LN_t._9A331.reflection_limit = 0.02;
GT_t.LN_t._9A331.beamWidth = math.rad(1);
GT_t.LN_t._9A331.PL = {};
GT_t.LN_t._9A331.PL[1] = {};
GT_t.LN_t._9A331.PL[1].ammo_capacity = 8;
GT_t.LN_t._9A331.PL[1].portionAmmoCapacity = 4;
GT_t.LN_t._9A331.PL[1].type_ammunition= SA9M331.wsTypeOfWeapon;
GT_t.LN_t._9A331.PL[1].name_ammunition=_("9M331");
GT_t.LN_t._9A331.PL[1].reload_time = 1080;
GT_t.LN_t._9A331.PL[1].shot_delay = 0.1;