local self_ID = "UH-60L"
declare_plugin(self_ID,
{
	dirName			= current_mod_path,
	displayName		= _("UH-60L Black Hawk"),
	developerName		= "Kinkku",
	installed			= true,
	fileMenuName	= _("UH-60L"),
	version 		= "2.1.5",
	state			= "installed",
	info			= _("The UH-60L Black Hawk is a utility helicopter used by the US Army and other forces around the world."),

	binaries =
	{
		'UH60L',
	},
	Skins =
	{
		{
			name	= "UH-60L",
			dir		= "Skins/1"
		},
	},
	Missions =
	{
		{
			name	= _("UH-60L"),
			dir		= "Missions",
		},
	},
	LogBook =
	{
		{
			name	= _("UH-60L"),
			type	= "UH-60L",
		},
	},
	InputProfiles =
	{
		["UH-60L"] = current_mod_path .. '/Input',
	},
	Options =
	{
		{
			name		= _("UH-60L"),
			nameId		= "UH-60L",
			dir			= "Options",
			CLSID		= "{UH-60L options}"
		},
	},

	load_immediately = true,
})
-------------------------------------------------------------------------------
mount_vfs_model_path(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")

mount_vfs_texture_path(current_mod_path.."/Textures")
mount_vfs_texture_path(current_mod_path.."/Textures/Cockpit")
mount_vfs_texture_path(current_mod_path.."/Textures/uh60l") --zip
mount_vfs_texture_path(current_mod_path.."/Textures/uh60l-cockpit") --zip
mount_vfs_texture_path(current_mod_path.."/Textures/uh60l-weapons") --zip
mount_vfs_texture_path(current_mod_path.."/Textures/uh60l-liveries") --zip
mount_vfs_texture_path(current_mod_path.."/Cockpit/IndicatorTextures")--for textures used in cockpit systems i.e. digital fonts
mount_vfs_texture_path(current_mod_path.."/Skins/1/ME")

dofile(current_mod_path.."/Weapons/weapons.lua")
dofile(current_mod_path..'/UH-60L.lua')
dofile(current_mod_path..'/UnitPayloads/UH-60L.lua')
dofile(current_mod_path..'/KC-130J.lua')
dofile(current_mod_path.."/Views.lua")

local cfg_path = current_mod_path.."/FM/config.lua"
dofile(cfg_path)
UH60FM[1]			= self_ID
UH60FM[2]			= "UH60L"
UH60FM.config_path 	= cfg_path

make_view_settings('UH-60L',ViewSettings, SnapViews)
make_flyable('UH-60L',current_mod_path..'/Cockpit/Scripts/', UH60FM, current_mod_path..'/comm.lua')
--set_manual_path('UH-60L', current_mod_path .. '/Doc/manual')

make_view_settings('UH-60L_DAP',ViewSettings, SnapViews)
make_flyable('UH-60L_DAP',current_mod_path..'/Cockpit/Scripts/', UH60FM, current_mod_path..'/comm.lua')
--set_manual_path('UH-60L_DAP', current_mod_path .. '/Doc/manual')

plugin_done()
