-- dofile("Scripts/Database/db_weapons.lua")
-- 
-- local function uh60_missile(clsid, newCLSID)
-- 	local data =db.Weapons.ByCLSID[clsid]
-- 	data.CLSID = newCLSID
-- 	data.settings = Get_LGU_GUISettings_Preset("WGU59")
-- 
-- 	declare_loadout(data)
-- end
-- 
-- uh60_missile("OH58D_AGM_114_R1", "UH60_AGM_114_R1")
-- uh60_missile("OH58D_AGM_114_R", "UH60_AGM_114_R")
-- uh60_missile("OH58D_AGM_114_L1", "UH60_AGM_114_L1")
-- uh60_missile("OH58D_AGM_114_L1", "UH60_AGM_114_L")

local function uh60_fuel_tank(clsid, name, weightEmpty, weightFull, Cx, shapeName, shapeFile, picture)
	local data =
	{
		category		= CAT_FUEL_TANKS,
		CLSID			= clsid,
		attribute		= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= picture or "PTB.png",
		displayName		= name,
		Weight_Empty	= weightEmpty,
		Weight			= weightFull,
		Cx_pil			= Cx,
		shape_table_data = 
		{
			{
				name		= shapeName;
				file		= shapeFile;
				life		= 1;
				fire		= { 0, 1};
				username	= shapeName;
				index		= WSTYPE_PLACEHOLDER;
			},
		},
		Elements = 
		{
			{
				ShapeName = shapeFile,
			}, 
		}, 
	}
	declare_loadout(data)
end

uh60_fuel_tank("{UH60_FUEL_TANK_200}", _("200 Gallon CEFS Aux Tank"), 156, 156 + 598.1, 0.000956902, "UH60_FUEL_TANK_200", "fueltank200") -- 0.79kg/l fuel weight 
uh60_fuel_tank("{UH60_FUEL_TANK_230}", _("230 Gallon Aux Tank"), 68, 68 + 678.3, 0.000956902, "UH60_FUEL_TANK_230", "fueltank230")
uh60_fuel_tank("{UH60_FUEL_TANK_450}", _("450 Gallon Aux Tank"), 106, 106 + 1345.4, 0.000956902, "UH60_FUEL_TANK_450", "fueltank450")
uh60_fuel_tank("{UH60_IAFTS}", _("Dual Internal Auxiliary Fuel Transfer System (336 Gallons)"), 426, 426 + 1004.8, 0.000956902, "UH60_IAFTS", "uh60l_iafts", "iafs_cp.png")

local function seat_gunner_l(clsid)
	local data =
	{
		category	= CAT_PODS,
		CLSID		= clsid,
		attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "seat_icon_leftgunner.png",
		displayName	= _("Empty Gunner Seat"),
		Weight_Empty	= 20,
		Weight			= 20,
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "UH60_SEAT_GUNNER_L";
				file	= "leftSeat";
				life	= 1;
				fire	= { 0, 1};
				username	= "UH60_SEAT_GUNNER_L";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "leftSeat",
			}, 
		}, 
	}
	declare_loadout(data)
end

seat_gunner_l("{UH60_SEAT_GUNNER_L}")

local function seat_gunner_r(clsid)
	local data =
	{
		category	= CAT_PODS,
		CLSID		= clsid,
		attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "seat_icon_rightgunner.png",
		displayName	= _("Empty Gunner Seat"),
		Weight_Empty	= 20,
		Weight			= 20,
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "UH60_SEAT_GUNNER_R";
				file	= "rightSeat";
				life	= 1;
				fire	= { 0, 1};
				username	= "UH60_SEAT_GUNNER_R";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "rightSeat",
			}, 
		}, 
	}
	declare_loadout(data)
end

seat_gunner_r("{UH60_SEAT_GUNNER_R}")

local function seat_cargo_all(clsid)
	local data =
	{
		category	= CAT_PODS,
		CLSID		= clsid,
		attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "seat_icon_threerows.png",
		displayName	= _("Cargo Seats (Three Rows)"),
		Weight_Empty	= 20,
		Weight			= 20, 
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "UH60_SEAT_CARGO_ALL";
				file	= "fullCargoSeats";
				life	= 1;
				fire	= { 0, 1};
				username	= "UH60_SEAT_CARGO_ALL";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "fullCargoSeats",
			}, 
		}, 
	}
	declare_loadout(data)
end

seat_cargo_all("{UH60_SEAT_CARGO_ALL}")

local function seat_cargo_rear(clsid)
	local data =
	{
		category	= CAT_PODS,
		CLSID		= clsid,
		attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "seat_icon_backrow.png",
		displayName	= _("Cargo Seats (Rear Row)"),
		Weight_Empty	= 20,
		Weight			= 20,
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "UH60_SEAT_CARGO_REAR";
				file	= "rearCargoSeats";
				life	= 1;
				fire	= { 0, 1};
				username	= "UH60_SEAT_CARGO_REAR";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "rearCargoSeats",
			}, 
		}, 
	}
	declare_loadout(data)
end

seat_cargo_rear("{UH60_SEAT_CARGO_REAR}")

-- GUNNER WEAPONS
function UH60L_GUNNER_M134(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "UH60L_M134"
	tbl.supply 	 =
	{
		mixes =
		{
			{1,1,1,1,3}, --day
			{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2}, --night
		},
		shells = {"7_62x51","7_62x51tr","M134_7_62_T"},
		count  = 8000,
	}
	if tbl.mixes then 
		tbl.supply.mixes	=  tbl.mixes
		tbl.mixes			= nil
	end
	tbl.gun = 
	{
		max_burst_length	= 10,
		rates				= {6000},
		recoil_coeff		= 0.01,
		barrels_count		= 6,
	}
	
	tbl.ejector_pos				= tbl.ejector_pos or {0,0,0}
	tbl.ejector_pos_connector	= tbl.ejector_pos_connector or "Eject_point"
	tbl.ejector_dir				= {-0.3,-1,0}
	tbl.supply_position			= tbl.supply_position   or {-0.3,-1.0, 0.0}
	tbl.aft_gun_mount			= false
	tbl.effective_fire_distance = 1000 
	tbl.drop_cartridge			= 205
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or {0,0,0}
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0
	tbl.elevation_initial 		= tbl.elevation_initial  or 0
	tbl.barrel_circular_error	= 0.01

	if  tbl.effects == nil then
		tbl.effects =
		{
			{ name = "FireEffect", arg = tbl.effect_arg_number or 436 },
			{ name = "HeatEffectExt", shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
			{ name = "SmokeEffect" },
		}
	end
	return declare_weapon(tbl)
end

declare_loadout({
	category			= CAT_PODS,
	CLSID				= "{UH60L_M134_GUNNER}",
	attribute			= {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= {wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture				= "m134.png",
	displayName			= _("M134 Door Gun"),
	Weight_Empty		= 30,
	Weight				= 30 + 150,
	Cx_pil				= 0.001220703125,
	Elements			= {{ShapeName = "empty"}},
	kind_of_shipping	= 2,--SOLID_MUNITION
	gun_mounts =
	{
		UH60L_GUNNER_M134({})
	},
	shape_table_data = {{file  	 = 'empty';	username = 'empty';index    =  WSTYPE_PLACEHOLDER;}}
})

-- GUNNER M3M
declare_loadout({
	category 		=   CAT_PODS,
	CLSID	 		=  "{UH60L_M2_GUNNER}",
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"M3.png",
	displayName		=	_("M3M Door Gun"),
	Weight_Empty	=	30,
	Weight			=	30 + 150,
	Cx_pil			=	0.001220703125,
	Elements		= {{ShapeName = "uh60l_m3m"}},
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		=
	{
		gun_mount(
		"M_2",
		{
			count = 1200,
			--reload_every = 200,
			--reload_time = 7,
			--reload_arg = 500,
		},
		{
			muzzle_pos_connector = "muzzle_point",
			ejector_dir = {0.0, 0.0, 1.0},
			ejector_pos_connector = "ejector_point",
			effects = {
				{name = "VisualHeatEffect", arg = 444, shot_heat = 7.823, barrel_k = 0.462 * 16.0, body_k = 0},
				{name = "FireEffect", arg = 46, duration = 0.05, attenuation = a2, light_pos = {0.5, 0.0, 0.0}},
				{name = "SmokeEffect"},
				{name = "FeedBelt", arg_main = 552, arg_tail = 553, full_load = 200, tail_load = 70},
			},
			barrel_circular_error = 0.005,
		}
		),
	},
	shape_table_data = {{file  	 = 'uh60l_m3m';	username = 'uh60l_m3m';index    =  WSTYPE_PLACEHOLDER;}}
})

-- GUNNER M60
declare_loadout({
	category 		=   CAT_PODS,
	CLSID	 		=  "{UH60L_M60_GUNNER}",
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"M60.png",
	displayName		=	_("M60 Door Gun"),
	Weight_Empty	=	30,
	Weight			=	30 + 150,
	Cx_pil			=	0.001220703125,
	Elements		= {{ShapeName = "uh60l_m60"}},
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		=
	{
		gun_mount(
			"M_60",
			{
				count = 1200,
				reload_every = 200,
				reload_time = 7,
				reload_arg = 500,
			},
			{
				muzzle_pos_connector = "muzzle_point",
				ejector_dir = {0.0, 0.0, 1.0},
				ejector_pos_connector = "ejector_point",
				effects = {
					fire_effect(46, 0.05),
					{name = "SmokeEffect"},
					{name = "FeedBelt", arg_main = 19, arg_tail = 0, full_load = 200, tail_load = 1},
				},
				barrel_circular_error = 0.005,
			}
		),
	},
	shape_table_data = {{file  	 = 'uh60l_m60';	username = 'uh60l_m60';index    =  WSTYPE_PLACEHOLDER;}}
})

function UH60_M230(tbl)
    tbl.category = CAT_GUN_MOUNT
    tbl.name     = "M230"
    tbl.supply = 
	{ 
		shells = {"M230_HEDP M789"}, 
        count = 600,
    }
    if tbl.mixes then
        tbl.supply.mixes = tbl.mixes
        tbl.mixes = nil
    end
    tbl.gun =
    {
        max_burst_length    = 1,
        rates               = {625},
        recoil_coeff        = 0.91,
        barrels_count       = 1,
    }
    if tbl.rates then
       tbl.gun.rates        =  tbl.rates
       tbl.rates            = nil
    end
    tbl.ejector_pos             = tbl.ejector_pos or {-1.1, -0.2, 0.15}
    tbl.ejector_pos_connector   = tbl.ejector_pos_connector or {-1.1, -0.2, 0.15}
    tbl.ejector_dir             = {-1, -6, 0}
    tbl.supply_position         = tbl.supply_position or {0,  0.3, -0.3}
    tbl.aft_gun_mount           = false
    tbl.effective_fire_distance = 1800
    tbl.drop_cartridge          = 203
    tbl.muzzle_pos              = tbl.muzzle_pos            or  {0,0,0}     -- all position from connector
    tbl.muzzle_pos_connector    = tbl.muzzle_pos_connector  or  {0,0,0} 	-- all position from connector
    tbl.azimuth_initial         = tbl.azimuth_initial       or  0
    tbl.elevation_initial       = tbl.elevation_initial     or  -3
    if  tbl.effects == nil then
        tbl.effects = { {
					arg = 350,
					attenuation = 2,
					duration = 0.02,
					light_pos = { 0.5, 0, 0 },
					name = "FireEffect"
				}, {
					name = "SmokeEffect"
				} }
					
    end
    return declare_weapon(tbl)
end

function declare_M230(clsid, name)
	local data =
	{
	category 		=   CAT_PODS,
	CLSID	 		=  clsid,
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"mps410.png",
	displayName		=	_("M-230, 30MM M789 HEDP (600 rnds)"),-- loadout editor name
	Weight			=	60,
	Cx_pil			=	0.00024,
	Elements  		= {{ShapeName = "uh60l_m230_right"}},	
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		=
	{
		UH60_M230({
			supply_position         = {0, 0, 0},
			muzzle_pos_connector    = "muzzle_point",
			elevation_initial		= -3,
			ejector_pos_connector	= "ejector_point"
		})
	},
	shape_table_data = {{file = name;	username = name; index = WSTYPE_PLACEHOLDER;}}
	}
	declare_loadout(data)
end

declare_M230("{UH60_M230_LEFT}", "uh60l_m230_left")
declare_M230("{UH60_M230_RIGHT}", "uh60l_m230_right")

-- GAU-19s
function UH60_GAU19(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "UH-60L GAU-19"
	tbl.supply 	 = 
	{
		shells = {"M2_50_aero_AP","M20_50_aero_APIT"},
		mixes  = {{2,1,1,1}},
		count  = 2000,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 3,
		rates 			 = {1300},
		recoil_coeff 	 = 0.25*1.3,
		barrels_count 	 = 3,
	}
	if tbl.rates then 
		tbl.gun.rates    =  tbl.rates
		tbl.rates	    = nil
	end

	tbl.ejector_pos_connector	= tbl.ejector_pos_connector 	or  "ejector_point" -- all position from connector
	tbl.ejector_dir 			= tbl.ejector_dir
	tbl.supply_position  		= tbl.supply_position or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1800
	tbl.drop_cartridge 			= 204 -- drop shell shape/size from  aircraft_gun_mounts.lua
	tbl.muzzle_pos				= tbl.muzzle_pos or {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 	or  "muzzle_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects =
		{
			{ name = "FireEffect", arg = tbl.effect_arg_number or 436 },
			{ name = "HeatEffectExt", shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
			{ name = "SmokeEffect"},
			{ name = "GatlingEffect", arg = 44, barrels_n = 3, spin_up_t = 0.4, spin_down_t = 0.1}
		}
	end
	return declare_weapon(tbl)
end

function declare_GAU19(clsid, name)
	local data =
	{
	category 		=   CAT_PODS,
	CLSID	 		=  clsid,
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"uh60l_gau19.png",
	displayName		=	_("GAU-19"),-- loadout editor name
	Weight			=	90.2 + 7.2 + 74.9, -- GAU19 + can + ammo
	Weight_Empty	=	90.2 + 7.2,
	Cx_pil			=	0.00024,
	Elements  		= {{ShapeName = name}},
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		=
	{
		UH60_GAU19(
		{
			ejector_dir = {0,-1,-0.5},
			supply_position = {2, -0.3, -0.4}
		})
	},
	shape_table_data = {{file  	 = name;	username = name; index = WSTYPE_PLACEHOLDER;}}
	}
	declare_loadout(data)
end

declare_GAU19("{UH60_GAU19_LEFT}", "uh60l_gau19_left")
declare_GAU19("{UH60_GAU19_RIGHT}", "uh60l_gau19_right")

-- Fixed M134s
function UH60_M134(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "UH60_M134"
	tbl.supply 	 =
	{
		mixes = {
					{1,1,1,1,3}, --day
					{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2}, --night
				},
		shells = {"7_62x51","7_62x51tr","M134_7_62_T"},
		count  = 4000,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 4000,
		rates 			 = {2000,4000},
		recoil_coeff 	 = 0.01, -- 0.5*1.3, -- 0.7*1.3 -- 0.2*1.3
		barrels_count 	 = 6,
	}
	-- if tbl.rates then 
	   -- tbl.gun.rates    =  tbl.rates
	   -- tbl.rates	    = nil
	-- end	
	tbl.ejector_pos 			= tbl.ejector_pos or {0.055, 0.575, -0.872}
	tbl.ejector_pos_connector 	= tbl.ejector_pos_connector or "ejector_point"
	tbl.ejector_dir 			= {-0.3,-1,0}
	tbl.supply_position  		= tbl.supply_position   or {-0.3,-1.0, 0.0}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1000 
	tbl.drop_cartridge 			= 205
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or  {0.83,0.115,1.783}
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector	or  "muzzle_point" 
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or -90  
	tbl.barrel_circular_error	= 0.005
	if  tbl.effects == nil then
		tbl.effects =
		{
			{ name = "FireEffect", arg = tbl.effect_arg_number or 436 },
			{ name = "HeatEffectExt", shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
			{ name = "SmokeEffect"},
			{ name = "GatlingEffect", arg = 582, barrels_n = 6, spin_up_t = 0.4, spin_down_t = 0.1}
		}
	end
	return declare_weapon(tbl)
end

function declare_M134(clsid, name)
	local data = {
		category			= CAT_PODS,
		CLSID				= clsid,
		displayName			= _("M134"),
		Picture				= "uh60l_m134.png",
		attribute			= {wsType_Weapon, wsType_GContainer, wsType_Cannon_Cont, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon		= {wsType_Weapon, wsType_Shell, wsType_Shell_A, wsTypeVulkan},
		Weight				= 27.2 + 41.5,
		Weight_Empty        = 27.2,
		Cx_pil				= 0.0,
		kind_of_shipping	= 2,--SOLID_MUNITION
		gun_mounts			=
		{
			UH60_M134(
			{
				muzzle_pos				= {0.0, 0.0, 0.0},
				count					= 1400,
				azimuth_initial			= 0.0,
				effect_arg_number		= 433,
			})
		},
		shape_table_data =
		{
			{
				name		= name;
				file		= name;
				life		= 1;
				fire		= {0, 1};
				username	= name;
				index		= WSTYPE_PLACEHOLDER;
			},
		},
		Elements =
		{
			[1]	=
			{
				Position	=	{0, 0, 0},
				ShapeName	=	name,
			}, 
		}, -- end of Elements
	}
	declare_loadout(data)
end

declare_M134("{UH60_M134_LEFT}", "uh60l_m134_left")
declare_M134("{UH60_M134_RIGHT}", "uh60l_m134_right")

-- LWL-12
local rockets_data =
{
	["M151"]		= {name = "2.75\" Hydra, UnGd Rkts M151, HE", 				payload_CLSID = "{M151_HYDRA}", mass = 3.9, wsType = {4, 7, 33, 147},	},
	["M156"]		= {name = "2.75\" Hydra, UnGd Rkts M156, Wht Phos", 		payload_CLSID = "{M156_HYDRA}", mass = 4.4, wsType = {4,	7, 33, 148},},
	["M229"]		= {name = "2.75\" Hydra, UnGd Rkts M229, HE", 				payload_CLSID = "{M229_HYDRA}", mass = 4.4, wsType = {4,	7, 33, 148},},
	["M257"]		= {name = "2.75\" Hydra, UnGd Rkts M257, Para Illum",		payload_CLSID = "{M257_HYDRA}", mass = 5.0, wsType = {4, 7, 33, 151},	},
	["M259"]		= {name = "2.75\" Hydra, UnGd Rkts M259, Smoke Marker",		payload_CLSID = "{M259_HYDRA}", mass = 5.0, wsType = {4, 7, 33, 151},	},
	["M274"]		= {name = "2.75\" Hydra, UnGd Rkts M274, Practice Smk",		payload_CLSID = "{M274_HYDRA}", mass = 4.2, wsType = {4, 7, 33, 150},	},
	["APKWS"]		= {name = "2.75\" Hydra, Laser Guided Rkts M151, HE APKWS",	shapeName = "AGR_20", mass = 15, wsType = "weapons.missiles.AGR_20A",	settings = Get_LGU_GUISettings_Preset("WGU59"),},
}

function lwl12(CLSID,element)
	local lau_variant = rockets_data[element] or rockets_data["M151"]
	local data =
	{
		CLSID			= CLSID,
		category		= CAT_ROCKETS,
		Picture			= "uh60l_lwl12.png",
		Count			= 12,
		Cx_pil			= 0.00146484375,
		wsTypeOfWeapon	= lau_variant.wsType,
		attribute		= {4,	7,	32,	WSTYPE_PLACEHOLDER},
		displayName		= _("LWL-12") .. " - 12 x " .. lau_variant.name,
		Elements		= {{ ShapeName	= "uh60l_lwl12", IsAdapter = true }},
		Weight			= 34.5 + 12 * lau_variant.mass,
		Weight_Empty	= 34.5,
		settings		= lau_variant.settings or nil,

		--launch animation block
		weapon_container_data =
		{
			nurs_args			= {4,5},
			launched_arg_state	= 1.0,
		}
	}
	for i = 1,data.Count do
		data.Elements[#data.Elements + 1] =
		{
			connector_name	= "tube_"..i,
			payload_CLSID	= lau_variant.payload_CLSID or nil,
			ShapeName		= lau_variant.shapeName or nil,
		}
	end
	declare_loadout(data)
end

lwl12("UH60_LWL12_M151", "M151")
lwl12("UH60_LWL12_M156", "M156")
lwl12("UH60_LWL12_M229", "M229")
lwl12("UH60_LWL12_M257", "M257")
lwl12("UH60_LWL12_M259", "M259")
lwl12("UH60_LWL12_M274", "M274")
lwl12("UH60_LWL12_APKWS", "APKWS")

function addFuelBag(clsid, station)

	local forbiddenStation1 = 0
	local forbiddenStation2 = 0
	local forbiddenStation3 = 0
	local requiredStation = 0
	local connectorName = ""

	if (station == 1) then
		forbiddenStation1 = 2
		forbiddenStation2 = 6
		forbiddenStation3 = 7
		requiredStation = 7
		connectorName = "pylon_ess_lob_wep"
	elseif (station == 2) then
		forbiddenStation1 = 1
		forbiddenStation2 = 6
		forbiddenStation3 = 7
		requiredStation = 6
		connectorName = "pylon_ess_lib_wep"
	elseif (station == 6) then
		forbiddenStation1 = 1
		forbiddenStation2 = 2
		forbiddenStation3 = 7
		requiredStation = 2
		connectorName = "pylon_ess_rib_wep"
	elseif (station == 7) then
		forbiddenStation1 = 1
		forbiddenStation2 = 2
		forbiddenStation3 = 6
		requiredStation = 1
		connectorName = "pylon_ess_rob_wep"
	end

	local wep =
	{
		CLSID = clsid,
		arg_value = 0,
		connector = connectorName,
		required = {{station = requiredStation,loadout = {clsid}}},
		attach_point_oriented = true,
		forbidden =
		{
			{loadout = { "<CLEAN>" }, station = forbiddenStation1},
			{loadout = { "<CLEAN>" }, station = forbiddenStation2},
			{loadout = { "<CLEAN>" }, station = forbiddenStation3},
		}
	}

	return wep
end


function addPylonWeapon(clsid, station, customConnector)

	local forbiddenStation1 = 0
	local forbiddenStation2 = 0
	local forbiddenStation3 = 0
	local connectorName = ""

	if (station == 1) then
		forbiddenStation1 = 2
		forbiddenStation2 = 6
		forbiddenStation3 = 7
		connectorName = customConnector or "pylon_ess_lob_wep"
	elseif (station == 2) then
		forbiddenStation1 = 1
		forbiddenStation2 = 6
		forbiddenStation3 = 7
		connectorName = customConnector or "pylon_ess_lib_wep"
	elseif (station == 6) then
		forbiddenStation1 = 1
		forbiddenStation2 = 2
		forbiddenStation3 = 7
		connectorName = customConnector or "pylon_ess_rib_wep"
	elseif (station == 7) then
		forbiddenStation1 = 1
		forbiddenStation2 = 2
		forbiddenStation3 = 6
		connectorName = customConnector or "pylon_ess_rob_wep"
	end

	local wep =
	{
		CLSID = clsid,
		arg_value = 0,
		connector = connectorName,
		attach_point_oriented = true,
		forbidden =
		{
			{loadout = { "<CLEAN>" }, station = forbiddenStation1},
			{loadout = { "<CLEAN>" }, station = forbiddenStation2},
			{loadout = { "<CLEAN>" }, station = forbiddenStation3},
		}
	}

	return wep
end