
function makeH60L()
	H60L =
	{
		Name										=	'UH-60L',
		Picture										=	'UH-60L.png',	-- Mission editor loadout picture
		DisplayName									=	_('UH-60L'),

		HumanCockpit = false,
		HumanCockpitPath = current_mod_path..'/Cockpit/',
		WorldID =  WSTYPE_PLACEHOLDER,
		
		shape_table_data 	=
		{
			{
				file  	    = 'UH-60L';
				desrt		= 'UH-60L_destr';
				index       =  WSTYPE_PLACEHOLDER;
				life  	    = 16; --   The strength of the object (ie. lifebar *)
				vis   	    = 3; -- Visibility factor (For a small objects is better to put lower nr).
				fire  	    = { 300, 2}; -- Fire on the ground after destoyed: 300sec 4m
				classname   = "lLandPlane";
				positioning = "BYNORMAL";
			},
			{
				name  ="UH-60L_destr";
				file  ="UH-60L_destr";
				fire  = { 240, 2};
			},
		},

		mapclasskey 		= "P0091000020", -- Utility Helo MIL-2525 symbol
		attribute  			=
		{
			wsType_Air,
			wsType_Helicopter,
			wsType_Cruiser,
			WSTYPE_PLACEHOLDER,
			"Transport helicopters",
			"Refuelable",
		},
		Categories 			= {},
		Rate 				= 30,  -- RewardPoint in Multiplayer

		InternalCargo =
		{
			nominalCapacity = 2400,
			maximalCapacity = 5000,

			para_unit_point = 11,
			unit_point 	  = 11,
			area 	  	  = {2.60, 1.97, 1.50},-- cargo bay dimensions
			far_wall_pos  = {1.475,-1.74,0}, -- coordinates on  point on corner of floor and centerline of far wall , together with area  it will give  geometry of cargo compartment in BCS
			out_door =
			{
				cargo_generic =
				{
					large = true, x = 0, z = 0, heading = math.rad(90),
					mechanicals =
					{
						close = {"CargoBayGates", "Close"},
						board = {"CargoBayGates", "Open"},
						boardable = {{mechanism = "CargoBayGates", states = {"Open"}}, {mechanism = "CargoBayGate0", states = {"Open"}},},
					},
				},
			},
		},
		-------------- Aircraft Physical properties -----------
		length				= 19.76, -- meters
		height				= 5.13,-- meters
		rotor_RPM			= 258,
		M_empty				= 5675, --kg
		M_nominal			= 8500, --kg
		M_max				= 10659.421, --kg 23500lbs
		M_fuel_max			= 1362, -- kg	1 litre = 0.79 kg	1362.75l
		RCS					= 10, -- Radar Cross Section m^2
		IR_emission_coeff	= 0.22, -- 1 is IR emission of Su-27
		------------------------ Gear ---------------------------------------------
		nose_gear_pos 							 = {-7.436, -2.55, 0}, -- {forward/back,up/down,left/right}  used for initial aircraft placement
		--nose_gear_amortizer_direct_stroke        = 0, -- down from nose_gear_pos
		--nose_gear_amortizer_reversal_stroke      = -0.14, -- max strut compression up from nose_gear_pos
		--nose_gear_amortizer_normal_weight_stroke = -0.05,
		nose_gear_wheel_diameter				 = 0.35,

		tand_gear_max							 = math.tan(180), -- nosewheel steering angle.  (tan(32.6)=0.64  +/-32 degrees)

		main_gear_pos 							 = {2.658, -2.7, 1.35},	-- used for initial aircraft placement
		--main_gear_amortizer_direct_stroke	     = 0, --  down from main_gear_pos
		--main_gear_amortizer_reversal_stroke      = -0.48, --   max strut compression up from main_gear_pos
		--main_gear_amortizer_normal_weight_stroke = -0.4,
		main_gear_wheel_diameter				 = 0.5,
		------------------ AI defs ------------------------------
		-- From UH-60A AI (mostly)
		V_max				=	355.584, -- this must be in kph? 192kts
		V_max_cruise		=	296.32,	-- cruise speed 160kts
		Vy_max				=	12.8, --Max climb speed in m/s
		H_stat_max_L		=	4170,
		H_max 				=	5500, --km, max operation height
		H_stat_max			=	3170,
		H_din_two_eng		=	5790,
		H_din_one_eng		=	2900,
		range				=	600, --km, for AI
		flight_time_typical	=	110,
		flight_time_maximum	=	138,
		Vy_land_max			=	12.8, -- landing speed
		Ny_max				=	1.7, --max G for AI
		Sensors =
		{	-- defines what the AI can use in terms of sensors
				OPTIC = {"TADS DVO"}, -- AI can engage enemy at night
				RWR = "Abstract RWR"
		},
		--CanopyGeometry = makeHelicopterCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),
		CanopyGeometry =
		{
				azimuth   = {-100.0, 120.0}, -- pilot view horizontal (AI)
				elevation = {-50.0, 110.0}, -- pilot view vertical (AI)
		},
		---------------------- unknown ---------------------------------------------
		lead_stock_main		=	-0.1,
		lead_stock_support	=	-0.1,
		scheme				=	0,
		fire_rate			=	625,
		cannon_sight_type	=	0,
		------------ AI flight model probably (doesnt affect human FM)---------------
		rotor_height		=	1.791,-- meters
		rotor_diameter		=	16.4,
		blade_chord			=	0.5334,
		blades_number		=	4,
		blade_area			=	3.48,
		fuselage_Cxa0		=	0.45,
		fuselage_Cxa90		=	5.9,
		fuselage_area		=	4.9,
		centering			=	-0.09,
		tail_pos 			= 	{-10.042, 1.76, 0},
		tail_fin_area		=	4.75,
		tail_stab_area		=	2.94,
		thrust_correction	=	0.75,--0.75,
		rotor_MOI			=	8700,
		rotor_pos 			= 	{ 0, 1.646, 0 },

		-- Refuel stuff
		is_tanker                   =  false,
		tanker_type                 =  2,                     -- Tanker type if the plane is tanker
		air_refuel_receptacle_pos   =  {10.586, -1.568, 1.325},

		helicopter_hook_pos = { 0, -2, 0 },
		cargo_radius_in_menu = 2000,

		engines_count		=	4, -- don't ask, you don't want to know...
		engines_nozzles =
		{
			-------------------------ENGINE LEFT-------------------------
			{
				pos     		= {-2.9, 0.1, -1.1}, -- important for heatblur effect
				diameter      = 0.13,
				engine_number = 1,
				--exhaust_length_ab	=	1,
				--exhaust_length_ab_K	=	0.76,
				smokiness_level = 0.01,
			},
			{
				pos     		= {-2.9, 0.1, 1.1}, -- important for heatblur effect
				diameter      = 0.13,
				engine_number = 2,
				--exhaust_length_ab	=	1,
				--exhaust_length_ab_K	=	0.76,
				smokiness_level = 0.01,
			}
		},

		sounderName = "Aircraft/Planes/UH-60L",

		-- Crew config
		crew_stations = "HumanOrchestra",
		crew_size = 4,
		crew_members =
		{
			[1] =
			{	ejection_seat_name	=	0, -- name of object file used for pilot ejection
				drop_canopy_name	=	0, -- name of object file used for canopy jettison
				pos = 	{5.2,0.6,0.1}, -- used for ejection location
				ejection_order    = 1,
				can_be_playable  = true,
				role = "pilot",
				role_display_name = _("Pilot"),
				canopy_arg           = 38,
			},
			[2] =
			{	ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{5.2,0.6,0.1},
				ejection_order    = 2,
				--pilot_body_arg  = 501,
				can_be_playable  = true,
				role = "instructor",
				role_display_name = _("Copilot"),
				canopy_arg           = 400,
			},
			[3] =
			{	ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{4.0,0.6,0.1},
				ejection_order    = 3,
				--pilot_body_arg  = 501,
				can_be_playable  = true,
				role = "lgunner",
				role_display_name = _("Left Gunner"),
				canopy_arg           = 401,
			},
			[4] =
			{	ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{4.0,0.6,0.1},
				ejection_order    = 4,
				--pilot_body_arg  = 501,
				can_be_playable  = true,
				role = "rgunner",
				role_display_name = _("Right Gunner"),
				canopy_arg           = 402,
			},
		},

		fires_pos =
		{
			[1] = {-1.43, 0.21, -0.844}, -- left turbine exit
			[2] = {-1.43, 0.21, 0.844}, -- right turbine exit
		},

		passivCounterm =
		{
			CMDS_Edit = false,
			SingleChargeTotal = 90,
			chaff = {default = 30, increment = 30, chargeSz = 1},
			flare = {default = 60, increment = 60, chargeSz = 1},
		},

		chaff_flare_dispenser =
		{
			--{ dir =  {Z, Y, X}, pos =  {Z, Y, X}, }  -- Z=back/fwd,Y=down/up(+),X=left/right
			-- chaff particles have no ejection power, so spawn them 1m up and back from launcher to give better effect
			[1] = { dir =  {-0.9,-1,-0.1}, pos =  {-3.591 - 1, -0.982 + 1, -0.641}, }, -- chaff
			[2] = { dir =  {1, -1, -0.5}, pos =  {-4.115, -1.27, -0.695}, }, -- flare left
			[3] = { dir =  {1, -1, 0.5}, pos =  {-4.115, -1.27, 0.695}, }, -- flare right
		},

		Pylons =
		{
			pylon(1, 0, 0.797, -1.244, 2.844,
				{
					use_full_connector_position = true,
					arg = 641,
					DisplayName = "L-OB"
				},
				{
					addFuelBag("{UH60_FUEL_TANK_200}", 1),
					addFuelBag("{UH60_FUEL_TANK_230}", 1),

					{
						CLSID = "<CLEAN>",
						arg_value = 1,
						required =
						{
							{station = 2,loadout = {"<CLEAN>"}},
							{station = 6,loadout = {"<CLEAN>"}},
							{station = 7,loadout = {"<CLEAN>"}},
						},
					},
				}
			),
			pylon(2, 0, 0.797, -1.244, 2.058,
				{
					use_full_connector_position = true,
					arg = 641,
					DisplayName = "L-IB"
				},
				{
					addFuelBag("{UH60_FUEL_TANK_200}", 2),
					addFuelBag("{UH60_FUEL_TANK_230}", 2),
					addFuelBag("{UH60_FUEL_TANK_450}", 2),

					{
						CLSID = "<CLEAN>",
						arg_value = 1,
						required =
						{
							{station = 1,loadout = {"<CLEAN>"}},
							{station = 6,loadout = {"<CLEAN>"}},
							{station = 7,loadout = {"<CLEAN>"}},
						},
					},
				}
			),
			pylon(3, 0, 0, 0, 0,
				{
					use_full_connector_position = true,
					arg = 671,
					DisplayName = "L-GUN"
				},
				{
					{
						CLSID = "{UH60_SEAT_GUNNER_L}",
						arg_value = 0.75,
					},
					{
						CLSID = "{UH60L_M2_GUNNER}",
						arg_value = 0.8,
						connector = "pylon_gunner_left_mount"
					},
					{
						CLSID = "{UH60L_M60_GUNNER}",
						arg_value = 0.8,
						connector = "pylon_gunner_left_mount"
					},
				}
			),
			pylon(4, 0, 0, 0, 0,
				{
					use_full_connector_position = false,
					--connector = "pylon2",
					arg = 672,
					DisplayName = "CARGO"
				},
				{
					{
						CLSID = "{UH60_SEAT_CARGO_REAR}",
						arg_value = 0.5,
					},
					{
						CLSID = "{UH60_SEAT_CARGO_ALL}",
						arg_value = 1.0,
					},
					{
						CLSID = "{UH60_IAFTS}",
						arg_value = 0.0,
					},
				}
			),
			pylon(5, 0, 0, 0, 0,
				{
					use_full_connector_position = true,
					arg = 670,
					DisplayName = "R-GUN"
				},
				{
					{
						CLSID = "{UH60_SEAT_GUNNER_R}",
						arg_value = 0.75,
					},
					{
						CLSID = "{UH60L_M2_GUNNER}",
						arg_value = 0.8,
						connector = "pylon_gunner_right_mount"
					},
					{
						CLSID = "{UH60L_M60_GUNNER}",
						arg_value = 0.8,
						connector = "pylon_gunner_right_mount"
					},
				}
			),
			pylon(6, 0, 0.797, -1.244, -2.058,
				{
					use_full_connector_position = true,
					arg = 641,
					DisplayName = "R-IB"
				},
				{
					addFuelBag("{UH60_FUEL_TANK_200}", 6),
					addFuelBag("{UH60_FUEL_TANK_230}", 6),
					addFuelBag("{UH60_FUEL_TANK_450}", 6),

					{
						CLSID = "<CLEAN>",
						arg_value = 1,
						required =
						{
							{station = 1,loadout = {"<CLEAN>"}},
							{station = 2,loadout = {"<CLEAN>"}},
							{station = 7,loadout = {"<CLEAN>"}},
						},
					},
				}
			),
			pylon(7, 0, 0.797, -1.244, -2.844,
				{
					use_full_connector_position = true,
					arg = 641,
					DisplayName = "R-OB"
				},
				{
					addFuelBag("{UH60_FUEL_TANK_200}", 7),
					addFuelBag("{UH60_FUEL_TANK_230}", 7),

					{
						CLSID = "<CLEAN>",
						arg_value = 1,
						required =
						{
							{station = 1,loadout = {"<CLEAN>"}},
							{station = 2,loadout = {"<CLEAN>"}},
							{station = 6,loadout = {"<CLEAN>"}},
						},
					},
				}
			),
		},

		Tasks =
		{ 	-- defined in db_units_planes.lua
			aircraft_task(Transport),
			aircraft_task(Reconnaissance),
			aircraft_task(Airborne),
		},
		DefaultTask = aircraft_task(Transport),

		LandRWCategories = 	-- adds these takeoff and landing options avaliable in mission editor
		{
			[1] =
			{
				Name = "HelicopterCarrier",
			},
			[2] =
			{
				Name = "AircraftCarrier",
			},
		},
		TakeOffRWCategories =
		{	[1] =
			{
				Name = "HelicopterCarrier",
			},
			[2] =
			{
				Name = "AircraftCarrier",
			},
		},

		Damage = verbose_to_dmg_properties( --index meaning see in Scripts\Aircrafts\_Common\Damage.lua
		{
			["ROTOR"]				= {critical_damage = 20, deps_cells = {"BLADE_1_IN", "BLADE_2_IN", "BLADE_3_IN", "BLADE_4_IN"}, construction = {durability = 1000.0, skin = "Steel"},},
			["BLADE_1_IN"]			= {args = {118}, critical_damage = 5, deps_cells = {"BLADE_1_CENTER", "BLADE_1_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_1_CENTER"]		= {args = {117}, critical_damage = 4, deps_cells = {"BLADE_1_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_1_OUT"]			= {args = {116}, critical_damage = 3, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_2_IN"]			= {args = {121}, critical_damage = 5, deps_cells = {"BLADE_2_CENTER", "BLADE_2_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_2_CENTER"]		= {args = {120}, critical_damage = 4, deps_cells = {"BLADE_2_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_2_OUT"]			= {args = {119}, critical_damage = 3, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_3_IN"]			= {args = {124}, critical_damage = 5, deps_cells = {"BLADE_3_CENTER", "BLADE_3_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_3_CENTER"]		= {args = {123}, critical_damage = 4, deps_cells = {"BLADE_3_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_3_OUT"]			= {args = {122}, critical_damage = 3, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_4_IN"]			= {args = {127}, critical_damage = 5, deps_cells = {"BLADE_4_CENTER", "BLADE_4_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_4_CENTER"]		= {args = {126}, critical_damage = 4, deps_cells = {"BLADE_4_OUT"}, construction = {durability = 1.58, skin = "Aluminum"}},
			["BLADE_4_OUT"]			= {args = {125}, critical_damage = 3, construction = {durability = 1.58, skin = "Aluminum"}},

			["TAIL_ROTOR"]			= {args = {238}, critical_damage = 5, construction = {durability = 1.58, skin = "Aluminum"}},

			["WHEEL_R"]				= {critical_damage = 3},
			["WHEEL_L"]				= {critical_damage = 3},
			["WHEEL_F"]				= {critical_damage = 3},

			["COCKPIT"]				= {critical_damage = 3},
			["ENGINE_L"]			= {critical_damage = 3},
			["ENGINE_R"]			= {critical_damage = 3},
			["FUSELAGE_BOTTOM"]		= {critical_damage = 5},
			["FUSELAGE_LEFT_SIDE"]	= {critical_damage = 5},
			["FUSELAGE_RIGHT_SIDE"]	= {critical_damage = 5},
			["FUSELAGE_TOP"]		= {critical_damage = 3},
			["KEEL_CENTER"]			= {critical_damage = 3},
			["KEEL_OUT"]			= {critical_damage = 3},
			["NOSE_BOTTOM"]			= {critical_damage = 3},
			["NOSE_CENTER"]			= {critical_damage = 3},
			["NOSE_LEFT"]			= {critical_damage = 3},
			["NOSE_RIGHT"]			= {critical_damage = 3},
			["STABILIZATOR_L"]		= {critical_damage = 3},
			["TAIL_BOTTOM"]			= {critical_damage = 3},
			["TAIL_LEFT_SIDE"]		= {critical_damage = 3},
			["TAIL_RIGHT_SIDE"]		= {critical_damage = 3},
			["TAIL_TOP"]			= {critical_damage = 3},
			["WING_L_IN"]			= {critical_damage = 5}, -- left ess
			["WING_R_IN"]			= {critical_damage = 5}, -- right ess
			["PITOT"]				= {critical_damage = 4}, -- fuel probe
		}),

		Failures =
		{ -- not working yet
			{ id = 'engfail',	label = _('ENGINE'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rotor',		label = _('ROTOR'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		},

		DamageParts =
		{	-- parts that fall off when aircraft is hit or crashes
			[1] = "UH-60L_Tail",  --wing right
			[2] = "UH-60L_Skid",  --wing left
			--[3] = "",    --nose part
			[4] = "UH-60L_Skid",  -- tail part
			[5] = "UH-60L_Rotor",	--blade
		},

		--transmits draw arguments over multiplyer for others to see
		net_animation =
		{
			9, --collective
			11, -- stick roll
			15, --stick pitch
			37,-- main rotor spin
			14, -- stab
			900, -- rotor blur
			22, -- probe
			640, -- probe vis
			641, -- esss
			-- LIGHTS
			600, -- lower white ac
			601, -- upper white ac
			602, -- lower red ac
			603, -- upper red ac
			604, -- pos l/r non esss
			605, -- cabin blue
			606, -- cabin white
			607, -- ll extend/retract
			608, -- ll toggle
			609, -- pos l/r esss
			610, -- pos tail
			611, -- sl extend/retract
			612, -- sl swivel
			613, -- sl toggle
			614, -- formation lights
			250, -- glareshield
			251, -- dome light
			-- DOORS
			38, -- plt door
			400, -- cplt door
			401, -- l cargo door
			402, -- r cargo door
			403, -- l gunner hatch
			404, -- r gunner hatch
			501, -- pedal brakes
			700,701,702,703 -- gunners
		},

		sound_name = "uh60l_ExteriorRotor", -- rotor sound from Sounds/sdef

		engine_data =
		{  -- most of these are unknown right now, but they are only for AI
			power_take_off	=	473,
			power_max	=	473,
			power_WEP	=	473,
			power_TH_k =
			{
				[1] = 	{0,	-230.8,	2245.6},
				[2] = 	{0,	-230.8,	2245.6},
				[3] = 	{0,	-325.4,	2628.9},
				[4] = 	{0,	-235.6,	1931.9},
			},
			SFC_k = 	{2.045e-007,	-0.0006328,	0.803},
			power_RPM_k = 	{-0.08639,	0.24277,	0.84175},
			power_RPM_min	=	9.1384,
			sound_name	= "uh60l_ExteriorEngine", -- engine sound from Sounds/sdef
		},

		-- Comms config
		HumanRadio =
		{
			frequency = 116.0,
			editable = true,
			minFrequency = 30.0,
			maxFrequency = 399.975,
			modulation = MODULATION_AM,
		},

		panelRadio =
		{
			[1] =
			{
				name = _("AN/ARC-201 (1)"), --30 to 87.975 MHz FM
				range =
				{
					{min = 30.0, max = 87.975}
				},
				channels =
				{
					[1] = { name = _("AN/ARC-201 Channel 1"),	default = 30.0}, --, connect = true}, -- default
					[2] = { name = _("AN/ARC-201 Channel 2"),	default = 31.0},
					[3] = { name = _("AN/ARC-201 Channel 3"),	default = 32.0},
					[4] = { name = _("AN/ARC-201 Channel 4"),	default = 33.0},
					[5] = { name = _("AN/ARC-201 Channel 5"),	default = 40.0},
					[6] = { name = _("AN/ARC-201 Channel 6"),	default = 41.0},
					[7] = { name = _("AN/ARC-201 Channel 0"),	default = 42.0},
					[8] = { name = _("AN/ARC-201 Channel RG"),	default = 50.0},
				},
			},
			[2] =
			{
				name = _("AN/ARC-164(V)"), -- 225.000 to 399.975 MHz AM
				range =
				{
					{min = 225.0, max = 399.975}
				},
				channels =
				{  -- matches L-39C except for channel 8, which was changed to a Georgian airport and #20 which is NTTR only (for now).  This radio goes 1-20 not 0-19.
					[1] = { name = _("AN/ARC-164 Channel 1"),	default = 264.0},	-- mineralnye-vody (URMM) : 264.0
					[2] = { name = _("AN/ARC-164 Channel 2"),	default = 265.0},	-- nalchik (URMN) : 265.0
					[3] = { name = _("AN/ARC-164 Channel 3"),	default = 256.0},	-- sochi-adler (URSS) : 256.0
					[4] = { name = _("AN/ARC-164 Channel 4"),	default = 254.0},	-- maykop-khanskaya (URKH), nellis (KLSV) : 254.0
					[5] = { name = _("AN/ARC-164 Channel 5"),	default = 250.0},	-- anapa (URKA) : 250.0
					[6] = { name = _("AN/ARC-164 Channel 6"),	default = 270.0},	-- beslan (URMO) : 270.0
					[7] = { name = _("AN/ARC-164 Channel 7"),	default = 257.0},	-- krasnodar-pashkovsky (URKK) : 257.0
					[8] = { name = _("AN/ARC-164 Channel 8"),	default = 258.0},	-- sukhumi-babushara (UGSS) : 255.0
					[9] = { name = _("AN/ARC-164 Channel 9"),	default = 262.0},	-- kobuleti (UG5X) : 262.0
					[10] = { name = _("AN/ARC-164 Channel 10"),	default = 259.0},	-- gudauta (UG23) : 259.0
					[11] = { name = _("AN/ARC-164 Channel 11"),	default = 268.0},	-- tbilisi-soganlug (UG24) : 268.0
					[12] = { name = _("AN/ARC-164 Channel 12"),	default = 269.0},	-- tbilisi-vaziani (UG27) : 269.0
					[13] = { name = _("AN/ARC-164 Channel 13"),	default = 260.0},	-- batumi (UGSB) : 260.0
					[14] = { name = _("AN/ARC-164 Channel 14"),	default = 263.0},	-- kutaisi-kopitnari (UGKO) : 263.0
					[15] = { name = _("AN/ARC-164 Channel 15"),	default = 261.0},	-- senaki-kolkhi (UGKS) :  261.0
					[16] = { name = _("AN/ARC-164 Channel 16"),	default = 267.0},	-- tbilisi-lochini (UGTB) : 267.0
					[17] = { name = _("AN/ARC-164 Channel 17"),	default = 251.0},	-- krasnodar-center (URKI), creech (KINS) : 251.0
					[18] = { name = _("AN/ARC-164 Channel 18"),	default = 253.0},	-- krymsk (URKW), mccarran (KLAS) : 253.0
					[19] = { name = _("AN/ARC-164 Channel 19"),	default = 266.0},	-- mozdok (XRMF) : 266.0
					[20] = { name = _("AN/ARC-164 Channel 20"),	default = 252.0},	-- N/A, groom lake/homey (KXTA) : 252.0
				},
			},
			[3] =
			{
				name = _("AN/ARC-186(V)"), --116.000 to 151.975 MHz AM
				range =
				{
					{min = 30.000, max = 151.975}
				},
				channels =
				{
					[1] = { name = _("AN/ARC-186 Channel 1"),	default = 138.000}, --, connect = true}, -- default
					[2] = { name = _("AN/ARC-186 Channel 2"),	default = 121.500}, --, connect = true}, -- default
					[3] = { name = _("AN/ARC-186 Channel 3"),	default = 127.000},
					[4] = { name = _("AN/ARC-186 Channel 4"),	default = 127.500},
					[5] = { name = _("AN/ARC-186 Channel 5"),	default = 130.000},
					[6] = { name = _("AN/ARC-186 Channel 6"),	default = 133.000},
					[7] = { name = _("AN/ARC-186 Channel 7"),	default = 133.500},
					[8] = { name = _("AN/ARC-186 Channel 8"),	default = 135.000},
					[9] = { name = _("AN/ARC-186 Channel 9"),	default = 136.000},
					[10] = { name = _("AN/ARC-186 Channel 10"),	default = 139.000},
					[11] = { name = _("AN/ARC-186 Channel 11"),	default = 151.000},
					[12] = { name = _("AN/ARC-186 Channel 12"),	default = 118.500},
					[13] = { name = _("AN/ARC-186 Channel 13"),	default = 118.100},
					[14] = { name = _("AN/ARC-186 Channel 14"),	default = 118.900},
					[15] = { name = _("AN/ARC-186 Channel 15"),	default = 118.400},
					[16] = { name = _("AN/ARC-186 Channel 16"),	default = 118.450},
					[17] = { name = _("AN/ARC-186 Channel 17"),	default = 134.000},
					[18] = { name = _("AN/ARC-186 Channel 18"),	default = 134.500},
					[19] = { name = _("AN/ARC-186 Channel 19"),	default = 137.000},
					[20] = { name = _("AN/ARC-186 Channel 20"),	default = 137.500},
				},
			},
			[4] =
			{
				name = _("AN/ARC-201 (2)"), --30 to 87.975 MHz FM
				range =
				{
					{min = 30.0, max = 87.975}
				},
				channels =
				{
					[1] = { name = _("AN/ARC-201 Channel 1"),	default = 30.0}, --, connect = true}, -- default
					[2] = { name = _("AN/ARC-201 Channel 2"),	default = 31.0},
					[3] = { name = _("AN/ARC-201 Channel 3"),	default = 32.0},
					[4] = { name = _("AN/ARC-201 Channel 4"),	default = 33.0},
					[5] = { name = _("AN/ARC-201 Channel 5"),	default = 40.0},
					[6] = { name = _("AN/ARC-201 Channel 6"),	default = 41.0},
					[7] = { name = _("AN/ARC-201 Channel 0"),	default = 42.0},
					[8] = { name = _("AN/ARC-201 Channel RG"),	default = 50.0},
				},
			},
			[5] =
			{
				name = _("AN/ARC-220"), -- 2.000 to 29.9999 MHz
				range =
				{
					{min = 2.0, max = 29.9999}
				},
				channels =
				{
					[1] = { name = _("AN/ARC-220 Channel 1"),	default = 3.000}, --, connect = true}, -- default
					[2] = { name = _("AN/ARC-220 Channel 2"),	default = 10.00}, --, connect = true}, -- default
				},
			},
		},

		lights_data =
		{
			typename =	"collection",
			lights 	 =
			{
				[1]	=
				{
					typename	=	"collection", -- strobe
					lights =
					{
						{typename = "argnatostrobelight", argument_1 = 600, period = 1.2, phase_shift = 0},	-- white lower
						{typename = "argnatostrobelight", argument_1 = 601, period = 1.2, phase_shift = 0},	-- white upper
					},
				},
				[2]	=
				{
					typename = "collection", -- spot
					lights =
					{
						{typename  = "argumentlight",	argument  = 613}, -- landing light?
					},
				},
				[3]	=
				{
					typename = "collection", -- nav
					lights =
					{
						{typename  = "argumentlight",	argument  = 604}, -- left/right
						{typename  = "argumentlight",	argument  = 610}, -- tail
						{typename  = "argumentlight",	argument  = 251}, -- tail
						{typename  = "argumentlight",	argument  = 605}, -- tail
					},
				},
				[4]	=
				{
					typename = "collection", -- formation
					lights =
					{
						{typename  = "argumentlight",	argument  = 614},
					},
				},
				[5] = {}, -- tips
				[6] = {}, -- refuel
				[7] =
				{
					typename	=	"collection", -- strobe
					lights =
					{
						{typename = "argnatostrobelight", argument_1 = 602, period = 1.2, phase_shift = 0},	-- red lower
						{typename = "argnatostrobelight", argument_1 = 603, period = 1.2, phase_shift = 0},	-- red upper
					},
				},  -- Anti-Collision
			},
		},

		input_profile_entry = "UH-60L",

		InheriteCommonCallnames = true,
		SpecificCallnames =
		{
			["USA"] =
			{
				{_('Jolly'),			'Jolly'},
				{_('Pedro'),			'Pedro'},
			}
		},

		encyclopediaAnimation =
		{
			args =
			{
				[401] = 1.000000,
				[402] = 1.000000,
				[403] = 1.000000,
				[404] = 1.000000,
				[701] = -0.7,
				[703] = -0.7,
			},
		},

		-- Aircraft Additional Properties
		AddPropAircraft =
		{
			{
				id = "FuelProbeEnabled",
				control = "checkbox",
				label = _("Enable Fuel Probe"),
				defValue = false,
				weightWhenOn = 0,
				arg = 640,
			},
			--{id = "SoloFlight", control = 'checkbox' , label = _('Solo Flight'), defValue = false, weightWhenOn = 0},
			{
				id = "NetCrewControlPriority" ,
				control = 'comboList',
				label = _('Aircraft Control Priority'),
				playerOnly = true,
				values =
				{
					{id =  0, dispName = _("Pilot")},
					{id =  1, dispName = _("Instructor")},
					{id = -1, dispName = _("Ask Always")},
					{id = -2, dispName = _("Equally Responsible")}
				},
				defValue  = 1,
				wCtrl     = 150
			},
		},

		rotor_animation =
		{
			tail_rotor =
			{
				blades_count	= 4,
				modelBlade_FBX	= "/models/uh60l_tail_blade.fbx",
				rotor_direction	= 1,
				rotor_locations = {{POSITION_WILL_BE_TAKEN_FROM_CONNECTOR}},
			},
			--main rotor
			rotor_locations = {{POSITION_WILL_BE_TAKEN_FROM_CONNECTOR}},
			rotor_models =
			{{
				modelRotorHub_EDM  		= "uh60l_main_rotor",
				modelRotorHubLod_FBX 	= "/models/uh60l_main_rotor_lod.fbx",
				boundRotorHub_FBX		= "/models/uh60l_main_rotor_bb.fbx",
				boundBlade_FBX			= "/models/uh60l_main_blade_bb.fbx",
				modelBlade_FBX 			=
				{
					"/models/uh60l_main_blade.fbx",
					"/models/uh60l_main_blade_damage1.fbx",
					"/models/uh60l_main_blade_damage2.fbx",
					"/models/uh60l_main_blade_damage3.fbx"
				}
			}}
		}
	}
	return H60L
end

UH60L = makeH60L()
UH60L.Name = 'UH-60L'
UH60L.DisplayName = _('UH-60L')

UH60L_DAP = makeH60L()
UH60L_DAP.Name = 'UH-60L_DAP'
UH60L_DAP.DisplayName = _('UH-60L \'DAP\'')

UH60L_DAP.attribute =
{
	wsType_Air,
	wsType_Helicopter,
	wsType_Battleplane,
	WSTYPE_PLACEHOLDER,
	"Attack helicopters",
	"Transport helicopters",
}
UH60L_DAP.Pylons =
{
	pylon(1, 0, 0.797, -1.244, 2.844,
		{
			use_full_connector_position = true,
			arg = 641,
			DisplayName = "L-OB"
		},
		{
			addPylonWeapon("{M260_M151}", 1, "pylon_ess_lob_wep_pc"),
			addPylonWeapon("{M260_M156}", 1, "pylon_ess_lob_wep_pc"),
			addPylonWeapon("{M260_M229}", 1, "pylon_ess_lob_wep_pc"),
			addPylonWeapon("{M260_M257}", 1, "pylon_ess_lob_wep_pc"),
			addPylonWeapon("{M260_M259}", 1, "pylon_ess_lob_wep_pc"),
			addPylonWeapon("{M260_M274}", 1, "pylon_ess_lob_wep_pc"),
			addPylonWeapon("{M260_APKWS_M151}", 1, "pylon_ess_lob_wep_pc"),

			addPylonWeapon("{M261_MK151}",		1),
			addPylonWeapon("{M261_M151_M433}",	1),
			addPylonWeapon("{M261_MK156}",		1),
			addPylonWeapon("{M261_M229}",		1),
			addPylonWeapon("{M261_M257}",		1),
			addPylonWeapon("{M261_M259}",		1),
			addPylonWeapon("{M261_M274}",		1),
			addPylonWeapon("{M261_M282}",		1),

			addPylonWeapon("UH60_LWL12_M151",	1),
			addPylonWeapon("UH60_LWL12_M156",	1),
			addPylonWeapon("UH60_LWL12_M229",	1),
			addPylonWeapon("UH60_LWL12_M257",	1),
			addPylonWeapon("UH60_LWL12_M259",	1),
			addPylonWeapon("UH60_LWL12_M274",	1),
			addPylonWeapon("UH60_LWL12_APKWS",	1),

			addPylonWeapon("OH58D_FIM_92_L",	1, "pylon_ess_lob_wep_pc"),

			addPylonWeapon("UH60_AGM_114_L1",	1, "pylon_ess_lob_wep_pc"),
			addPylonWeapon("UH60_AGM_114_L",	1, "pylon_ess_lob_wep_pc"),

			addPylonWeapon("{M299_EMPTY}",								1),
			addPylonWeapon("{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",	1),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_PORT}",			1),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_STARBOARD}",		1),
			addPylonWeapon("{M299_2xAGM_114K}",							1),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_PORT}",			1),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_STARBOARD}",		1),

			addPylonWeapon("{FN_HMP400}",	1),
			-- RMP not possible with mods since can't launch specific substations

			addFuelBag("{UH60_FUEL_TANK_200}", 1),
			addFuelBag("{UH60_FUEL_TANK_230}", 1),

			{
				CLSID = "<CLEAN>",
				arg_value = 1,
				required =
				{
					{station = 2,loadout = {"<CLEAN>"}},
					{station = 6,loadout = {"<CLEAN>"}},
					{station = 7,loadout = {"<CLEAN>"}},
				},
			},
		}
	),
	pylon(2, 0, 0.797, -1.244, 2.058,
		{
			use_full_connector_position = true,
			arg = 641,
			DisplayName = "L-IB"
		},
		{
			addPylonWeapon("{M260_M151}", 2, "pylon_ess_lib_wep_pc"),
			addPylonWeapon("{M260_M156}", 2, "pylon_ess_lib_wep_pc"),
			addPylonWeapon("{M260_M229}", 2, "pylon_ess_lib_wep_pc"),
			addPylonWeapon("{M260_M257}", 2, "pylon_ess_lib_wep_pc"),
			addPylonWeapon("{M260_M259}", 2, "pylon_ess_lib_wep_pc"),
			addPylonWeapon("{M260_M274}", 2, "pylon_ess_lib_wep_pc"),
			addPylonWeapon("{M260_APKWS_M151}", 2, "pylon_ess_lib_wep_pc"),

			addPylonWeapon("{M261_MK151}",		2),
			addPylonWeapon("{M261_M151_M433}",	2),
			addPylonWeapon("{M261_MK156}",		2),
			addPylonWeapon("{M261_M229}",		2),
			addPylonWeapon("{M261_M257}",		2),
			addPylonWeapon("{M261_M259}",		2),
			addPylonWeapon("{M261_M274}",		2),
			addPylonWeapon("{M261_M282}",		2),

			addPylonWeapon("UH60_LWL12_M151",	2),
			addPylonWeapon("UH60_LWL12_M156",	2),
			addPylonWeapon("UH60_LWL12_M229",	2),
			addPylonWeapon("UH60_LWL12_M257",	2),
			addPylonWeapon("UH60_LWL12_M259",	2),
			addPylonWeapon("UH60_LWL12_M274",	2),
			addPylonWeapon("UH60_LWL12_APKWS",	2),

			addPylonWeapon("OH58D_FIM_92_L",	2, "pylon_ess_lib_wep_pc"),

			addPylonWeapon("OH58D_AGM_114_L1",	2, "pylon_ess_lib_wep_pc"),
			addPylonWeapon("OH58D_AGM_114_L",	2, "pylon_ess_lib_wep_pc"),

			addPylonWeapon("{M299_EMPTY}",								2),
			addPylonWeapon("{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",	2),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_PORT}",			2),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_STARBOARD}",		2),
			addPylonWeapon("{M299_2xAGM_114K}",							2),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_PORT}",			2),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_STARBOARD}",		2),

			addPylonWeapon("{FN_HMP400}",	2),
			addPylonWeapon("{UH60_M230_LEFT}",	2),
			addPylonWeapon("{UH60_GAU19_LEFT}",	2),
			addPylonWeapon("{UH60_M134_LEFT}",	2),

			addFuelBag("{UH60_FUEL_TANK_200}", 2),
			addFuelBag("{UH60_FUEL_TANK_230}", 2),
			addFuelBag("{UH60_FUEL_TANK_450}", 2),

			{
				CLSID = "<CLEAN>",
				arg_value = 1,
				required =
				{
					{station = 1,loadout = {"<CLEAN>"}},
					{station = 6,loadout = {"<CLEAN>"}},
					{station = 7,loadout = {"<CLEAN>"}},
				},
			},
		}
	),
	pylon(3, 0, 0, 0, 0,
		{
			use_full_connector_position = true,
			arg = 671,
			DisplayName = "L-GUN"
		},
		{
			{
				CLSID = "{UH60_SEAT_GUNNER_L}",
				arg_value = 0.75,
			},
			{
				CLSID = "{UH60L_M134_GUNNER}",
				arg_value = 1.0,
				connector = "pylon_gunner_left_m134"
			},
		}
	),
	pylon(4, 0, 0, 0, 0,
		{
			use_full_connector_position = false,
			arg = 672,
			DisplayName = "CARGO"
		},
		{
			{
				CLSID = "{UH60_SEAT_CARGO_REAR}",
				arg_value = 0.5,
			},
			{
				CLSID = "{UH60_SEAT_CARGO_ALL}",
				arg_value = 1.0,
			},
			{
				CLSID = "{UH60_IAFTS}",
				arg_value = 0.0,
			},
		}
	),
	pylon(5, 0, 0, 0, 0,
		{
			use_full_connector_position = true,
			arg = 670,
			DisplayName = "R-GUN"
		},
		{
			{
				CLSID = "{UH60_SEAT_GUNNER_R}",
				arg_value = 0.75,
			},
			{
				CLSID = "{UH60L_M134_GUNNER}",
				arg_value = 1.0,
				connector = "pylon_gunner_right_m134"
			},
		}
	),
	pylon(6, 0, 0.797, -1.244, -2.058,
		{
			use_full_connector_position = true,
			arg = 641,
			DisplayName = "R-IB"
		},
		{
			addPylonWeapon("{M260_M151}", 6, "pylon_ess_rib_wep_pc"),
			addPylonWeapon("{M260_M156}", 6, "pylon_ess_rib_wep_pc"),
			addPylonWeapon("{M260_M229}", 6, "pylon_ess_rib_wep_pc"),
			addPylonWeapon("{M260_M257}", 6, "pylon_ess_rib_wep_pc"),
			addPylonWeapon("{M260_M259}", 6, "pylon_ess_rib_wep_pc"),
			addPylonWeapon("{M260_M274}", 6, "pylon_ess_rib_wep_pc"),
			addPylonWeapon("{M260_APKWS_M151}", 6, "pylon_ess_rib_wep_pc"),

			addPylonWeapon("{M261_MK151}",		6),
			addPylonWeapon("{M261_M151_M433}",	6),
			addPylonWeapon("{M261_MK156}",		6),
			addPylonWeapon("{M261_M229}",		6),
			addPylonWeapon("{M261_M257}",		6),
			addPylonWeapon("{M261_M259}",		6),
			addPylonWeapon("{M261_M274}",		6),
			addPylonWeapon("{M261_M282}",		6),

			addPylonWeapon("UH60_LWL12_M151",	6),
			addPylonWeapon("UH60_LWL12_M156",	6),
			addPylonWeapon("UH60_LWL12_M229",	6),
			addPylonWeapon("UH60_LWL12_M257",	6),
			addPylonWeapon("UH60_LWL12_M259",	6),
			addPylonWeapon("UH60_LWL12_M274",	6),
			addPylonWeapon("UH60_LWL12_APKWS",	6),

			addPylonWeapon("{FN_HMP400}",	6),
			addPylonWeapon("{UH60_M230_RIGHT}",	6),
			addPylonWeapon("{UH60_GAU19_RIGHT}",	6),
			addPylonWeapon("{UH60_M134_RIGHT}",	6),

			addPylonWeapon("OH58D_FIM_92_R",	6, "pylon_ess_rib_wep_pc"),

			addPylonWeapon("OH58D_AGM_114_R1",	6, "pylon_ess_rib_wep_pc"),
			addPylonWeapon("OH58D_AGM_114_R",	6, "pylon_ess_rib_wep_pc"),

			addPylonWeapon("{M299_EMPTY}",								6),
			addPylonWeapon("{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",	6),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_PORT}",			6),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_STARBOARD}",		6),
			addPylonWeapon("{M299_2xAGM_114K}",							6),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_PORT}",			6),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_STARBOARD}",		6),

			addFuelBag("{UH60_FUEL_TANK_200}", 6),
			addFuelBag("{UH60_FUEL_TANK_230}", 6),
			addFuelBag("{UH60_FUEL_TANK_450}", 6),

			{
				CLSID = "<CLEAN>",
				arg_value = 1,
				required =
				{
					{station = 1,loadout = {"<CLEAN>"}},
					{station = 2,loadout = {"<CLEAN>"}},
					{station = 7,loadout = {"<CLEAN>"}},
				},
			},
		}
	),
	pylon(7, 0, 0.797, -1.244, -2.844,
		{
			use_full_connector_position = true,
			arg = 641,
			DisplayName = "R-OB"
		},
		{
			addPylonWeapon("{M260_M151}", 7, "pylon_ess_rob_wep_pc"),
			addPylonWeapon("{M260_M156}", 7, "pylon_ess_rob_wep_pc"),
			addPylonWeapon("{M260_M229}", 7, "pylon_ess_rob_wep_pc"),
			addPylonWeapon("{M260_M257}", 7, "pylon_ess_rob_wep_pc"),
			addPylonWeapon("{M260_M259}", 7, "pylon_ess_rob_wep_pc"),
			addPylonWeapon("{M260_M274}", 7, "pylon_ess_rob_wep_pc"),
			addPylonWeapon("{M260_APKWS_M151}", 7, "pylon_ess_rob_wep_pc"),

			addPylonWeapon("{M261_MK151}",		7),
			addPylonWeapon("{M261_M151_M433}",	7),
			addPylonWeapon("{M261_MK156}",		7),
			addPylonWeapon("{M261_M229}",		7),
			addPylonWeapon("{M261_M257}",		7),
			addPylonWeapon("{M261_M259}",		7),
			addPylonWeapon("{M261_M274}",		7),
			addPylonWeapon("{M261_M282}",		7),

			addPylonWeapon("UH60_LWL12_M151",	7),
			addPylonWeapon("UH60_LWL12_M156",	7),
			addPylonWeapon("UH60_LWL12_M229",	7),
			addPylonWeapon("UH60_LWL12_M257",	7),
			addPylonWeapon("UH60_LWL12_M259",	7),
			addPylonWeapon("UH60_LWL12_M274",	7),
			addPylonWeapon("UH60_LWL12_APKWS",	7),

			addPylonWeapon("OH58D_FIM_92_R",	7, "pylon_ess_rob_wep_pc"),

			addPylonWeapon("OH58D_AGM_114_R1",	7, "pylon_ess_rob_wep_pc"),
			addPylonWeapon("OH58D_AGM_114_R",	7, "pylon_ess_rob_wep_pc"),

			addPylonWeapon("{M299_EMPTY}",	7),
			addPylonWeapon("{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",	7),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_PORT}",	7),
			addPylonWeapon("{M299_3xAGM_114K_OUTBOARD_STARBOARD}",	7),
			addPylonWeapon("{M299_2xAGM_114K}",	7),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_PORT}",	7),
			addPylonWeapon("{M299_1xAGM_114K_OUTBOARD_STARBOARD}",	7),

			addPylonWeapon("{FN_HMP400}",	7),

			addFuelBag("{UH60_FUEL_TANK_200}", 7),
			addFuelBag("{UH60_FUEL_TANK_230}", 7),

			{
				CLSID = "<CLEAN>",
				arg_value = 1,
				required =
				{
					{station = 1,loadout = {"<CLEAN>"}},
					{station = 2,loadout = {"<CLEAN>"}},
					{station = 6,loadout = {"<CLEAN>"}},
				},
			},
		}
	),
}
UH60L_DAP.AddPropAircraft =
{
	{
		id = "FuelProbeEnabled",
		control = "checkbox",
		label = _("Enable Fuel Probe"),
		defValue = true,
		weightWhenOn = 0,
		arg = 640,
	},
	--{id = "SoloFlight", control = 'checkbox' , label = _('Solo Flight'), defValue = false, weightWhenOn = 0},
	{
		id = "NetCrewControlPriority" ,
		control = 'comboList',
		label = _('Aircraft Control Priority'),
		playerOnly = true,
		values =
		{
			{id =  0, dispName = _("Pilot")},
			{id =  1, dispName = _("Instructor")},
			{id = -1, dispName = _("Ask Always")},
			{id = -2, dispName = _("Equally Responsible")}
		},
		defValue  = 1,
		wCtrl     = 150
	},
}
UH60L_DAP.encyclopediaAnimation =
{
	args =
	{
		[640] = 1.000000,
		[401] = 1.000000,
		[402] = 1.000000,
		[403] = 1.000000,
		[404] = 1.000000,
		[700] = -1.0,
		[702] = 1.0,
	},
}
UH60L_DAP.Tasks =
{
	aircraft_task(CAP),
	aircraft_task(CAS),
	aircraft_task(GroundAttack),
	aircraft_task(Escort),
	aircraft_task(Transport),
	aircraft_task(AntishipStrike),
}
UH60L_DAP.DefaultTask = aircraft_task(CAS),

add_aircraft(UH60L_DAP)
add_aircraft(UH60L)
