package.path = package.path .. ";" .. lfs.currentdir() .. "/LuaSocket/?.lua"
package.cpath = package.cpath .. ";" .. lfs.currentdir() .. "/LuaSocket/?.dll"

local BH = {}
local BH_Callbacks = {}
local socket = require("socket")
local terrain = require('terrain')
local tcp = nil
local log_file = nil
local debug = false
local ownID = 0
local scannedUnits = {}
local interval = 600 -- How often to update the units list (in simulation frames)
local frameCount = 0
local scanDistance = 5000 -- Maximum distance to scan for targets (in meters)

function BH_Callbacks.onSimulationStart()
    if debug then
        log_file = io.open(lfs.writedir() .. "/Logs/BHdebug.txt", "w")
        log_file:write("onSimulationStart\n")
    end
end

function BH_Callbacks.onShowBriefing()

end

function BH_Callbacks.onSimulationFrame()
    -- Simple check that player aircraft is spwaned
    local selfData = Export.LoGetSelfData()
    if selfData then
        if selfData.Name == "UH-60L" or selfData.Name == "UH-60L_DAP" then

            --log_file:write("check for gunners\n")
            local payload = Export.LoGetPayloadInfo()
            local station3 = payload.Stations[3]
            local station5 = payload.Stations[5]

            -- Do we have gunners?
            if station3.weapon.level3 == 6 or station5.weapon.level3 == 6 then
                --wsType_Shell
                --log_file:write("we have gunners\n")

                local playerID = Export.LoGetPlayerPlaneId()

                -- Forces reset if player changes aircraft - the callback below isn't reliable
                if ownID ~= playerID then
                    if tcp ~= nil then
                        tcp:close()
                        tcp = nil
                    end
                    ownID = playerID
                end

                local player = Export.LoGetObjectById(playerID)

                local RHnearestTargetID = 0
                local LHnearestTargetID = 0
                local RHtargetDist = 1000
                local LHtargetDist = 1000

                -- Update the units list every 'interval' frames
                frameCount = frameCount + 1
                if frameCount >= interval then
                    BH.updateUnitsList()
                    frameCount = 0
                end

                for k, v in pairs(scannedUnits) do
                    local obj = Export.LoGetObjectById(k)

                    if obj then
                        local dist = math.sqrt(((obj.Position.x - player.Position.x) * (obj.Position.x - player.Position.x)) + ((obj.Position.y - player.Position.y) * (obj.Position.y - player.Position.y)) + ((obj.Position.z - player.Position.z) * (obj.Position.z - player.Position.z)))
                        local heading = math.deg(math.atan2((obj.Position.z - player.Position.z), (obj.Position.x - player.Position.x)))
                        heading = heading - math.deg(player.Heading)

                        if (heading < 0) then
                            heading = heading + 360.0
                        elseif (heading > 360.0) then
                            heading = heading - 360.0
                        end

                        --log_file:write(string.format("Unfiltered target: %s; heading: %f; dist: %f;\n", k, heading, dist))

                        -- Disabled - terrain checks always fail in multiplayer
                        --local terr = terrain.isVisible(player.Position.x, player.Position.y, player.Position.z, obj.Position.x,obj.Position.y,obj.Position.z)
                        --log_file:write(string.format("terrain check: %s: %f, %f, %f to %f, %f, %f;\n", tostring(terr), player.Position.x, player.Position.y, player.Position.z, obj.Position.x,obj.Position.y,obj.Position.z))
                        --if (terr) then
                        if (dist < RHtargetDist and heading > 5.0 and heading < 165.0) then
                            RHnearestTargetID = k
                            RHtargetDist = dist
                            --log_file:write(string.format("RH target: %s; heading: %f; dist: %f;\n", k, heading, dist))
                        elseif (dist < LHtargetDist and heading < 355.0 and heading > 195.0) then
                            LHnearestTargetID = k
                            LHtargetDist = dist
                            --log_file:write(string.format("LH target: %s; heading: %f; dist: %f;\n", k, heading, dist))
                        end
                        --end

                        --log_file:write(string.format("target: %s; heading: %f; dist: %f; RHnearestTargetID: %i; LHnearestTargetID: %i; \n", k, heading, dist, RHnearestTargetID, LHnearestTargetID))
                    end
                end

                if (RHnearestTargetID > 0 or LHnearestTargetID > 0) then

                    local RHTargetName = ""
                    local RHTargetPosX = 0
                    local RHTargetPosY = 0
                    local RHTargetPosZ = 0
                    local LHTargetName = ""
                    local LHTargetPosX = 0
                    local LHTargetPosY = 0
                    local LHTargetPosZ = 0

                    if (RHnearestTargetID > 0) then
                        local RHtarget = Export.LoGetObjectById(RHnearestTargetID)
                        RHTargetName = RHtarget.Name
                        RHTargetPosX = RHtarget.Position.x
                        RHTargetPosY = RHtarget.Position.y
                        RHTargetPosZ = RHtarget.Position.z
                    end
                    if (LHnearestTargetID > 0) then
                        local LHtarget = Export.LoGetObjectById(LHnearestTargetID)
                        LHTargetName = LHtarget.Name
                        LHTargetPosX = LHtarget.Position.x
                        LHTargetPosY = LHtarget.Position.y
                        LHTargetPosZ = LHtarget.Position.z
                    end
                    local LHtarget = Export.LoGetObjectById(LHnearestTargetID)

                    if (tcp ~= nil) then
                        tcp:send(string.format("%d,%s,%f,%f,%f,%d,%s,%f,%f,%f;\n", RHnearestTargetID, RHTargetName, RHTargetPosX, RHTargetPosY, RHTargetPosZ, LHnearestTargetID, LHTargetName, LHTargetPosX, LHTargetPosY, LHTargetPosZ))
                        tcp:send("\n")

                        if debug then
                            log_file:write(string.format("%d,%s,%f,%f,%f,%d,%s,%f,%f,%f;\n", RHnearestTargetID, RHTargetName, RHTargetPosX, RHTargetPosY, RHTargetPosZ, LHnearestTargetID, LHTargetName, LHTargetPosX, LHTargetPosY, LHTargetPosZ))
                        end
                    else
                        tcp = socket.tcp()
                        tcp:connect("127.0.0.1", 9800)
                        if debug then
                            log_file:write("attempt to connect\n")
                        end
                    end
                else
                    if debug then
                        --log_file:write("no target\n")
                    end
                end
            end
        end
    end
end

function BH_Callbacks.onGameEvent(arg1, arg2, arg3, arg4)

    if arg1 == "change_slot" then
        tcp:close()
        tcp = nil

        if debug then
            log_file:write("change slot\n")
        end
    end
end

function BH_Callbacks.onSimulationStop()
    tcp:close()

    if debug then
        log_file:write("onSimulationStop\n")

        if log_file then
            log_file:close()
            log_file = nil
        end
    end
end

function BH.updateUnitsList()
    local playerID = Export.LoGetPlayerPlaneId()
    local player = Export.LoGetObjectById(playerID)
    scannedUnits = {}
    if player then
        local o = Export.LoGetWorldObjects()
        for k, v in pairs(o) do
            if v.Flags
                    and not v.Flags.Static
                    and v.Flags.AI_ON
                    and k ~= playerID
                    and v.CoalitionID ~= player.CoalitionID
                    and v.CoalitionID ~= 0 then
                local dist = math.sqrt(((v.Position.x - player.Position.x) * (v.Position.x - player.Position.x)) + ((v.Position.y - player.Position.y) * (v.Position.y - player.Position.y)) + ((v.Position.z - player.Position.z) * (v.Position.z - player.Position.z)))
                if dist < scanDistance then
                    scannedUnits[k] = v
                end
            end
        end
    end
end

DCS.setUserCallbacks(BH_Callbacks)
