local DbOption = require('Options.DbOption')
local Range = DbOption.Range

local i18n	    = require('i18n')
local _ = i18n.ptranslate

local oms       = require('optionsModsScripts')

function script_path() 
	local luafileloc = debug.getinfo(2, "S").source:sub(2)
	local ti, tj = string.find(luafileloc, "Options")
	local temploc = string.sub(luafileloc, 1, ti-1)
    return temploc
end 

local relativeloc = script_path()
modulelocation = lfs.currentdir().."\\"..relativeloc

local tblCPLocalList = oms.getTblCPLocalList(modulelocation)

return
{
		FFB	= DbOption.new():setValue(false):checkbox(),
		CyclicTrimType		= DbOption.new():setValue(1):combo(
		{
			DbOption.Item(_('None')):Value(0),
			DbOption.Item(_('Instant')):Value(1),
			DbOption.Item(_('Fade In/Fade Out')):Value(2),
			DbOption.Item(_('Central Position Mode')):Value(3),
		}),
		PedalTrimType		= DbOption.new():setValue(0):combo(
		{
			DbOption.Item(_('None')):Value(0),
			DbOption.Item(_('Instant')):Value(1),
			DbOption.Item(_('Fade In/Fade Out')):Value(2),
			DbOption.Item(_('Central Position Mode')):Value(3),
		}),
		BoostResistance = DbOption.new():setValue(0):slider(Range(0, 100)),
}
