dofile(LockOn_Options.common_script_path.."elements_defs.lua")

SetCustomScale(1.0)

function AddElement(object)
	object.screenspace = ScreenType.SCREENSPACE_TRUE
	object.use_mipfilter = true
	Add(object)
end

local aspect        = LockOn_Options.screen.aspect
local width         = 0.6
local height        = width * 0.36
local verts =
{
	{-width / 2, height / 2},
	{width / 2, height / 2},
	{width / 2, -height / 2},
	{-width / 2, -height / 2},
}

local font = MakeFont({used_DXUnicodeFontData = "baseFont"}, {255,255,255,255})
local greenfont = MakeFont({used_DXUnicodeFontData = "baseFont"}, {0,255,0,255})
local redfont = MakeFont({used_DXUnicodeFontData = "baseFont"}, {255,0,0,255})
local stringdefs = {0.004, 0.77 * 0.004, -0.001, 0}

base       			= CreateElement "ceMeshPoly"
base.name		    = "base"
base.primitivetype  = "triangles"
base.material       = MakeMaterial(nil,{0, 0, 0, 60})
base.vertices       = verts
base.indices        = default_box_indices
base.init_pos       = {(aspect - width),(1 - height / 2)}
base.element_params = {"SHOW_GUNNER_ROE"} 
base.controllers    = {{"parameter_in_range", 0, 1}}
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
AddElement(base)

text = CreateElement "ceStringPoly"
text.parent_element = base.name
text.value = "AI GUNNER ROE:"
text.alignment = "CenterCenter"
text.stringdefs = stringdefs
text.material = font
text.init_pos = {-width/6.5,height/4}
text.h_clip_relation = h_clip_relations.REWRITE_LEVEL
AddElement(text)

hold = Copy(text)
hold.value = "HOLD"
hold.material = greenfont
hold.init_pos = {width/3,height/4}
hold.element_params = {"GUNNER_ROE"} 
hold.controllers    = {{"parameter_in_range", 0, 0}}
AddElement(hold)

fire = Copy(text)
fire.value = "FIRE"
fire.material = redfont
fire.init_pos = {width/3,height/4}
fire.element_params = {"GUNNER_ROE"} 
fire.controllers    = {{"parameter_in_range", 0, 1}}
AddElement(fire)

control = Copy(text)
control.value = "<-CONTROL->"
control.init_pos = {0,0}
--text.element_params = {"GUNNER_ROE"} 
--text.controllers    = {{"parameter_in_range", 0, 0}}
AddElement(control)

controlLefttGunner = Copy(text)
controlLefttGunner.value = "GUNNER"
controlLefttGunner.init_pos = {-width/3,0}
controlLefttGunner.element_params = {"LEFT_GUNNER_CONTROL"} 
controlLefttGunner.controllers    = {{"parameter_in_range", 0, 0}}
AddElement(controlLefttGunner)

controlLeftPilot = Copy(text)
controlLeftPilot.value = "PILOT"
controlLeftPilot.init_pos = {-width/3,0}
controlLeftPilot.element_params = {"LEFT_GUNNER_CONTROL"} 
controlLeftPilot.controllers    = {{"parameter_in_range", 0, 1}}
AddElement(controlLeftPilot)

controlRightGunner = Copy(text)
controlRightGunner.value = "GUNNER"
controlRightGunner.init_pos = {width/3,0}
controlRightGunner.element_params = {"RIGHT_GUNNER_CONTROL"} 
controlRightGunner.controllers    = {{"parameter_in_range", 0, 0}}
AddElement(controlRightGunner)

controlRightPilot = Copy(text)
controlRightPilot.value = "PILOT"
controlRightPilot.init_pos = {width/3,0}
controlRightPilot.element_params = {"RIGHT_GUNNER_CONTROL"} 
controlRightPilot.controllers    = {{"parameter_in_range", 0, 1}}
AddElement(controlRightPilot)

ammo = Copy(text)
ammo.value = "<-AMMO->"
ammo.init_pos = {0,-height/4}
AddElement(ammo)

ammoLeft = Copy(text)
ammoLeft.value = ""
ammoLeft.init_pos = {-width/3,-height/4}
ammoLeft.element_params = {"LEFT_GUNNER_AMMO"} 
ammoLeft.controllers = {{"text_using_parameter",0,0}}
ammoLeft.formats         = {"%.0f"}
AddElement(ammoLeft)

ammoRight = Copy(text)
ammoRight.value = ""
ammoRight.init_pos = {width/3,-height/4}
ammoRight.element_params = {"RIGHT_GUNNER_AMMO"} 
ammoRight.controllers = {{"text_using_parameter",0,0}}
ammoRight.formats         = {"%.0f"}
AddElement(ammoRight)