dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/circuitBreakerHandles.lua")
dofile(LockOn_Options.common_script_path.."../../../Database/wsTypes.lua")


local update_time_step = 0.01
make_default_activity(update_time_step)
local dev = GetSelf()

local isMasterPwrSwitchOn = 0
local isMasterArmSwitchOn = 0
local isPylonLOBPowerSwitchOn = 0
local isPylonLIBPowerSwitchOn = 0
local isPylonRIBPowerSwitchOn = 0
local isPylonROBPowerSwitchOn = 0

local isMasterPwrOn = 0
local isMasterArmOn = 0
local isPylonLOBPowered = 0
local isPylonLIBPowered = 0
local isPylonRIBPowered = 0
local isPylonROBPowered = 0

local rocketRipple = 0
local rocketPairs = 0

local firstRocketFired = false
local rocketSingleRippleCurrentPylon = 0
local updateRocketPylon = false
local rocketInterval = 0

local agMissileFired = false

local uncagePressed = 0
local aaMissileFired = false

local gunnerWeaponsPowered = 0
local gunnerWeaponsPowerSwitchOn = 0
local leftGunnerControl = 0
local rightGunnerControl = 0
local leftGunnerControlSwitch = 0
local rightGunnerControlSwitch = 0

local iCommandPlaneFire = 84
local iCommandPlaneFireOff = 85
local iCommandPlanePickleOn = 350
local iCommandPlanePickleOff = 351

local selectorOFF = 0
local selectorGUN = 1
local selectorRKT = 2
local selectorMSL = 3
local selectorATAS = 4
local selector = 0

dev:listen_command(device_commands.fireWeapons)
dev:listen_command(device_commands.pylonPower)
dev:listen_command(device_commands.pylonPowerLOB)
dev:listen_command(device_commands.pylonPowerLIB)
dev:listen_command(device_commands.pylonPowerRIB)
dev:listen_command(device_commands.pylonPowerROB)
dev:listen_command(device_commands.rocketPair)
dev:listen_command(device_commands.rocketRipple)
dev:listen_command(device_commands.wpnSelector)
dev:listen_command(device_commands.wpnSelectorInc)
dev:listen_command(device_commands.wpnSelectorDec)
dev:listen_command(device_commands.toggleROEWindow)
dev:listen_command(device_commands.showROEWindow)

local ir_missile_lock_param = get_param_handle("WS_IR_MISSILE_LOCK")
local ir_missile_az_param = get_param_handle("WS_IR_MISSILE_TARGET_AZIMUTH")
local ir_missile_el_param = get_param_handle("WS_IR_MISSILE_TARGET_ELEVATION")
local ir_missile_des_az_param = get_param_handle("WS_IR_MISSILE_SEEKER_DESIRED_AZIMUTH")
local ir_missile_des_el_param = get_param_handle("WS_IR_MISSILE_SEEKER_DESIRED_ELEVATION")

local paramShowGunnerROE = get_param_handle("SHOW_GUNNER_ROE")

local paramCB = get_param_handle(paramCB_NO2ACINST)


function SetCommand(command,value)
	if (get_aircraft_type() == "UH-60L_DAP") then
		if command == device_commands.fireWeapons then
			if value > 0 then
				if rocketInterval == 0 then
					fireWeapon()
					rocketInterval = 60/1000
				end
			else
				dispatch_action(nil,iCommandPlaneFireOff)
				dispatch_action(nil,iCommandPlanePickleOff)
				firstRocketFired = false
				agMissileFired = false
				aaMissileFired = false
				--print_message_to_user("Trigger Up")
			end
		elseif command == device_commands.uncageWeapon then
			uncagePressed = value
		elseif command == device_commands.pylonPower then
			isMasterPwrSwitchOn = value
		elseif command == device_commands.pylonPowerToggle then
			if value > 0 then
				isMasterPwrSwitchOn = 1 - isMasterPwrSwitchOn
				dev:performClickableAction(device_commands.pylonPower, isMasterPwrSwitchOn, true)
			end
		elseif command == device_commands.pylonPowerLOB then
			isPylonLOBPowerSwitchOn = value
		elseif command == device_commands.pylonPowerLOBToggle then
			if value > 0 then
				isPylonLOBPowerSwitchOn = 1 - isPylonLOBPowerSwitchOn
				dev:performClickableAction(device_commands.pylonPowerLOB, isPylonLOBPowerSwitchOn, true)
			end
		elseif command == device_commands.pylonPowerLIB then
			isPylonLIBPowerSwitchOn = value
		elseif command == device_commands.pylonPowerLIBToggle then
			if value > 0 then
				isPylonLIBPowerSwitchOn = 1 - isPylonLIBPowerSwitchOn
				dev:performClickableAction(device_commands.pylonPowerLIB, isPylonLIBPowerSwitchOn, true)
			end
		elseif command == device_commands.pylonPowerRIB then
			isPylonRIBPowerSwitchOn = value
					elseif command == device_commands.pylonPowerRIBToggle then
			if value > 0 then
				isPylonRIBPowerSwitchOn = 1 - isPylonRIBPowerSwitchOn
				dev:performClickableAction(device_commands.pylonPowerRIB, isPylonRIBPowerSwitchOn, true)
			end
		elseif command == device_commands.pylonPowerROB then
			isPylonROBPowerSwitchOn = value
		elseif command == device_commands.pylonPowerROBToggle then
			if value > 0 then
				isPylonROBPowerSwitchOn = 1 - isPylonROBPowerSwitchOn
				dev:performClickableAction(device_commands.pylonPowerROB, isPylonROBPowerSwitchOn, true)
			end
		elseif command == device_commands.rocketPair then
			rocketPairs = value
		elseif command == device_commands.rocketPairToggle then
			if value > 0 then
				rocketPairs = 1 - rocketPairs
				dev:performClickableAction(device_commands.rocketPair, rocketPairs, true)
			end
		elseif command == device_commands.rocketRipple then
			rocketRipple = value
		elseif command == device_commands.rocketRippleToggle then
			if value > 0 then
				rocketRipple = 1 - rocketRipple
				dev:performClickableAction(device_commands.rocketRipple, rocketRipple, true)
			end
		elseif command == device_commands.masterArm then
			isMasterArmSwitchOn = value
		elseif command == device_commands.masterArmToggle then
			if value > 0 then
				isMasterArmSwitchOn = 1 - isMasterArmSwitchOn
				dev:performClickableAction(device_commands.masterArm, isMasterArmSwitchOn, true)
			end
		elseif command == device_commands.gunnerPwr then
			gunnerWeaponsPowerSwitchOn = value
		elseif command == device_commands.gunnerPwrToggle then
			if value > 0 then
				gunnerWeaponsPowerSwitchOn = 1 - gunnerWeaponsPowerSwitchOn
				dev:performClickableAction(device_commands.gunnerPwr, gunnerWeaponsPowerSwitchOn, true)
			end
		elseif command == device_commands.leftGunControl then
			leftGunnerControlSwitch = value
		elseif command == device_commands.leftGunControlToggle then
			if value > 0 then
				leftGunnerControlSwitch = 1 - leftGunnerControlSwitch
				dev:performClickableAction(device_commands.leftGunControl, leftGunnerControlSwitch, true)
			end
		elseif command == device_commands.rightGunControl then
			rightGunnerControlSwitch = value
		elseif command == device_commands.rightGunControlToggle then
			if value > 0 then
				rightGunnerControlSwitch = 1 - rightGunnerControlSwitch
				dev:performClickableAction(device_commands.rightGunControl, rightGunnerControlSwitch, true)
			end
		elseif command == device_commands.wpnSelector then
			selector = round(value * 4)
		elseif command == device_commands.wpnSelectorInc then
			if value > 0 and selector < 4 then
				selector = selector + 1
				dev:performClickableAction(device_commands.wpnSelector, selector / 4, false)
			end
		elseif command == device_commands.wpnSelectorDec then
			if value > 0 and selector > 0 then
				selector = selector - 1
				dev:performClickableAction(device_commands.wpnSelector, selector / 4, false)
			end
		end
	end
	
	if command == device_commands.toggleROEWindow then
		if value > 0 then
			paramShowGunnerROE:set(1 - paramShowGunnerROE:get())
		end
	elseif command == device_commands.showROEWindow then
		paramShowGunnerROE:set(value)
	end
end

function post_initialize()
	isMasterPwrSwitchOn = 0
	isMasterArmSwitchOn = 0
	isPylonLOBPowerSwitchOn = 0
	isPylonLIBPowerSwitchOn = 0
	isPylonRIBPowerSwitchOn = 0
	isPylonROBPowerSwitchOn = 0

	isMasterPwrOn = 0
	isMasterArmOn = 0
	isPylonLOBPowered = 0
	isPylonLIBPowered = 0
	isPylonRIBPowered = 0
	isPylonROBPowered = 0

	rocketRipple = 0
	rocketPairs = 0
	firstRocketFired = false
	rocketSingleRippleCurrentPylon = 0
	updateRocketPylon = false

	rocketInterval = 0
	sndhost = create_sound_host("COCKPIT_ARMS","HEADPHONES",0,0,0)
	aim9seek = sndhost:create_sound("Aircrafts/Cockpits/AIM9")
	aim9lock = sndhost:create_sound("Aircrafts/Cockpits/SidewinderHigh")

	gunnerWeaponsPowered = 0
	leftGunnerControl = 0
	rightGunnerControl = 0

	local birth = LockOn_Options.init_conditions.birth_place	
	if birth=="GROUND_HOT" or birth=="AIR_HOT" then
		if (get_aircraft_type() == "UH-60L_DAP") then
			dev:performClickableAction(device_commands.pylonPowerLOB,1)
			dev:performClickableAction(device_commands.pylonPowerLIB,1)
			dev:performClickableAction(device_commands.pylonPowerRIB,1)
			dev:performClickableAction(device_commands.pylonPowerROB,1)
			dev:performClickableAction(device_commands.pylonPower,1)
		end
	elseif birth=="GROUND_COLD" then 
	end
end

function update()
	local hasPower = paramCB:get()
	rocketInterval = rocketInterval - update_time_step
	if (rocketInterval < 0) then
		rocketInterval = 0
	end

	-- DAP weapons panel - this doesn't seem to be reliable in the post init so call in update to ensure it works
	if (get_aircraft_type() == "UH-60L_DAP") then
		get_param_handle("IS_DAP"):set(1.0)
	else
		get_param_handle("IS_DAP"):set(0.0)
	end

	-- Power and switch states
	isMasterPwrOn = isMasterPwrSwitchOn * hasPower
	isMasterArmOn = isMasterArmSwitchOn
	isPylonLOBPowered = isPylonLOBPowerSwitchOn
	isPylonLIBPowered = isPylonLIBPowerSwitchOn
	isPylonRIBPowered = isPylonRIBPowerSwitchOn
	isPylonROBPowered = isPylonROBPowerSwitchOn
	gunnerWeaponsPowered = gunnerWeaponsPowerSwitchOn
	leftGunnerControl = leftGunnerControlSwitch
	rightGunnerControl = rightGunnerControlSwitch

	get_param_handle("MASTER_ARM"):set(isMasterPwrOn * isMasterArmOn)

	local snd_pitch = 0.9
	aim9seek:update(snd_pitch, nil, nil)
	get_param_handle("IR_SEEKER_UNCAGED"):set(0)

	-- Update ATAS
	if isMasterPwrOn > 0 and (seekerToneOnPylon(0) or seekerToneOnPylon(1) or seekerToneOnPylon(5) or seekerToneOnPylon(6)) then
		if dev:get_station_info(0).weapon.level3 == wsType_AA_Missile and dev:get_station_info(0).count > 0 and seekerToneOnPylon(0) then
			dev:select_station(0)
		elseif dev:get_station_info(1).weapon.level3 == wsType_AA_Missile and dev:get_station_info(1).count > 0 and seekerToneOnPylon(1) then
			dev:select_station(1)
		elseif dev:get_station_info(5).weapon.level3 == wsType_AA_Missile and dev:get_station_info(5).count > 0 and seekerToneOnPylon(5) then
			dev:select_station(5)
		elseif dev:get_station_info(6).weapon.level3 == wsType_AA_Missile and dev:get_station_info(6).count > 0 and seekerToneOnPylon(6) then
			dev:select_station(6)
		end

		ir_missile_des_el_param:set(math.rad(2.0)) -- desired elevation is 2 deg pitch up from centerline

		if ir_missile_lock_param:get() > 0.0 then
			if uncagePressed > 0.0 then
				aim9seek:stop()
				aim9lock:play_continue()
				get_param_handle("IR_SEEKER_UNCAGED"):set(1)
			else
				local az=ir_missile_az_param:get()
				local el=ir_missile_el_param:get()
				az=math.deg(az)
				el=math.deg(el)
				local ofs=math.sqrt(az*az+el*el)
				local max_dist=4.0

				if ofs>max_dist then
					snd_pitch = 0.9
				else
					snd_pitch = 0.9 + (max_dist - ofs)
				end
				--print_message_to_user(snd_pitch)
				aim9seek:update(snd_pitch, nil, nil)
				aim9seek:play_continue()
				aim9lock:stop()
			end
		else
			aim9seek:update(snd_pitch, nil, nil)
			aim9seek:play_continue()
			aim9lock:stop()
		end
	else
		aim9seek:stop()
		aim9lock:stop()
	end

	-- AI GUNNERS
	get_param_handle("LEFT_GUNNER_CONTROL"):set(leftGunnerControl)
	get_param_handle("RIGHT_GUNNER_CONTROL"):set(rightGunnerControl)

	if (gunnerWeaponsPowered > 0 and isMasterArmOn > 0) or get_aircraft_type() ~= "UH-60L_DAP" then
		if (get_param_handle("LEFT_GUNNER_FIRE"):get() > 0 and leftGunnerControl == 0) then
			dev:launch_station(2)
		else
			dispatch_action(nil, Keys.iCommandSwitchMasterArm)
			dispatch_action(nil, Keys.iCommandSwitchMasterArm)
		end

		if (get_param_handle("RIGHT_GUNNER_FIRE"):get() > 0 and rightGunnerControl == 0) then
			dev:launch_station(4)
		else
			dispatch_action(nil, Keys.iCommandSwitchMasterArm)
			dispatch_action(nil, Keys.iCommandSwitchMasterArm)
		end
	end

	-- Update UI params
	get_param_handle("LEFT_GUNNER_AMMO"):set(dev:get_station_info(2).count)
	get_param_handle("RIGHT_GUNNER_AMMO"):set(dev:get_station_info(4).count)

	setPylonType(0)
	setPylonType(1)
	setPylonType(5)
	setPylonType(6)

	get_param_handle("IR_SEEKER_ELEVATION"):set(get_param_handle("WS_IR_MISSILE_TARGET_ELEVATION"):get() - get_param_handle("WS_IR_MISSILE_SEEKER_DESIRED_ELEVATION"):get())
	get_param_handle("AMS_SELECTION_INDEX"):set(selector)
end

function seekerToneOnPylon(pylon)
	local ret = false
	local pylonPowered = false
	if pylon == 0 then
		pylonPowered = isPylonLOBPowered
	elseif pylon == 1 then
		pylonPowered = isPylonLIBPowered
	elseif pylon == 5 then
		pylonPowered = isPylonRIBPowered
	elseif pylon == 6 then
		pylonPowered = isPylonROBPowered
	end

	local aa = (selector == selectorATAS and dev:get_station_info(pylon).weapon.level3 == wsType_AA_Missile)
	local as = (selector == selectorMSL and dev:get_station_info(pylon).weapon.level3 == wsType_AS_Missile and dev:get_station_info(pylon).weapon.level4 == AGM_122)
	ret = pylonPowered > 0 and (aa or as) and dev:get_station_info(pylon).count > 0
	return ret
end

function tryFirePylon(pwrCond, idx, nextIdx)
	local success = false
	if (pwrCond) then
		local station = dev:get_station_info(idx)

		if selector == selectorGUN then
			if station.count > 0 and station.weapon.level2 == wsType_Shell then
				dev:launch_station(idx,2)
				dispatch_action(nil,iCommandPlaneFire)
				dispatch_action(nil,iCommandPlanePickle)
				success = true
			end
		elseif selector == selectorRKT then
			if station.count > 0 and (station.weapon.level2 == wsType_NURS or (station.weapon.level3 == wsType_AS_Missile and station.weapon.level4 == 292)) and (firstRocketFired == false or rocketRipple > 0) then
				if (rocketPairs > 0) then
					dev:launch_station(idx,2)
					dispatch_action(nil,iCommandPlaneFire)
					dispatch_action(nil,iCommandPlanePickle)
					success = true
					if (idx == 5) then
						firstRocketFired = true
					end
				else
					if (rocketSingleRippleCurrentPylon == idx) then
						dev:launch_station(idx,2)
						dispatch_action(nil,iCommandPlaneFire)
						dispatch_action(nil,iCommandPlanePickle)
						success = true
						firstRocketFired = true
						updateRocketPylon = true
					end
				end
			else
				if (rocketSingleRippleCurrentPylon == idx and (firstRocketFired == false or rocketRipple > 0) ) then
					rocketSingleRippleCurrentPylon = nextIdx
				end
			end
		elseif selector == selectorMSL then
			if station.count > 0 and station.weapon.level3 == wsType_AS_Missile and agMissileFired == false then
				dev:launch_station(idx,2)
				dispatch_action(nil,iCommandPlaneFire)
				dispatch_action(nil,iCommandPlanePickle)
				success = true
				agMissileFired = true
			end
		elseif selector == selectorATAS then
			if station.count > 0 and station.weapon.level3 == wsType_AA_Missile and aaMissileFired == false then
				if ir_missile_lock_param:get() > 0.0 then
					dev:launch_station(idx,2)
					dispatch_action(nil,iCommandPlaneFire)
					dispatch_action(nil,iCommandPlanePickle)
					success = true
					aaMissileFired = true
				end
			end
		end
	else
		if (rocketSingleRippleCurrentPylon == idx and (firstRocketFired == false or rocketRipple > 0) ) then
			rocketSingleRippleCurrentPylon = nextIdx
		end
	end

	return success
end

function fireWeapon()
	if (isMasterPwrOn > 0 and isMasterArmOn > 0) then
		local pylon0Fired = tryFirePylon((isPylonLOBPowered > 0), 0, 6)
		local pylon1Fired = tryFirePylon((isPylonROBPowered > 0), 6, 1)
		local pylon5Fired = tryFirePylon((isPylonLIBPowered > 0), 1, 5)
		local pylon6Fired = tryFirePylon((isPylonRIBPowered > 0), 5, 0)

		-- If not fired, could be that rocket cycle is looking for restart so try once again
		if (pylon0Fired == false and pylon1Fired == false and pylon5Fired == false and pylon6Fired == false) then
			local pylon0Fired = tryFirePylon((isPylonLOBPowered > 0), 0, 6)
			local pylon1Fired = tryFirePylon((isPylonROBPowered > 0), 6, 1)
			local pylon5Fired = tryFirePylon((isPylonLIBPowered > 0), 1, 5)
			local pylon6Fired = tryFirePylon((isPylonRIBPowered > 0), 5, 0)
		end

		firstRocketFired = true -- in the event pairs doesn't set it
		
		if (updateRocketPylon) then
			if (rocketSingleRippleCurrentPylon == 0) then
				rocketSingleRippleCurrentPylon = 6
			elseif (rocketSingleRippleCurrentPylon == 1) then
				rocketSingleRippleCurrentPylon = 5
			elseif (rocketSingleRippleCurrentPylon == 5) then
				rocketSingleRippleCurrentPylon = 0
			elseif (rocketSingleRippleCurrentPylon == 6) then
				rocketSingleRippleCurrentPylon = 1
			end

			updateRocketPylon = false
		end
	end

	if (gunnerWeaponsPowered > 0 and isMasterArmOn > 0) then
		if (leftGunnerControl == 1) then
			dev:launch_station(2)
		end

		if (rightGunnerControl == 1) then
			dev:launch_station(4)
		end
	end
end

function setPylonType(idx)
	local station = dev:get_station_info(idx)
	local val = 0
	if station.count > 0 then
		if station.weapon.level2 == wsType_Shell then
			val = 1
		elseif (station.weapon.level2 == wsType_NURS or (station.weapon.level3 == wsType_AS_Missile and station.weapon.level4 == 292)) then
			val = 2
		elseif station.weapon.level3 == wsType_AS_Missile then
			val = 3
		elseif station.weapon.level3 == wsType_AA_Missile then
			val = 4
		end
	end

	local pylonPowered = 0
	if idx == 0 then
		pylonPowered = isPylonLOBPowered
	elseif idx == 1 then
		pylonPowered = isPylonLIBPowered
	elseif idx == 5 then
		pylonPowered = isPylonRIBPowered
	elseif idx == 6 then
		pylonPowered = isPylonROBPowered
	end

	get_param_handle("PYLON_"..idx.."_WPN_TYPE"):set(val * pylonPowered)
end

need_to_be_closed = false

--[[
Getdev(devs.WEAPON_SYSTEM) metatable:
weapons meta["__index"] = {}
weapons meta["__index"]["get_station_info"] = function: 00000000CCCC5780
weapons meta["__index"]["listen_event"] = function: 00000000CCC8E000
weapons meta["__index"]["drop_flare"] = function: 000000003C14E208
weapons meta["__index"]["set_ECM_status"] = function: 00000000CCCC76E0
weapons meta["__index"]["performClickableAction"] = function: 00000000CCE957B0
weapons meta["__index"]["get_ECM_status"] = function: 00000000CCE37BC0
weapons meta["__index"]["launch_station"] = function: 00000000CCC36A30
weapons meta["__index"]["SetCommand"] = function: 00000000CCE52820
weapons meta["__index"]["get_chaff_count"] = function: 00000000CCBDD650
weapons meta["__index"]["emergency_jettison"] = function: 00000000CCC26810
weapons meta["__index"]["set_target_range"] = function: 000000003AB0FDD0
weapons meta["__index"]["set_target_span"] = function: 0000000027E4E970
weapons meta["__index"]["get_flare_count"] = function: 00000000CCCC57D0
weapons meta["__index"]["get_target_range"] = function: 00000000CCC26710
weapons meta["__index"]["get_target_span"] = function: 00000000CCCC7410
weapons meta["__index"]["SetDamage"] = function: 00000000CCC384B0
weapons meta["__index"]["drop_chaff"] = function: 00000000CCE37AA0
weapons meta["__index"]["select_station"] = function: 00000000CC5C26F0
weapons meta["__index"]["listen_command"] = function: 0000000038088060
weapons meta["__index"]["emergency_jettison_rack"] = function: 00000000720F15F0
--]]
