dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/circuitBreakerHandles.lua")
dofile(LockOn_Options.common_script_path.."../../../Database/wsTypes.lua")
dofile(LockOn_Options.script_path.."devices.lua")

local dev = GetSelf()
local weapons
local sensor_data = get_base_data()
local update_time_step = 0.01
make_default_activity(update_time_step)

local paramTailWheelLockLight = get_param_handle("LIGHTING_MISC_TAILWHEELLOCK")
local tailWheelLockedState = 0 -- 0 = unlocked, 1 = locked, -1 = transition
local tailWheelLockPwrState
local tailWheelLockTarget
local tailWheelLockTime

local wiperMode = 1
local wiperTargetVal = 0
local wiperFwd = true

local canopyTargetState = 0

local doorCpltTgt = 0
local doorLGnrTgt = 0
local doorRGnrTgt = 0
local doorLCargoTgt = 0
local doorRCargoTgt = 0

local doorCpltState = 0
local doorLGnrState = 0
local doorRGnrState = 0
local doorLCargoState = 0
local doorRCargoState = 0

local paramControlsIndicator  = get_param_handle("SHOW_CONTROLS")

local pilotVisState = 0

local doorsAttached = true

local pilotVisorState = 0
local pilotVisorTargetState = 0


-- Canopy handling
dev:listen_command(Keys.toggleDoors)
dev:listen_command(device_commands.visor)
dev:listen_command(device_commands.visorToggle)
dev:listen_command(device_commands.miscTailWheelLock)
dev:listen_command(Keys.miscTailWheelLockToggle)
dev:listen_command(device_commands.doorCplt)
dev:listen_command(device_commands.doorPlt)
dev:listen_command(device_commands.doorLGnr)
dev:listen_command(device_commands.doorRGnr)
dev:listen_command(device_commands.doorLCargo)
dev:listen_command(device_commands.doorRCargo)
dev:listen_command(Keys.toggleCopilotDoor)
dev:listen_command(Keys.toggleLeftCargoDoor)
dev:listen_command(Keys.toggleRightCargoDoor)
dev:listen_command(Keys.toggleLeftGunnerDoor)
dev:listen_command(Keys.toggleRightGunnerDoor)
dev:listen_command(Keys.toggleDoorsOpen)
dev:listen_command(Keys.toggleDoorsClose)

dev:listen_command(Keys.wiperSelectorInc)
dev:listen_command(Keys.wiperSelectorDec)
dev:listen_command(Keys.wiperSelectorCycle)

-- Wipers
dev:listen_command(device_commands.wiperSelector)

-- Controls Indicator
dev:listen_command(Keys.showControlInd)

dev:listen_command(Keys.iCommandCockpitShowPilotOnOff)

dev:listen_event("CanopyOpen")
dev:listen_event("CanopyClose")

function CockpitEvent(event,val)
	if event == "CanopyOpen" then
		canopyTargetState = 1
		canopyPos = 1
		doorsAttached = false

		set_aircraft_draw_argument_value(650, 1)
		set_aircraft_draw_argument_value(651, 1)
		get_param_handle("DOOR_VIS"):set(1)
	elseif event == "CanopyClose" then
		canopyTargetState = 0
		canopyPos = 0
		doorsAttached = true

		set_aircraft_draw_argument_value(650, 0)
		set_aircraft_draw_argument_value(651, 0)
		get_param_handle("DOOR_VIS"):set(0)
	end
end

function post_initialize()
	--show_param_handles_list()

	tailWheelLockedState = 0
	tailWheelLocked = 0
	local dev = GetSelf()
	tailWheelLockPwrState = paramCB_TAILWHEELLOCK:get()
	local birth = LockOn_Options.init_conditions.birth_place
	if birth=="GROUND_HOT" or birth=="AIR_HOT" then
		dev:performClickableAction(device_commands.miscTailWheelLock, 1, true)
	elseif birth=="GROUND_COLD" then
	end

	get_param_handle("DOOR_VIS"):set(0)
	canopyTargetState = 0
	canopyPos = 0
	doorsAttached = true
	set_aircraft_draw_argument_value(650, 0)
	set_aircraft_draw_argument_value(651, 0)

	if (get_player_crew_index() == 0) then
		get_param_handle("PILOT_HEAD_HIDDEN"):set(1)
	else
		get_param_handle("PILOT_HEAD_HIDDEN"):set(0)
	end

	if (get_player_crew_index() == 1) then
		get_param_handle("COPILOT_HEAD_HIDDEN"):set(1)
	else
		get_param_handle("COPILOT_HEAD_HIDDEN"):set(0)
	end

	pilotVisState = 0

	pilotVisorState = 0
	pilotVisorTargetState = 0
end

function SetCommand(command,value)
	if command == device_commands.miscTailWheelLock then
		if paramCB_TAILWHEELLOCK:get() > 0 then
			tailWheelLockTarget = 1 - tailWheelLocked
		end
	elseif command == Keys.miscTailWheelLockToggle then
		if paramCB_TAILWHEELLOCK:get() > 0 then
			tailWheelLockTarget = 1 - tailWheelLocked
		end
	elseif command == device_commands.wiperSelector then
		wiperMode = round((value + 0.5) * 2)
		--print_message_to_user(wiperMode)
	elseif command == Keys.wiperSelectorInc then
		local sentValue = wiperMode / 3
		dev:performClickableAction(device_commands.wiperSelector, clamp(sentValue + 0.33, 0, 1), true)
	elseif command == Keys.wiperSelectorDec then
		local sentValue = wiperMode / 3
		dev:performClickableAction(device_commands.wiperSelector, clamp(sentValue - 0.33, 0, 1), true)
	elseif command == Keys.wiperSelectorCycle then
		local sentValue = wiperMode / 3
		sentValue = sentValue + 0.333
		if sentValue > 1 then
			sentValue = 0
		end
		dev:performClickableAction(device_commands.wiperSelector, sentValue , true)
	elseif command == Keys.toggleDoors and doorsAttached then
		if canopyTargetState <= 1 then
			canopyTargetState = 1 - canopyTargetState
		end
	elseif command == Keys.toggleDoorsOpen and doorsAttached then
		canopyTargetState = 1
	elseif command == Keys.toggleDoorsClose and doorsAttached then
		canopyTargetState = 0
	elseif command == device_commands.doorCplt and doorsAttached then
		doorCpltTgt = 1 - doorCpltTgt
	elseif command == device_commands.doorLGnr then
		doorLGnrTgt = 1 - doorLGnrTgt
	elseif command == device_commands.doorRGnr then
		doorRGnrTgt = 1 - doorRGnrTgt
	elseif command == device_commands.doorLCargo then
		doorLCargoTgt = 1 - doorLCargoTgt
	elseif command == device_commands.doorRCargo then
		doorRCargoTgt = 1 - doorRCargoTgt
	elseif command == Keys.toggleCopilotDoor and doorsAttached then
		doorCpltTgt = 1 - doorCpltTgt
	elseif command == Keys.toggleLeftCargoDoor then
		doorLCargoTgt = 1 - doorLCargoTgt
	elseif command == Keys.toggleRightCargoDoor then
		doorRCargoTgt = 1 - doorRCargoTgt
	elseif command == Keys.toggleLeftGunnerDoor then
		doorLGnrTgt = 1 - doorLGnrTgt
	elseif command == Keys.toggleRightGunnerDoor then
		doorRGnrTgt = 1 - doorRGnrTgt
	elseif command == device_commands.visor then
		pilotVisorTargetState = value
	elseif command == device_commands.visorToggle then
		if value > 0 then
			pilotVisorTargetState = 1 - pilotVisorTargetState
		end
	elseif command == Keys.showControlInd then
		paramControlsIndicator:set(1 - paramControlsIndicator:get())
	elseif command == Keys.iCommandCockpitShowPilotOnOff then
		pilotVisState = pilotVisState + 1
		if pilotVisState > 2 then
			pilotVisState = 0
		end
	end
end

function updateDoor(tgt, state)
	local animSpeed = 0.01

	if state ~= tgt then
		if state > tgt then
			state = state - math.min(animSpeed, state - tgt)
		else
			state = state + math.min(animSpeed, tgt - state)
		end
	end

	return state
end

function updateVisor(tgt, state)
	local animSpeed = 0.01

	if state ~= tgt then
		if state > tgt then
			state = state - math.min(animSpeed, state - tgt)
		else
			state = state + math.min(animSpeed, tgt - state)
		end
	end

	return state
end

function update()
	-- Head vis
	if (get_player_crew_index() == 0) then
		get_param_handle("PILOT_HEAD_HIDDEN"):set(1)
	else
		get_param_handle("PILOT_HEAD_HIDDEN"):set(0)
	end

	if (get_player_crew_index() == 1) then
		get_param_handle("COPILOT_HEAD_HIDDEN"):set(1)
	else
		get_param_handle("COPILOT_HEAD_HIDDEN"):set(0)
	end

	-- Body toggle vis
	if (get_player_crew_index() == 0) then
		if pilotVisState > 0 then
			get_param_handle("PILOT_HIDDEN"):set(1)
		else
			get_param_handle("PILOT_HIDDEN"):set(0)
		end

		if pilotVisState > 1 then
			get_param_handle("COPILOT_HIDDEN"):set(1)
			get_param_handle("COPILOT_HEAD_HIDDEN"):set(1)
		else
			get_param_handle("COPILOT_HIDDEN"):set(0)
		end
	end

	if (get_player_crew_index() == 1) then
		if pilotVisState > 0 then
			get_param_handle("COPILOT_HIDDEN"):set(1)
		else
			get_param_handle("COPILOT_HIDDEN"):set(0)
		end

		if pilotVisState > 1 then
			get_param_handle("PILOT_HIDDEN"):set(1)
			get_param_handle("PILOT_HEAD_HIDDEN"):set(1)
		else
			get_param_handle("PILOT_HIDDEN"):set(0)
		end
	end

	if paramCB_LTSLWRCSL:get() > 0 then
		-- TWL turns on automatically when power first applied
		if tailWheelLockPwrState == 0 and paramCB_LTSLWRCSL:get() == 1 then
			--print_message_to_user("auto lock")
			tailWheelLockPwrState = 1
			tailWheelLockTarget = 1
		end

		if tailWheelLockTarget ~= tailWheelLockedState and tailWheelLockedState > -1 then
			--print_message_to_user("start transition")
			tailWheelLockedState = -1
			tailWheelLockTime = get_absolute_model_time()
		end

		if tailWheelLockedState == -1 and get_absolute_model_time() - tailWheelLockTime > 2 then
			--print_message_to_user("end transition")
			tailWheelLockedState = tailWheelLockTarget
			tailWheelLocked = tailWheelLockTarget
			dispatch_action(nil, EFM_commands.lockTailWheel, tailWheelLocked)
		end

		if tailWheelLockedState >= 0 then
			paramTailWheelLockLight:set(tailWheelLocked * tailWheelLockPwrState)
		else
			paramTailWheelLockLight:set(0.5)
		end
	end
	-- Wipers
	local wiperBaseSpeed = 0.01
	local wiperVal = get_aircraft_draw_argument_value(630)
	local speedMult = wiperMode - 1

	if wiperMode == 0 then
		if wiperVal > 0 then
			set_aircraft_draw_argument_value(630, wiperVal -wiperBaseSpeed)
		end
	elseif wiperMode == 2 or wiperMode == 3 then
		if wiperVal <= 0 then
			wiperFwd = true
		elseif wiperVal >= 1 then
			wiperFwd = false
		end

		if wiperFwd and wiperVal < 1 then
			set_aircraft_draw_argument_value(630, wiperVal + wiperBaseSpeed * speedMult)
		elseif wiperFwd == false and wiperVal > 0 then
			set_aircraft_draw_argument_value(630, wiperVal - wiperBaseSpeed * speedMult)
		end
	end

	get_param_handle("WIPER_GLASS"):set(wiperMode - 1)
	get_param_handle("WIPER_ANIM"):set(get_aircraft_draw_argument_value(630))

	-- Visors
	pilotVisorState = updateDoor(pilotVisorTargetState, pilotVisorState)
	get_param_handle("VISOR_POS"):set(pilotVisorState)

	-- Handle canopy (doors)
	local canopyPos = get_aircraft_draw_argument_value(38)

	if (canopyTargetState == 0 and canopyPos > 0) then
		canopyPos = canopyPos - 0.01
		set_aircraft_draw_argument_value(38, canopyPos)
	elseif (canopyTargetState == 1 and canopyPos <= 0.89) then
		canopyPos = canopyPos + 0.01
		set_aircraft_draw_argument_value(38, canopyPos)
	end

	-- Doors
	doorCpltState = updateDoor(doorCpltTgt, doorCpltState)
	doorLGnrState = updateDoor(doorLGnrTgt, doorLGnrState)
	doorRGnrState = updateDoor(doorRGnrTgt, doorRGnrState)
	doorLCargoState = updateDoor(doorLCargoTgt, doorLCargoState)
	doorRCargoState = updateDoor(doorRCargoTgt, doorRCargoState)

	-- Override the doors for DAP when 230s installed
	if (get_param_handle("IS_DAP"):get() > 0.0) then
		weapons = GetDevice(devices.WEAPONS)
		if weapons ~= nil then
			local pylon1 = weapons:get_station_info(1)
			if (pylon1.weapon.level2 == wsType_Shell) then
				doorLCargoState = 1.0
			end

			local pylon5 = weapons:get_station_info(5)
			if (pylon5.weapon.level2 == wsType_Shell) then
				doorRCargoState = 1.0
			end
		end
	end

	-- Override the gunner windows when AI gunners installed
	if (get_aircraft_draw_argument_value(670) > 0.7) then
		doorRGnrState = 1.0
	end

	if (get_aircraft_draw_argument_value(671) > 0.7) then
		doorLGnrState = 1.0
	end

	set_aircraft_draw_argument_value(400, doorCpltState)
	set_aircraft_draw_argument_value(401, doorLCargoState)
	set_aircraft_draw_argument_value(402, doorRCargoState)
	set_aircraft_draw_argument_value(403, doorLGnrState)
	set_aircraft_draw_argument_value(404, doorRGnrState)

	get_param_handle("PILOT_DOOR_STATE"):set(get_aircraft_draw_argument_value(38))
	get_param_handle("COPILOT_DOOR_STATE"):set(get_aircraft_draw_argument_value(400))
	get_param_handle("LEFT_GUNNER_DOOR_STATE"):set(get_aircraft_draw_argument_value(403))
	get_param_handle("RIGHT_GUNNER_DOOR_STATE"):set(get_aircraft_draw_argument_value(404))
	get_param_handle("LEFT_CARGO_DOOR_STATE"):set(get_aircraft_draw_argument_value(401))
	get_param_handle("RIGHT_CARGO_DOOR_STATE"):set(get_aircraft_draw_argument_value(402))

	-- Seat states
	get_param_handle("RIGHT_GUNNER_SEAT_STATE"):set(get_aircraft_draw_argument_value(670))
	get_param_handle("LEFT_GUNNER_SEAT_STATE"):set(get_aircraft_draw_argument_value(671))
	get_param_handle("CARGO_SEAT_STATE"):set(get_aircraft_draw_argument_value(672))

	-- Castering wheel fix from JNelson
	local nose_wheel_pos = get_aircraft_draw_argument_value(1000)
	local post_nose_wheel_post = nose_wheel_pos * math.sqrt(2) / math.pi
	set_aircraft_draw_argument_value(2, post_nose_wheel_post)
end

need_to_be_closed = false