dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")

dev = GetSelf()
sensor_data = get_base_data()
Terrain = require('terrain')
update_time_step = 0.1
make_default_activity(update_time_step)

local xmitMode = 1
local volume = 0

local rcvFM1 = false
local rcvUHF = false
local rcvVHF = false
local rcvFM2 = false
local rcvHF = false
local rcvVOR = false
local rcvADF = false

local paramPTT = get_param_handle("PILOT_PTT")

dev:listen_command(device_commands.copilotICPXmitSelector)
dev:listen_command(device_commands.copilotICPSetVolume)
dev:listen_command(device_commands.copilotICPToggleFM1)
dev:listen_command(device_commands.copilotICPToggleUHF)
dev:listen_command(device_commands.copilotICPToggleVHF)
dev:listen_command(device_commands.copilotICPToggleFM2)
dev:listen_command(device_commands.copilotICPToggleHF)
dev:listen_command(device_commands.copilotICPToggleVOR)
dev:listen_command(device_commands.copilotICPToggleADF)
--dev:listen_command(Keys.ptt)
dev:listen_command(Keys.copilotICPXmitSelectorInc)
dev:listen_command(Keys.copilotICPXmitSelectorDec)

function SetCommand(command,value)   
    if command == device_commands.copilotICPXmitSelector then
        xmitMode = round(value * 5)
        --setXMITMode()
        --print_message_to_user(xmitMode)
    elseif  command == device_commands.copilotICPSetVolume then
        volume = value
    elseif  command == device_commands.copilotICPToggleFM1 then
        rcvFM1 = value > 0
    elseif  command == device_commands.copilotICPToggleUHF then
        rcvUHF = value > 0
    elseif  command == device_commands.copilotICPToggleVHF then
        rcvVHF = value > 0
    elseif  command == device_commands.copilotICPToggleFM2 then
        rcvFM2 = value > 0
    elseif  command == device_commands.copilotICPToggleHF then
        rcvHF = value > 0
    elseif  command == device_commands.copilotICPToggleVOR then
        rcvVOR = value > 0
    elseif  command == device_commands.copilotICPToggleADF then
        rcvADF = value > 0
    elseif  command == Keys.copilotICPXmitSelectorInc then
        if xmitMode < 5 then
            dev:performClickableAction(device_commands.copilotICPXmitSelector, (xmitMode + 1) / 5, true)
            --dispatch_action(nil,device_commands.pilotICPXmitSelector, (xmitMode + 1) / 5)
        end
    elseif  command == Keys.copilotICPXmitSelectorDec then
        if xmitMode > 0 then
            dev:performClickableAction(device_commands.copilotICPXmitSelector, (xmitMode - 1) / 5, true)
            --dispatch_action(nil,device_commands.pilotICPXmitSelector, (xmitMode - 1) / 5)
        end
    end
end

function post_initialize()
	local dev = GetSelf()
    local birth = LockOn_Options.init_conditions.birth_place	
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then 			  
    elseif birth=="GROUND_COLD" then 
    end

    dev:performClickableAction(device_commands.copilotICPSetVolume,1,true)
    dev:performClickableAction(device_commands.copilotICPToggleFM1,1,true)
    dev:performClickableAction(device_commands.copilotICPToggleUHF,1,true)
    dev:performClickableAction(device_commands.copilotICPToggleVHF,1,true)
    dev:performClickableAction(device_commands.copilotICPToggleFM2,1,true)
    dev:performClickableAction(device_commands.copilotICPToggleHF,1,true)
    dev:performClickableAction(device_commands.copilotICPToggleVOR,1,true)
    dev:performClickableAction(device_commands.copilotICPToggleADF,1,true)
end

function update()
    updateNetworkArgs(GetSelf())
end

need_to_be_closed = false
