dofile(LockOn_Options.script_path.."HUD/Indicator/cpltDefinitions.lua")

local paramPwr = "COPILOT_HUD_PWR"
local paramBrt = "COPILOT_HUD_BRIGHTNESS"

-------------------------------------------------------------

local width = 580 * scale
local innnerWidth = 400 * scale
local height = 950 * scale
local midHeight = 100 * scale
local verts =
{
	{-innnerWidth/2,height/2},
	{innnerWidth/2,height/2},
	{width/2,midHeight},
	{width/2,-height/2},
	{-width/2,-height/2},
	{-width/2,midHeight}
}

local base				= CreateElement "ceMeshPoly"
base.name				= "base"
base.vertices			= verts
base.indices			= {0,1,2,0, 2,5,0,2, 2,3,4,2, 2,4,5,2}
base.init_pos			= {0, 0, 0}
base.material			= MakeMaterial(nil,{0, 0, 255, 140})
base.additive_alpha		= true
base.collimated			= false
base.isvisible			= false
base.h_clip_relation	= h_clip_relations.REWRITE_LEVEL
base.level				= DEFAULT_LEVEL
Add(base)

local rotBase = Copy(base)
rotBase.h_clip_relation	= COMPARE
rotBase.init_rot		= {0,0,45}
rotBase.init_pos		= {0,-height / 2,0}
rotBase.collimated		= true
rotBase.material		= MakeMaterial(nil,{255, 0, 0, 70})
rotBase.h_clip_relation	= h_clip_relations.COMPARE
rotBase.element_params	= {paramPwr}
rotBase.controllers		= {{"parameter_in_range",0,0.9,1.1}}
rotBase.isvisible		= false
Add(rotBase)

armedText = CreateElement "ceStringPoly"
armedText.parent_element	= rotBase.name
armedText.value				= "ARMED"
armedText.alignment			= "CenterCenter"
armedText.stringdefs		= stringdefs
armedText.material			= font
armedText.init_pos			= {0,-330 * scale,0}
armedText.collimated		= true
armedText.h_clip_relation	= h_clip_relations.COMPARE
armedText.level				= DEFAULT_LEVEL
armedText.element_params	= {"MASTER_ARM", paramBrt}
armedText.controllers		= {{"parameter_in_range",0,0.9,1.1},{"opacity_using_parameter",1}}
armedText.additive_alpha	= true
armedText.blend_mode		= blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
Add(armedText)

for i=0,3 do
	pylonIdx = i
	x = i * 30 * scale
	if i == 2 then
		pylonIdx = 5
		x = x + 15 * scale
	elseif i == 3 then
		pylonIdx = 6
		x = x + 15 * scale
	end

	param = string.format("PYLON_%i_WPN_TYPE", pylonIdx)

	lobGUN = Copy(armedText)
	lobGUN.value			= "GUN"
	lobGUN.alignment		= "CenterCenter"
	lobGUN.init_pos			= {-60 * scale + x,-350 * scale,0}
	lobGUN.element_params	= {param, paramBrt,paramPwr}
	lobGUN.controllers		= {{"parameter_in_range",0,0.9,1.1},{"opacity_using_parameter",1},{"parameter_in_range",2,0.9,1.1}}
	lobGUN.stringdefs		= stringdefsSmall
	lobGUN.parent_element	= rotBase.name
	lobGUN.blend_mode		= blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
	Add(lobGUN)

	local w = 27.5 * scale
	local h = 12 * scale
	local verts = {{-w/2, h/2},{w/2, h/2},{w/2, -h/2},{-w/2, -h/2}}

	local gunSelectedBox = CreateElement "ceBoundingTexBox"
	gunSelectedBox.name 			= "atasTrackingReticle"
	gunSelectedBox.vertices 		= verts
	gunSelectedBox.init_pos			= {0,0,0}
	gunSelectedBox.material			= materialGreen
	gunSelectedBox.h_clip_relation 	= h_clip_relations.COMPARE
	gunSelectedBox.level			= DEFAULT_LEVEL
	gunSelectedBox.isdraw			= true
	gunSelectedBox.isvisible		= true
	gunSelectedBox.collimated		= true
	gunSelectedBox.width			= 0.7
	gunSelectedBox.additive_alpha	= true
	gunSelectedBox.parent_element	= lobGUN.name
	gunSelectedBox.element_params	= {paramBrt, "AMS_SELECTION_INDEX"}
	gunSelectedBox.controllers		= {{"opacity_using_parameter",0},{"parameter_in_range",1,0.9,1.1}}
	gunSelectedBox.blend_mode		= blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
	Add(gunSelectedBox)

	lobRKT = Copy(lobGUN)
	lobRKT.value			= "RKT"
	lobRKT.controllers		= {{"parameter_in_range",0,1.9,2.1},{"opacity_using_parameter",1}}
	lobRKT.stringdefs		= stringdefsSmall
	Add(lobRKT)

	local rktSelectedBox = Copy(gunSelectedBox)
	rktSelectedBox.parent_element	= lobRKT.name
	rktSelectedBox.controllers		= {{"opacity_using_parameter",0},{"parameter_in_range",1,1.9,2.1}}
	Add(rktSelectedBox)

	lobHF = Copy(lobGUN)
	lobHF.value				= "HF"
	lobHF.controllers		= {{"parameter_in_range",0,2.9,3.1},{"opacity_using_parameter",1}}
	lobHF.stringdefs		= stringdefsSmall
	Add(lobHF)

	local hfSelectedBox = Copy(gunSelectedBox)
	hfSelectedBox.parent_element	= lobHF.name
	hfSelectedBox.controllers		= {{"opacity_using_parameter",0},{"parameter_in_range",1,2.9,3.1}}
	Add(hfSelectedBox)

	lobATAS = Copy(lobGUN)
	lobATAS.value			= "ATAS"
	lobATAS.controllers		= {{"parameter_in_range",0,3.9,4.1},{"opacity_using_parameter",1}}
	lobATAS.stringdefs		= stringdefsSmall
	Add(lobATAS)

	local atasSelectedBox = Copy(gunSelectedBox)
	atasSelectedBox.parent_element	= lobATAS.name
	atasSelectedBox.controllers		= {{"opacity_using_parameter",0},{"parameter_in_range",1,3.9,4.1}}
	Add(atasSelectedBox)
end

local y = -250 * scale
local w = 3 * scale
local h = 20 * scale
local verts = {{-w/2, h/2},{w/2, h/2},{w/2, -h/2},{-w/2, -h/2}}

gunCrosshairTop                     = CreateElement "ceMeshPoly"
gunCrosshairTop.name 			    = "gunCrosshairTop"
gunCrosshairTop.vertices 		    = verts
gunCrosshairTop.indices 		    = default_box_indices
gunCrosshairTop.init_pos		    = {0,y + h,0}
gunCrosshairTop.material		    = materialGreen
gunCrosshairTop.h_clip_relation     = h_clip_relations.COMPARE
gunCrosshairTop.level			    = DEFAULT_LEVEL
gunCrosshairTop.isdraw			    = true
gunCrosshairTop.isvisible		    = true
gunCrosshairTop.collimated		    = true
gunCrosshairTop.additive_alpha      = true
gunCrosshairTop.parent_element		= rotBase.name
gunCrosshairTop.element_params      = {paramBrt}
gunCrosshairTop.controllers         = {{"opacity_using_parameter",0}}
gunCrosshairTop.blend_mode			= blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
Add(gunCrosshairTop)

gunCrosshairBottom                      = Copy(gunCrosshairTop)
gunCrosshairBottom.name 			    = "gunCrosshairBottom"
gunCrosshairBottom.init_pos		        = {0,y - h,0}
Add(gunCrosshairBottom)

local w = 20 * scale
local h = 3 * scale
local verts = {{-w/2, h/2},{w/2, h/2},{w/2, -h/2},{-w/2, -h/2}}

gunCrosshairLeft                    = Copy(gunCrosshairTop)
gunCrosshairLeft.name 			    = "gunCrosshairLeft"
gunCrosshairLeft.vertices 		    = verts
gunCrosshairLeft.indices 		    = default_box_indices
gunCrosshairLeft.init_pos		    = {0 + w,y,0}
Add(gunCrosshairLeft)

gunCrosshairRight                   = Copy(gunCrosshairLeft)
gunCrosshairRight.name 			    = "gunCrosshairRight"
gunCrosshairRight.init_pos		    = {0 - w,y,0}
Add(gunCrosshairRight)

-- Field of view indicator
local w = 15 * scale
local h = 2 * scale
local verts = {{-w/2, h/2},{w/2, h/2},{w/2, -h/2},{-w/2, -h/2}}

for i=1,8 do
    local r = 60 * scale
    local a = 360 / 8 * i
    local x = math.cos(math.rad(a)) * r
    local y = math.sin(math.rad(a)) * r

    local atasFoVLine				= CreateElement "ceMeshPoly"
    atasFoVLine.name 				= "atasFoVLine"
    atasFoVLine.vertices 			= verts
    atasFoVLine.indices 			= default_box_indices
    atasFoVLine.init_pos			= {centerX + x, -250 * scale + y,0}
    atasFoVLine.init_rot			= {a + 90}
    atasFoVLine.material			= materialGreen
    atasFoVLine.h_clip_relation 	= h_clip_relations.COMPARE
    atasFoVLine.level				= DEFAULT_LEVEL
    atasFoVLine.isdraw				= true
    atasFoVLine.isvisible			= true
    atasFoVLine.collimated			= true
    atasFoVLine.additive_alpha		= true
    atasFoVLine.parent_element		= rotBase.name
	atasFoVLine.element_params      = {paramBrt, "AMS_SELECTION_INDEX"}
	atasFoVLine.controllers         = {{"opacity_using_parameter",0},{"parameter_in_range",1,3.9,4.1}}
	atasFoVLine.blend_mode			= blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
    Add(atasFoVLine)
end

-- Reticle Layer
local atasMask          	= CreateElement "ceMeshPoly"
atasMask.name 				= "atasMask"
atasMask.init_pos			= {centerX,-250 * scale,0}
atasMask.material			= MakeMaterial(nil,{255, 0, 255, 200})
atasMask.h_clip_relation	= h_clip_relations.INCREASE_IF_LEVEL
atasMask.level				= DEFAULT_LEVEL
atasMask.isdraw				= true
atasMask.isvisible			= false
atasMask.collimated			= true
atasMask.additive_alpha		= true
atasMask.parent_element		= rotBase.name
set_circle	(atasMask, 0,60 * scale, 360, 72)
Add(atasMask)

local w = 20 * scale
local h = 20 * scale
local verts = {{-w/2, h/2},{w/2, h/2},{w/2, -h/2},{-w/2, -h/2}}

local atasTrackingReticle = CreateElement "ceBoundingTexBox"
atasTrackingReticle.name 				= "atasTrackingReticle"
atasTrackingReticle.vertices 			= verts
atasTrackingReticle.init_pos			= {0, 0 * scale,0}
atasTrackingReticle.material			= materialGreen
atasTrackingReticle.h_clip_relation 	= h_clip_relations.COMPARE
atasTrackingReticle.level				= DEFAULT_LEVEL+1
atasTrackingReticle.isdraw				= true
atasTrackingReticle.isvisible			= true
atasTrackingReticle.collimated			= true
atasTrackingReticle.width				= 1.0 * scale
atasTrackingReticle.additive_alpha		= true
atasTrackingReticle.parent_element		= atasMask.name
atasTrackingReticle.element_params		= {paramBrt, "WS_IR_MISSILE_TARGET_AZIMUTH", "IR_SEEKER_ELEVATION", "IR_SEEKER_UNCAGED", "AMS_SELECTION_INDEX"}
atasTrackingReticle.controllers			= {{"opacity_using_parameter",0},{"move_left_right_using_parameter", 1, 0.15},{"move_up_down_using_parameter", 2, 0.15},{"parameter_in_range",3,0.9,1.1},{"parameter_in_range",4,3.9,4.1}}
atasTrackingReticle.blend_mode			= blend_mode.IBM_REGULAR_ADDITIVE_ALPHA

Add(atasTrackingReticle)
