dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")

dev = GetSelf()
sensor_data = get_base_data()
update_time_step = 0.05
make_default_activity(update_time_step)

clickableHUDVis = nil
clickableXhair = nil
clickableHUDPwr = nil
clickableHUDBrt = nil

showHUD = false
showCrosshair = false
pwrOn = false
brightness = 0.6
paramPwr = get_param_handle("COPILOT_HUD_PWR")
paramBrt = get_param_handle("COPILOT_HUD_BRIGHTNESS")
paramHUDVis = get_param_handle("COPILOT_HUD_VIS")
paramXHairVis = get_param_handle("COPILOT_XHAIR_VIS")

elementXHair = "PTR-CPLT-CROSSHAIR"
elementPwr = "PNT_CPLT_HUD_PWR"
elementBrt = "PNT_CPLT_HUD_BRT"
elementVis = "PNT_CPLT_HUD_VIS"

commandHUDVis = device_commands.copilotHUDVis
commandHUDPwr = device_commands.copilotHUDPwr
commandHUDPwrToggle = device_commands.copilotHUDPwrToggle
commandHUDBrt = device_commands.copilotHUDBrt

-------------------------------------------------------------------------

dev:listen_command(commandHUDVis)
dev:listen_command(commandHUDPwr)
dev:listen_command(commandHUDBrt)

function SetCommand(command,value)   
	if command == commandHUDVis then
		if (get_aircraft_type() == "UH-60L_DAP") then
			if value == 0 then
				showHUD = true
				showCrosshair = false
			elseif value == 0.5 then
				showHUD = false
				showCrosshair = false
			else
				showHUD = false
				showCrosshair = true
			end

			updateVisibility()
		end
	elseif command == commandHUDPwr then
		if value > 0 then
			pwrOn = true
		else
			pwrOn = false
		end
	elseif command == commandHUDPwrToggle then
		if value > 0 then
			if pwrOn then
				pwrOn = false
			else
				pwrOn = true
			end
			if pwrOn then
				dev:performClickableAction(commandHUDPwr,1, true)
			else
				dev:performClickableAction(commandHUDPwr,0, true)
			end
		end
	elseif command == commandHUDBrt then
		brightness = value
	end
end


function post_initialize()
	local dev = GetSelf()
	local birth = LockOn_Options.init_conditions.birth_place	
	if birth=="GROUND_HOT" or birth=="AIR_HOT" then
		if (get_aircraft_type() == "UH-60L_DAP") then
			pwrOn = true
			dev:performClickableAction(commandHUDPwr,1)
			dev:performClickableAction(commandHUDBrt, brightness)
		end
	elseif birth=="GROUND_COLD" then 
	end

	clickableXhair = get_clickable_element_reference(elementXHair)
	clickableHUDPwr = get_clickable_element_reference(elementPwr)
	clickableHUDBrt = get_clickable_element_reference(elementBrt)

	if (get_aircraft_type() == "UH-60L_DAP") then
		showHUD = true
		dev:performClickableAction(commandHUDVis,0)
	else
		clickableHUDVis = get_clickable_element_reference(elementVis)
		clickableHUDPwr:hide(true)
	end
	
	updateVisibility()
end

function update()
	if showHUD and pwrOn then
		paramPwr:set(1)
		paramBrt:set(brightness)
	else
		paramPwr:set(0)
	end
end

function updateVisibility()
	if showHUD then
		paramHUDVis:set(1)
		clickableHUDPwr:hide(false)
		clickableHUDBrt:hide(false)
	else
		paramHUDVis:set(0)
		clickableHUDPwr:hide(true)
		clickableHUDBrt:hide(true)
	end

	if showCrosshair then
		paramXHairVis:set(1)
		clickableXhair:hide(false)
	else
		paramXHairVis:set(0)
		clickableXhair:hide(true)
	end
end

need_to_be_closed = false
