dofile(LockOn_Options.common_script_path.."elements_defs.lua")

DEFAULT_LEVEL = 5
NOCLIP_LEVEL = DEFAULT_LEVEL - 1
CLIP_LEVEL = DEFAULT_LEVEL + 1

SetScale(METERS)
local advisoryColor = {0,2000,0,200}
local font = MakeFont({used_DXUnicodeFontData = "dotMatrixFont"}, advisoryColor)
local center = {0,0.2,0.6} -- {L/R,U/D,forward/back}
local rotation = {0, 0, 0} -- main panel rotation roughly 22deg
local hudMaterial = MakeMaterial(nil,advisoryColor)

verts = {}
dx=.5
dy=dx
verts [1]= {-dx,-dy}
verts [2]= {-dx,dy}
verts [3]= {dx,dy}
verts [4]= {dx,-dy}

local textSizeMod = 0.06
local stringdefs = {dx * textSizeMod, 0.77 * (dx * textSizeMod), -0.008, 0}
local lineWidth = 0.006

--local handleVROption = get_param_handle("AVS7_VR")
--if (handleVROption:get() == 1) then
--    center = {0,0,0.6} -- {L/R,U/D,forward/back}
--end

local base 			 = CreateElement "ceMeshPoly"
base.name 			 = "base"
base.vertices 		 = verts
base.indices 		 = {0,1,2,2,3,0}
base.init_pos		 = center
base.init_rot		 = rotation
base.material		 = MakeMaterial(nil,{0,0,0,255})
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
base.level			 = DEFAULT_LEVEL
base.isdraw			 = true
base.change_opacity  = false
base.isvisible		 = false
base.element_params  = {"AVS7_PWR"}
base.controllers     = {{"parameter_in_range",0,0.9,1.1}}
Add(base)

local baroAltText           = CreateElement "ceStringPoly"
baroAltText.name            = create_guid_string()
baroAltText.material        = font
baroAltText.alignment       = "RightCenter"
baroAltText.init_pos		= {0.38, 0.15, 0} -- L/R, D/U, F/B
baroAltText.stringdefs      = stringdefs
baroAltText.formats         = {"%0.0fB"}
baroAltText.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BARO_ALT"}
baroAltText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
baroAltText.h_clip_relation  = h_clip_relations.COMPARE
baroAltText.level			= DEFAULT_LEVEL
baroAltText.parent_element  = base.name
baroAltText.additive_alpha  = true
baroAltText.blend_mode      = blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
Add(baroAltText)

local RdrAltText           = Copy(baroAltText)
RdrAltText.init_pos		    = {0.345, -0.0977, 0} -- L/R, D/U, F/B
RdrAltText.formats         = {"%03.0f"}
RdrAltText.element_params  = {"AVS7_BRIGHTNESS", "AVS7_RDR_ALT", "AVS7_RDR_ALT_DIGITVIS"}
RdrAltText.controllers     = {{"opacity_using_parameter",2}, {"text_using_parameter",1,0}}
Add(RdrAltText)

local RdrAltBox 			= CreateElement "ceSimpleLineObject"
RdrAltBox.material 		    = hudMaterial
RdrAltBox.primitivetype     = "lines"
RdrAltBox.width			    = 0.01
RdrAltBox.vertices          = {{0,0}, {0.07,0}, {0.07,0.04}, {0,0.04}, {0,0}}
RdrAltBox.init_pos 		    = {0.29, -0.12, 0}
RdrAltBox.parent_element    = base.name
RdrAltBox.h_clip_relation   = h_clip_relations.REWRITE_LEVEL
RdrAltBox.level	    		= DEFAULT_LEVEL
RdrAltBox.element_params    = {"AVS7_BRIGHTNESS", "AVS7_RDR_ALT_BOX"}
RdrAltBox.controllers 	    = {{"opacity_using_parameter",0}, {"parameter_in_range",1,0.7,1.1}}
Add(RdrAltBox)

local waypointBrgText           = Copy(baroAltText)
waypointBrgText.alignment       = "LeftCenter"
waypointBrgText.init_pos		    = {-0.45, 0.2, 0} -- L/R, D/U, F/B
waypointBrgText.formats         = {"%03.0f"}
waypointBrgText.element_params  = {"AVS7_BRIGHTNESS", "AVS7_WP_BRG"}
waypointBrgText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
Add(waypointBrgText)

local waypointDistText           = Copy(baroAltText)
waypointDistText.alignment       = "LeftCenter"
waypointDistText.init_pos		    = {-0.45, 0.15, 0} -- L/R, D/U, F/B
waypointDistText.formats         = {"%02.1f"}
waypointDistText.element_params  = {"AVS7_BRIGHTNESS", "AVS7_WP_DIST"}
waypointDistText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
Add(waypointDistText)

local e1TGTText           = Copy(baroAltText)
e1TGTText.alignment       = "LeftCenter"
e1TGTText.init_pos		    = {-0.45, 0.1, 0} -- L/R, D/U, F/B
e1TGTText.formats         = {"%03.0fT1"}
e1TGTText.element_params  = {"AVS7_BRIGHTNESS", "E1_TGT"}
e1TGTText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
Add(e1TGTText)

local e2TGTText           = Copy(baroAltText)
e2TGTText.alignment       = "LeftCenter"
e2TGTText.init_pos		    = {-0.45, 0.05, 0} -- L/R, D/U, F/B
e2TGTText.stringdefs      = stringdefs
e2TGTText.formats         = {"%03.0fT2"}
e2TGTText.element_params  = {"AVS7_BRIGHTNESS", "E2_TGT"}
e2TGTText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
Add(e2TGTText)

local IASText           = Copy(baroAltText)
IASText.alignment       = "LeftCenter"
IASText.init_pos		    = {-0.45, -0.05, 0} -- L/R, D/U, F/B
IASText.formats         = {"%03.0fA"}
IASText.element_params  = {"AVS7_BRIGHTNESS", "AVS7_IAS", "AVS7_IAS_VIS"}
IASText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0},{"opacity_using_parameter",2}}
Add(IASText)

local GSText           = Copy(baroAltText)
GSText.alignment       = "LeftCenter"
GSText.init_pos		    = {-0.45, -0.1, 0} -- L/R, D/U, F/B
GSText.formats         = {"%03.0fG"}
GSText.element_params  = {"AVS7_BRIGHTNESS", "AVS7_GS"}
GSText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
Add(GSText)

local e1TRQText           = Copy(baroAltText)
e1TRQText.alignment       = "LeftCenter"
e1TRQText.init_pos		    = {-0.45, -0.2, 0} -- L/R, D/U, F/B
e1TRQText.formats         = {"%03.0f"}
e1TRQText.element_params  = {"AVS7_BRIGHTNESS", "E1_TRQ"}
e1TRQText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
Add(e1TRQText)

local e1TRQBox 			= CreateElement "ceSimpleLineObject"
e1TRQBox.name 			    = create_guid_string()
e1TRQBox.material 		    = hudMaterial
e1TRQBox.primitivetype     = "lines"
e1TRQBox.width			    = 0.01
e1TRQBox.vertices          = {{0,0}, {0.07,0}, {0.07,0.04}, {0,0.04}, {0,0}}
e1TRQBox.init_pos 		    = {-0.45, -0.22, 0}
e1TRQBox.parent_element    = base.name
e1TRQBox.h_clip_relation   = h_clip_relations.REWRITE_LEVEL
e1TRQBox.level	    		= 6
e1TRQBox.element_params    = {"AVS7_BRIGHTNESS", "E1_TRQ_BOX"}
e1TRQBox.controllers 	    = {{"opacity_using_parameter",0}, {"parameter_in_range",1,0.9,1.1}}
Add(e1TRQBox)

local e2TRQText           = Copy(baroAltText)
e2TRQText.alignment       = "LeftCenter"
e2TRQText.init_pos		    = {-0.45, -0.25, 0} -- L/R, D/U, F/B
e2TRQText.formats         = {"%03.0f"}
e2TRQText.element_params  = {"AVS7_BRIGHTNESS", "E2_TRQ"}
e2TRQText.controllers     = {{"opacity_using_parameter",0}, {"text_using_parameter",1,0}}
Add(e2TRQText)

local e2TRQBox 			= CreateElement "ceSimpleLineObject"
e2TRQBox.name 			    = create_guid_string()
e2TRQBox.material 		    = hudMaterial
e2TRQBox.primitivetype     = "lines"
e2TRQBox.width			    = 0.01
e2TRQBox.vertices          = {{0,0}, {0.07,0}, {0.07,0.04}, {0,0.04}, {0,0}}
e2TRQBox.init_pos 		    = {-0.45, -0.27, 0}
e2TRQBox.parent_element    = base.name
e2TRQBox.h_clip_relation   = h_clip_relations.REWRITE_LEVEL
e2TRQBox.level	    		= 6
e2TRQBox.element_params    = {"AVS7_BRIGHTNESS", "E2_TRQ_BOX"}
e2TRQBox.controllers 	    = {{"opacity_using_parameter",0}, {"parameter_in_range",1,0.9,1.1}}
Add(e2TRQBox)

local pageText           = Copy(baroAltText)
pageText.alignment       = "LeftCenter"
pageText.init_pos		    = {-0.45, -0.35, 0} -- L/R, D/U, F/B
pageText.formats         = {"%s"}
pageText.value             = "1"
pageText.element_params  = {"AVS7_BRIGHTNESS"}
pageText.controllers     = {{"opacity_using_parameter", 0}}
Add(pageText)

----------------------------------------------------------------------------------
--WARNINGS

function addHardcodedStringItem(pos, value, params, controllers)
	local cautionATT           = CreateElement "ceStringPoly"
	cautionATT.name            = create_guid_string()
	cautionATT.material        = font
	cautionATT.alignment       = "LeftCenter"
	cautionATT.init_pos		    = pos -- L/R, D/U, F/B
	cautionATT.stringdefs      = stringdefs
	cautionATT.formats         = {"%s"}
	cautionATT.value             = value
	cautionATT.element_params  = params
	cautionATT.controllers     = controllers
	cautionATT.h_clip_relation  = h_clip_relations.COMPARE
	cautionATT.level			= DEFAULT_LEVEL
	cautionATT.parent_element  = base.name
	cautionATT.additive_alpha  = true
	cautionATT.blend_mode      = blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
	Add(cautionATT)
end

addHardcodedStringItem({-0.16, -0.30, 0}, "ATT", {"AVS7_BRIGHTNESS", "PILOT_VSI_ATT_FLAG"}, {{"opacity_using_parameter", 0}, {"parameter_in_range",1,-0.1,0.1}})
addHardcodedStringItem({-0.08, -0.30, 0}, "ENG1", {"AVS7_BRIGHTNESS", "MCP_1ENGOUT"}, {{"opacity_using_parameter", 0}, {"parameter_in_range",1,0.9,1.1}})
addHardcodedStringItem({-0.08, -0.30, 0}, "ENG2", {"AVS7_BRIGHTNESS", "MCP_2ENGOUT", "MCP_1ENGOUT"}, {{"opacity_using_parameter", 0}, {"parameter_in_range",1,0.9,1.1}, {"parameter_in_range",2,-0.1,0.1}})
addHardcodedStringItem({0, -0.30, 0}, "FIRE", {"AVS7_BRIGHTNESS", "MCP_FIRE"}, {{"opacity_using_parameter", 0}, {"parameter_in_range",1,0.9,1.1}})
addHardcodedStringItem({0.08, -0.30, 0}, "RPM", {"AVS7_BRIGHTNESS", "MCP_LOWROTORRPM"}, {{"opacity_using_parameter", 0}, {"parameter_in_range",1,0.9,1.1}})
addHardcodedStringItem({-0.14, -0.35, 0}, "MST", {"AVS7_BRIGHTNESS", "MCP_MC"}, {{"opacity_using_parameter", 0}, {"parameter_in_range",1,0.9,1.1}})

----------------------------------------------------------------------------------

function addLine(x,y,l,r)
	local test 			 = CreateElement "ceMeshPoly"
	test.vertices 		 = {{0, 0}, {0, 0 + l}, {0 + lineWidth, 0 + l}, {0 + lineWidth, 0}}
	test.indices 		 = {0,1,2,2,3,0}
	test.init_pos		 = {x,y,0}
	test.init_rot		 = {r}
	test.material		 = hudMaterial
	test.h_clip_relation = h_clip_relations.COMPARE
	test.level			 = DEFAULT_LEVEL
	test.parent_element  = base.name
	test.element_params  = {"AVS7_BRIGHTNESS"}
	test.controllers     = {{"opacity_using_parameter", 0}}
	Add(test)
	return test
end

function addHorizontalLine(x,y,l,r)
	test 			 = CreateElement "ceMeshPoly"
	test.vertices 		 = {{x, y}, {x, y + lineWidth}, {x + l, y + lineWidth}, {x + l, y}}
	test.indices 		 = {0,1,2,2,3,0}
	test.init_pos		 = center
	test.init_rot		 = {r}
	test.material		 = hudMaterial
	test.h_clip_relation = h_clip_relations.COMPARE
	test.level			 = DEFAULT_LEVEL
	test.parent_element  = base.name
	test.element_params  = {"AVS7_BRIGHTNESS"}
	test.controllers     = {{"opacity_using_parameter", 0}}
	Add(test)
	return test
end

function addText(x,y, string)
	text           = CreateElement "ceStringPoly"
	text.material        = font
	text.alignment       = "CenterCenter"
	text.init_pos		 = {x,y,0}
	text.stringdefs      = {dx * textSizeMod, 0.77 * (dx * textSizeMod), -0.01, 0}
	text.formats         = {"%s"}
	text.value           = string
	text.h_clip_relation  = h_clip_relations.COMPARE
	text.level			= DEFAULT_LEVEL
	text.parent_element  = base.name
	text.element_params  = {"AVS7_BRIGHTNESS"}
	text.controllers     = {{"opacity_using_parameter", 0}}
	text.additive_alpha  = true
	text.blend_mode      = blend_mode.IBM_REGULAR_ADDITIVE_ALPHA
	Add(text)
	return text
end

local horizonOffset = -0.2

function addRadialLine(a,b,r)

	test 			 = CreateElement "ceStringPoly"
	test.name 			 = create_guid_string()
	test.vertices 		 = {{0, a}, {0, b}, {0+lineWidth, b}, {0+lineWidth, a}}
	test.indices 		 = {0,1,2,2,3,0}
	test.init_pos		 = {0, 0.2 + horizonOffset, 0.6}
	test.init_rot		 = {r}
	test.material		 = hudMaterial
	test.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	test.level			 = DEFAULT_LEVEL
	test.parent_element  = base.name
	test.element_params  = {"AVS7_BRIGHTNESS"}
	test.controllers     = {{"opacity_using_parameter", 0}}
	Add(test)
	return test
end

local w = 0.3
local h = 0.04
local verts =
{
	{-w,h},
	{w,h},
	{w,-h},
	{-w,-h},
}

local hdgMask			= CreateElement "ceMeshPoly"
hdgMask.name			= "hdgMask"
hdgMask.vertices		= verts
hdgMask.indices			= default_box_indices
hdgMask.init_pos		= {0,0.27}
hdgMask.material		= MakeMaterial(nil,{255,0,0,128})
hdgMask.h_clip_relation	= h_clip_relations.REWRITE_LEVEL
hdgMask.level			= CLIP_LEVEL
hdgMask.isdraw			= true
hdgMask.isvisible		= false
hdgMask.parent_element	= base.name
Add(hdgMask)

local hdgHolder = CreateElement "ceSimple"
hdgHolder.parent_element = hdgMask.name
hdgHolder.element_params  = {"AVS7_BRIGHTNESS", "AVS7_HEADING"}
hdgHolder.controllers     = {{"opacity_using_parameter",0}, {"move_left_right_using_parameter",1,-0.005}}
hdgHolder.level			= DEFAULT_LEVEL
Add(hdgHolder)

local hdgScale = 200

for i=-90,500,10 do
	line = addLine(i / hdgScale, 0.16 + horizonOffset, 0.03, 0)
	line.name = "line"..tostring(i)
	line.parent_element = hdgHolder.name
	line.level			= CLIP_LEVEL

	if i == 0 or i == 360 then
		text = addText(-0.001 + (i) / hdgScale, 0.21 + horizonOffset, "N")
		text.parent_element = hdgHolder.name
		text.level			= CLIP_LEVEL
	elseif i == 90 or i == 450 then
		text = addText(-0.001 + (i) / hdgScale, 0.21 + horizonOffset, "E")
		text.parent_element = hdgHolder.name
		text.level			= CLIP_LEVEL
	elseif i == 180 then
		text = addText(-0.001 + (i) / hdgScale, 0.21 + horizonOffset, "S")
		text.parent_element = hdgHolder.name
		text.level			= CLIP_LEVEL
	elseif i == 270 or i == -90 then
		text = addText(-0.001 + (i) / hdgScale, 0.21 + horizonOffset, "W")
		text.parent_element = hdgHolder.name
		text.level			= CLIP_LEVEL
	elseif i % 30 == 0 then
		local strValue = i
		if strValue > 360 then
			strValue = strValue - 360
		elseif strValue < 0 then
			strValue = strValue + 360
		end

		text = addText(-0.001 + (i) / hdgScale, 0.21 + horizonOffset, strValue / 10)
		text.parent_element = hdgHolder.name
		text.level			= CLIP_LEVEL
	end
end

local hdgDemask			= Copy(hdgMask)
hdgDemask.h_clip_relation	= h_clip_relations.DECREASE_LEVEL
Add(hdgDemask)

-- Heading reference line
addLine(0,0.40 + horizonOffset,0.03,0)

-- Reference Line
local attRefLine1 = addHorizontalLine(-0.15,horizonOffset,0.1,0)
local attRefLine3 = addHorizontalLine(0.05,horizonOffset,0.1,0)
local attRefLine2 = addLine(-0.038,-0.06,0.01,0)
local attRefLine4 = addLine(0.036,-0.06,0.01,0)

attRefLine1.element_params  = {"AVS7_BRIGHTNESS", "AVS7_HORIZON_VIS"}
attRefLine1.controllers  = {{"opacity_using_parameter",0}, {"parameter_in_range", 1, 0.5, 1.1}}
attRefLine2.element_params  = {"AVS7_BRIGHTNESS", "AVS7_HORIZON_VIS"}
attRefLine2.controllers  = {{"opacity_using_parameter",0}, {"parameter_in_range", 1, 0.5, 1.1}}
attRefLine3.element_params  = {"AVS7_BRIGHTNESS", "AVS7_HORIZON_VIS"}
attRefLine3.controllers  = {{"opacity_using_parameter",0}, {"parameter_in_range", 1, 0.5, 1.1}}
attRefLine4.element_params  = {"AVS7_BRIGHTNESS", "AVS7_HORIZON_VIS"}
attRefLine4.controllers  = {{"opacity_using_parameter",0}, {"parameter_in_range", 1, 0.5, 1.1}}

-- Horizon Line
local horizonLineL3 = addHorizontalLine(-0.325,horizonOffset,0.05,0)
local horizonLineL2 = addHorizontalLine(-0.225,horizonOffset,0.05,0)
local horizonLineL1 = addHorizontalLine(-0.125,horizonOffset,0.05,0)
local horizonLineC  = addHorizontalLine(-0.025,horizonOffset,0.05,0)
local horizonLineR1 = addHorizontalLine(0.075,horizonOffset,0.05,0)
local horizonLineR2 = addHorizontalLine(0.175,horizonOffset,0.05,0)
local horizonLineR3 = addHorizontalLine(0.275,horizonOffset,0.05,0)

horizonLineL3.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_HORIZON_VIS"}
horizonLineL3.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
horizonLineL2.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_HORIZON_VIS"}
horizonLineL2.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
horizonLineL1.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_HORIZON_VIS"}
horizonLineL1.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
horizonLineC.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_HORIZON_VIS"}
horizonLineC.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
horizonLineR1.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_HORIZON_VIS"}
horizonLineR1.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
horizonLineR2.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_HORIZON_VIS"}
horizonLineR2.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
horizonLineR3.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_HORIZON_VIS"}
horizonLineR3.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}

-- Pitch Ladder
pitchLadderU10 = addHorizontalLine(-0.025, 0.05 + horizonOffset, 0.05, 0)
pitchLadderU20 = addHorizontalLine(-0.025, 0.1 + horizonOffset, 0.05, 0)
pitchLadderU30 = addHorizontalLine(-0.025, 0.15 + horizonOffset, 0.05, 0)
pitchLadderD10 = addHorizontalLine(-0.025, -0.05 + horizonOffset, 0.05, 0)
pitchLadderD20 = addHorizontalLine(-0.025, -0.1 + horizonOffset, 0.05, 0)
pitchLadderD30 = addHorizontalLine(-0.025, -0.15 + horizonOffset, 0.05, 0)

pitchLadderU10.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_BANKANGLE_VIS"}
pitchLadderU10.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
pitchLadderU20.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_BANKANGLE_VIS"}
pitchLadderU20.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
pitchLadderU30.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_BANKANGLE_VIS"}
pitchLadderU30.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
pitchLadderD10.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_BANKANGLE_VIS"}
pitchLadderD10.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
pitchLadderD20.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_BANKANGLE_VIS"}
pitchLadderD20.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}
pitchLadderD30.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_PITCHANGLE", "AVS7_BANKANGLE_VIS"}
pitchLadderD30.controllers  = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"move_up_down_using_parameter",2,.005}, {"parameter_in_range", 3, 0.5, 1.1}}

-- Roll Scale
--addRadialLine(x,y,l,r,o)
rollIndC   = addRadialLine(0.5 + horizonOffset, 0.53 + horizonOffset,   0)
rollIndL30 = addRadialLine(0.5 + horizonOffset, 0.53 + horizonOffset, 330)
rollIndL20 = addRadialLine(0.5 + horizonOffset, 0.53 + horizonOffset, 340)
rollIndL10 = addRadialLine(0.5 + horizonOffset, 0.53 + horizonOffset, 350)
rollIndR10 = addRadialLine(0.5 + horizonOffset, 0.53 + horizonOffset,  10)
rollIndR20 = addRadialLine(0.5 + horizonOffset, 0.53 + horizonOffset,  20)
rollIndR30 = addRadialLine(0.5 + horizonOffset, 0.53 + horizonOffset,  30)

rollInd = addRadialLine(0.47 + horizonOffset,0.5 + horizonOffset,  0)
rollInd.element_params  = {"AVS7_BRIGHTNESS", "AVS7_BANKANGLE", "AVS7_BANKANGLE_VIS"}
rollInd.controllers     = {{"opacity_using_parameter",0}, {"rotate_using_parameter",1,-1}, {"parameter_in_range", 2, 0.5, 1.1}}

vsScaleY = 0.1

-- VS/AGL Scale
AGL200 = addHorizontalLine(0.55, 0.15 + horizonOffset + vsScaleY,0.05,0)
AGL150 = addHorizontalLine(0.55, 0.00 + horizonOffset + vsScaleY,0.05,0)
AGL100 = addHorizontalLine(0.55,-0.15 + horizonOffset + vsScaleY,0.05,0)
AGL50  = addHorizontalLine(0.55,-0.30 + horizonOffset + vsScaleY,0.05,0)
AGL40  = addHorizontalLine(0.55,-0.33 + horizonOffset + vsScaleY,0.05,0)
AGL30  = addHorizontalLine(0.55,-0.36 + horizonOffset + vsScaleY,0.05,0)
AGL20  = addHorizontalLine(0.55,-0.39 + horizonOffset + vsScaleY,0.05,0)
AGL10  = addHorizontalLine(0.55,-0.42 + horizonOffset + vsScaleY,0.05,0)
AGL0   = addHorizontalLine(0.55,-0.45 + horizonOffset + vsScaleY,0.05,0)

-- AGL Ind
local rdrAltInd 			= CreateElement "ceSimpleLineObject"
rdrAltInd.name 			    = create_guid_string()
rdrAltInd.material 		    = hudMaterial
rdrAltInd.primitivetype     = "triangles"
rdrAltInd.width			    = 0.014
rdrAltInd.vertices          = {{0,0}, {0,0}, {.1,0}}
rdrAltInd.init_pos 		    = {0.418, -0.21 + horizonOffset + vsScaleY}
rdrAltInd.parent_element    = base.name
rdrAltInd.h_clip_relation   = h_clip_relations.COMPARE
rdrAltInd.level	    		= DEFAULT_LEVEL
rdrAltInd.element_params    = {"AVS7_BRIGHTNESS", "AVS7_RDR_ALT_LINE", "AVS7_RDR_ALT_VIS"}
--{"line_object_set_point_using_parameters", point_nr, param_x, param_y, gain_x, gain_y} -- applies to ceSimpleLineObject at least
rdrAltInd.controllers 	    =
{
	{"line_object_set_point_using_parameters", 1, 1, 1, 0, 0.465},
	{"line_object_set_point_using_parameters", 2, 1, 1, 0, 0.465},
	{"opacity_using_parameter", 2}
}
Add(rdrAltInd)

function addChevron(x,y,w,h,r)
	local test 			 = CreateElement "ceStringPoly"
	test.name 			 = create_guid_string()
	test.vertices 		 = {{x, y}, {x + w, y + h/2}, {x,y + h}}
	test.indices 		 = {0,1,2,2,1,1,0}
	test.init_pos		 = center
	test.init_rot		 = {r}
	test.material		 = hudMaterial
	test.h_clip_relation = h_clip_relations.COMPARE
	test.level			 = DEFAULT_LEVEL
	test.parent_element  = base.name
	test.collimated = true
	test.element_params  = {"AVS7_BRIGHTNESS"}
	test.controllers     = {{"opacity_using_parameter", 0}}
	Add(test)
	return test
end

vsInd = addChevron(0.51, -0.171 + horizonOffset + vsScaleY, 0.04, 0.05, 0)
vsInd.element_params  = {"AVS7_BRIGHTNESS", "AVS7_VS"}
vsInd.controllers     = {{"opacity_using_parameter",0}, {"move_up_down_using_parameter",1,0.00015}}

function addWPToInd(x,y,w,h,t)
	local test 			 = CreateElement "ceStringPoly"
	test.name 			 = create_guid_string()
	test.vertices 		 = {{x, y}, {x + w, y}, {(x + w) / 2 + t / 2, y + h}, {x + t, y}, {x + w + t, y}, {(x + w) / 2 + t / 2, y + h - (t * 1.2)}}
	test.indices 		 = {0,2,3, 2,3,5, 2,1,5, 2,1,4}
	test.init_pos		 = center
	test.init_rot		 = {0}
	test.material		 = hudMaterial
	test.h_clip_relation = h_clip_relations.COMPARE
	test.level			 = DEFAULT_LEVEL
	test.parent_element  = base.name
	test.collimated = true
	test.element_params  = {"AVS7_BRIGHTNESS"}
	test.controllers     = {{"opacity_using_parameter", 0}}
	Add(test)
	return test
end

function addWPFromInd(x,y,w,h,t)
	local test 			 = CreateElement "ceStringPoly"
	test.name 			 = create_guid_string()
	test.vertices 		 = {{x, y}, {x + w, y}, {(x + w) / 2 + t / 2, y - h}, {x + t, y}, {x + w + t, y}, {(x + w) / 2 + t / 2, y - h + (t * 1.2)}}
	test.indices 		 = {0,2,3, 2,3,5, 2,1,5, 2,1,4}
	test.init_pos		 = center
	test.init_rot		 = {0}
	test.material		 = hudMaterial
	test.h_clip_relation = h_clip_relations.COMPARE
	test.level			 = DEFAULT_LEVEL
	test.parent_element  = base.name
	test.collimated = true
	test.element_params  = {"AVS7_BRIGHTNESS"}
	test.controllers     = {{"opacity_using_parameter", 0}}
	Add(test)
	return test
end

local x = 0
local y = 0.36 + horizonOffset
local w = 0.038
local h = 0.03
local t = 0.006

wpToInd = addWPToInd(x, y, w, h, t)
wpToInd.element_params  = {"AVS7_WPIND", "AVS7_WPTO_DISPLAY"}
wpToInd.controllers     = {{"move_left_right_using_parameter",0, 0.35, -0.35}, {"opacity_using_parameter",1}}

wpFromInd = addWPFromInd(x, y + h, w, h, t)
wpFromInd.element_params  = {"AVS7_WPIND", "AVS7_WPFROM_DISPLAY"}
wpFromInd.controllers     = {{"move_left_right_using_parameter",0, 0.35, -0.35}, {"opacity_using_parameter",1}}

-- SLIP Ind
local slipYAdjust = 0.1
addHorizontalLine(-0.2, -0.75 + slipYAdjust,0.4,0)
addLine(-0.03,-0.48 + slipYAdjust,0.06,0)
addLine(0.03,-0.48 + slipYAdjust,0.06,0)

local   slipCircle 			= CreateElement "ceMeshPoly"
slipCircle.init_pos		    = {0.001, -0.35, 0}
slipCircle.name 			= "slipCircle"
slipCircle.material 		= hudMaterial
slipCircle.level			= DEFAULT_LEVEL
slipCircle.h_clip_relation	= h_clip_relations.COMPARE
slipCircle.parent_element 	= base.name
slipCircle.element_params	= {"AVS7_BRIGHTNESS", "PILOT_VSI_SLIP_IND"}
slipCircle.controllers 		= {{"opacity_using_parameter",0}, {"move_left_right_using_parameter", 1, 0.2, -0.2}}
set_circle	(slipCircle, 0.045 * 0.6, 0.05 * 0.6, 360, 32)
Add(slipCircle)

--[[

local vvBase 			= CreateElement "ceMeshPoly"
vvBase.name 			= create_guid_string()
vvBase.vertices 		= verts
vvBase.indices 		    = {0,1,2,2,3,0}
vvBase.init_pos		    = {0,horizonOffset,1.5}
vvBase.material		    = MakeMaterial(nil,{0,0,0,144})
vvBase.h_clip_relation  = h_clip_relations.REWRITE_LEVEL
vvBase.level			= 6
vvBase.isvisible		= false
vvBase.parent_element   = base.name
vvBase.element_params   = {"AVS7_BRIGHTNESS", "AVS7_VV_ROT", "AVS7_VV_VIS"}
vvBase.controllers      = {{"opacity_using_parameter",0}, {"rotate_using_parameter", 1, 1}, {"parameter_in_range", 2, 0.9, 1.1}}
Add(vvBase)

local vvLine 			= CreateElement "ceSimpleLineObject"
vvLine.name 		    = create_guid_string()
vvLine.material 		= hudMaterial
vvLine.primitivetype    = "lines"
vvLine.width			= 0.01
vvLine.vertices         = {{0,0}, {0,0}}
vvLine.init_pos 		= {0,0,0}
vvLine.parent_element   = vvBase.name
vvLine.h_clip_relation  = h_clip_relations.REWRITE_LEVEL
vvLine.level	    	= 6
vvLine.element_params   = {"AVS7_BRIGHTNESS", "AVS7_VV_MAG"}
vvLine.controllers 	    = {{"opacity_using_parameter",0}, {"line_object_set_point_using_parameters", 0, 1, 1, 0, 0.18}}
Add(vvLine)

local vvInd 			= CreateElement "ceSimpleLineObject"
vvInd.name 			    = create_guid_string()
vvInd.material 		    = hudMaterial
vvInd.primitivetype     = "lines"
vvInd.width			    = 0.01
vvInd.vertices          = {{0,-0.02}, {-0.02,0}, {0,0.02}, {0.02,0}, {0,-0.02}}
vvInd.init_pos 		    = {0,0,0}
vvInd.parent_element    = vvLine.name
vvInd.h_clip_relation   = h_clip_relations.REWRITE_LEVEL
vvInd.level	    		= 6
vvInd.element_params    = {"AVS7_BRIGHTNESS", "AVS7_VV_MAG"}
vvInd.controllers 	    = {{"opacity_using_parameter",0}, {"move_up_down_using_parameter", 1, 0.2}}
Add(vvInd)
]]
