
local lastTimer = 0;
local lastScan = 0;
local DLLPath = lfs.writedir()..'Scripts\\Hooks\\'
package.cpath = package.cpath..';'..DLLPath..'?.dll;'

log.write('OH6GunnerExport',log.INFO,'LoadDLL' )
local gunnerExport = require('OH6GunnerDataExport')
log.write('OH6GunnerExport',log.INFO,'DLL loaded' )

local terrain = require('terrain')

local scannedUnits = {}
local scanDistance = 10000

local mmo ={}
local vx 
local vy 
local vz 
local dx 
local dy 
local dz 
local sqr_dist
local los
local count
local own_id

local ox 
local oy 
local oz 
local own_data

local update_rate = 0.02
gunnerExport.setUpdateRate(update_rate)

local t

local now

local OH6_GunnerExport = {}

function OH6_GunnerExport.onSimulationStart()
	log.write('OH6GunnerExport',log.INFO,'Gunner Export init' )
end

function OH6_GunnerExport.onSimulationStop()
	log.write('OH6GunnerExport',log.INFO,'Gunner Export stop')
end

function is_hostile(a, b)
	if b.CoalitionID == 0 then return false end
	return a.CoalitionID ~= b.CoalitionID
end

function send_stuff()
	own_data = Export.LoGetSelfData()
    if own_data ~= nil then
		--net.log(own_data.Name)
		if own_data.Name == "OH-6A" or own_data.Name == "AH-6J" or own_data.Name == "MH-6J" then
			local payload = Export.LoGetPayloadInfo()
			local skip = true
			if own_data.Name == "OH-6A" then 
				local doorgun = payload.Stations[11]
			
				if doorgun.weapon.level1 ~= 0 then
					skip = false
				end
				
				local specialgear = payload.Stations[12]
				if specialgear.weapon.level1 ~=0 then 
					skip = false
				end
			end
			
			if own_data.Name == "AH-6J" or own_data.Name == "MH-6J" then 
				local specialgear = payload.Stations[4]
				if specialgear.weapon.level1 ~=0 then 
					skip = false
				end
			end
			

			if own_data.Name == "MH-6J" then 
				local doorgun = payload.Stations[9]
				if doorgun.weapon.level1 ~=0 then
					skip = false
				end
				doorgun = payload.Stations[10]
				if doorgun.weapon.level1 ~=0 then
					skip = false
				end
				doorgun = payload.Stations[11]
				if doorgun.weapon.level1 ~=0 then
					skip = false
				end
				doorgun = payload.Stations[12]
				if doorgun.weapon.level1 ~=0 then
					skip = false
				end
			end
			
			if not skip then 
				own_id = Export.LoGetPlayerPlaneId()
		
				ox = own_data.Position.x
				oy = own_data.Position.y
				oz = own_data.Position.z
				mmo={}
				--local mmo = Export.LoGetWorldObjects("units")
				count =0
				gunnerExport.start()
				for k,pre_v in pairs(scannedUnits) do
					local v = Export.LoGetObjectById(k)
					
					if count <50 then 
						if v ~= nil then 
							if v.GroupName ~= nil then
								if is_hostile(own_data, v) then
									vx = v.Position.x
									vy = v.Position.y
									vz = v.Position.z
									dx = (ox-vx)
									dy = (oy-vy)
									dz = (oz-vz)
									sqr_dist = dx*dx+dy*dy+dz*dz
									if sqr_dist < 4000000 then --2000*2000 m 
										los = terrain.isVisible(ox, oy, oz, vx,vy,vz)
										if los then
											gunnerExport.sendData(k, v.Type.level4, vx, vy, vz)
											count = count+1
										end
									end  
								end
									
							end
						end
					end
					--mmo[k] = nil
				end
				--mmo = nil
				gunnerExport.finish()
			end
		end
	end
		
end

function OH6_GunnerExport.updateUnitsList()
    local playerID = Export.LoGetPlayerPlaneId()
    local player = Export.LoGetObjectById(playerID)
    scannedUnits = {}
    if player then
        local o = Export.LoGetWorldObjects("units")
        for k, v in pairs(o) do
			if k ~= playerID then
                local dist = ((v.Position.x - player.Position.x) * (v.Position.x - player.Position.x)) + ((v.Position.y - player.Position.y) * (v.Position.y - player.Position.y)) + ((v.Position.z - player.Position.z) * (v.Position.z - player.Position.z))
				--net.log(dist)
                if dist < scanDistance*scanDistance then
                    scannedUnits[k] = v
					--net.log("add")
                end
            end
        end
    end
	--net.log(table.getn(scannedUnits))
end

function OH6_GunnerExport.onSimulationFrame()
	t = Export.LoGetModelTime()
	if t > 5 then 
		now = DCS.getRealTime()
		if now >= lastScan + 3.0 then 
			--net.log("OH6_Gunner Scan")
			OH6_GunnerExport.updateUnitsList()
			lastScan = now
		end
		if now >= lastTimer + update_rate then
			--net.log("OH6_Gunner Send")
			send_stuff()
			lastTimer = now;
		end
	end
end

DCS.setUserCallbacks(OH6_GunnerExport)

net.log("OH6_Gunner Loaded...")


