local self_ID = "AH-6J"

declare_plugin(self_ID,
	{
		dirName       = current_mod_path,
		displayName   = _("AH-6J"),
		fileMenuName  = _("AH-6J"),
		version 		= "1.0",
		state         = "installed",
		info          = _("The AH-6J"),

		binaries      =
		{
			'AH6J',
		},
		Skins         =
		{
			{
				name	= "AH-6J",
				dir		= "Theme"
			}
			
		},
		LogBook       =
		{
			{
				name = _("AH-6J"),
				type = "AH-6J",
			},
		},
		InputProfiles =
		{
			["AH-6J"] = current_mod_path .. '/Input',
		},
		Missions =
		{
			{
				name		= _("AH-6J"),
				dir			= "Missions",
				},
		},
		Options       =
		{
			{
				name   = _("AH-6J"),
				nameId = "AH-6J",
				dir    = "Options",
				CLSID  = "{AH-6J options}"
			},
		},
	})
-------------------------------------------------------------------------------
mount_vfs_model_path(current_mod_path .. "/Shapes")
mount_vfs_liveries_path(current_mod_path .. "/Liveries")
--------------------------------------------------------------------------------
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/Fonts")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/cockpit")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/Exterior")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/extra")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/gunner")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/weapons")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/weapons/grenades")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/pilots")
mount_vfs_texture_path(current_mod_path .. "/Shapes/textures/extra")

--------------------------------------------------------------------------------
mount_vfs_texture_path(current_mod_path ..  "/Theme/ME")
mount_vfs_texture_path(current_mod_path .. "/Skins/1/ME")


dofile(current_mod_path .. '/UnitPayloads/AH-6J.lua')
dofile(current_mod_path .. "/Views.lua")
dofile(current_mod_path .. "/Suspension.lua")
dofile(current_mod_path .. '/AH6.lua')
dofile(current_mod_path .. '/AH6_cargo.lua')



local FM =
{
	[1] = self_ID,
	[2] = "AH6J",                              -- name of dll
	center_of_mass = { cog_x, cog_y, cog_z }, -- center of mass position relative to object 3d model center
	
	moment_of_inertia = { 246,1009,979, 128 }, -- moment of inertia of empty 
	suspension = suspension,
}


make_view_settings('MH-6J',ViewSettings, SnapViews)
make_flyable('MH-6J', current_mod_path .. '/Cockpit/Scripts/', FM, current_mod_path .. '/comm.lua')

make_view_settings('AH-6J', ViewSettings, SnapViews)
make_flyable('AH-6J', current_mod_path .. '/Cockpit/Scripts/', FM, current_mod_path .. '/comm.lua')

plugin_done()
