dofile(LockOn_Options.script_path .. "clickable_defs.lua")
dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.script_path .. "devices.lua")
dofile(LockOn_Options.script_path .. "sounds.lua")

local gettext                 = require("i_18n")
_                             = gettext.translate

elements                      = {}

-- Baro Altimeter
elements["C_Knob_BaroAlt"]    = default_axis(_("adjust pressure"), devices.BASIC_INDICATORS,
    device_commands.avionic_baroAltPressure, 327, 0, 0.01, false, true, true)
elements["C_knob_radar_alt1"] = default_axis(_("Radar Altitude Low"), devices.BASIC_INDICATORS,
    device_commands.radarAltLow, 332, 0, 0.01, false, true, true)
elements["C_knob_radar_alt2"] = default_axis(_("Radar Altitude High"), devices.BASIC_INDICATORS,
    device_commands.radarAltHigh, 333, 0, 0.01, false, true, true)



-- Panel Switches: ----------------------------------------------------
elements["C_StrobeSwitchMaster"] = default_2bis_position_tumb(_("Strobe Top/Both"), devices.LIGHT_INTERFACE,
    device_commands.MPS_StrobeTopBoth, 40, 20)
elements["C_StrobeSwitchMode"]   = multiposition_switch(_("Strobe Norm/Off/Cvrt"), devices.LIGHT_INTERFACE,
    device_commands.MPS_StrobeMode, 41, 3, 0.5, false, 0.0, 100, false)

elements["C_PosLightSwitchMode"] = multiposition_switch(_("Pos Light Norm/Off/Cvrt"), devices.LIGHT_INTERFACE,
    device_commands.MPS_PosLightMode, 42, 3, 0.5, false, 0.0, 100, false)
elements["C_PosLightDimKnob"]    = multiposition_switch(_("Pos Light Dim"), devices.LIGHT_INTERFACE,
    device_commands.MPS_PosLightDim, 43, 5, 0.25, false, 0.0, 100, false)

elements["C_vids_panel_knob"]    = default_axis_limited(_("VIDS Dim"), devices.LIGHT_INTERFACE,
    device_commands.lights_vids_dim, 80, 0, 0.05, true, false, { 0, 1 })


elements["C_Rad_Alt_Brightness"]      = default_axis_limited(_("Rad Alt Brightness"), devices.LIGHT_INTERFACE,
    device_commands.lights_rdralt, 48, 0, 0.05, true, false, { 0, 1 })
elements["C_Fuel_Ind_Brightness"]     = default_axis_limited(_("Fuel Qty Brightness"), devices.LIGHT_INTERFACE,
    device_commands.lights_fqi, 49, 0, 0.05, true, false, { 0, 1 })
elements["C_AMS_Brightness"]          = default_axis_limited(_("AMS Brightness"), devices.LIGHT_INTERFACE,
    device_commands.MPS_AMSDim, 50, 0, 0.05, true, false, { 0, 1 })
elements["C_DHI_Brightness"]          = default_axis_limited(_("DHI Brightness"), devices.LIGHT_INTERFACE,
    device_commands.lights_dhi, 51, 0, 0.05, true, false, { 0, 1 })
elements["C_Panel_lights_Brightness"] = default_axis_limited(_("Panel Brightness"), devices.LIGHT_INTERFACE,
    device_commands.MPS_PanelsDim, 52, 0, 0.05, true, false, { 0, 1 })
elements["C_Radio_Brightness"]        = default_axis_limited(_("Radio Brightness"), devices.LIGHT_INTERFACE,
    device_commands.lights_radio, 53, 0, 0.05, true, false, { 0, 1 })

elements["C_LaserClockSwitch"]        = default_2bis_position_tumb(_("Laser Clock ON/OFF"), devices.ELECTRIC_SYSTEM,
    device_commands.MPS_LaserClock, 54, 20)
elements["C_MasterRadioSwitch"]       = default_2bis_position_tumb(_("Master Radio ON/OFF"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_master_radio, 55, 20)
elements["C_AttIndSwitch"]            = default_2bis_position_tumb(_("Att Ind"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_att_ind, 56, 20)
elements["C_InvSwitch"]               = default_2bis_position_tumb(_("Inverter ON/OFF"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_inverter, 57, 20)
elements["C_GenSwitch"]               = default_2bis_position_tumb(_("Gen ON/OFF"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_gen, 58, 20)
elements["C_BattExtSwitch"]           = multiposition_switch(_("BATT/OFF/EXT"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_batt, 59, 3, 0.5, false, 0, 100, false)
elements["C_AntIceSwitch"]            = default_2bis_position_tumb(_("Anti Ice ON/OFF"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_anti_ice, 60, 20)
elements["C_AuxPwrSwitch"]            = default_2bis_position_tumb(_("Aux Pwr ON/OFF"), devices.ELECTRIC_SYSTEM,
    device_commands.MPS_AuxPwr, 61, 20)
elements["C_Reignite test/armed"]     = default_2bis_position_tumb(_("Reignite"), devices.ELECTRIC_SYSTEM,
    device_commands.engine_reignition, 62, 20)
elements["C_StartPumPSwitch"]         = default_2bis_position_tumb(_("Start Pump ON/OFF"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_start_pump, 63, 20)
elements["C_PitotHeatSwitch"]         = default_2bis_position_tumb(_("Pitot"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_pitot, 64, 20)
elements["C_ScavAirSwitch"]           = default_2bis_position_tumb(_("ScavAir"), devices.ELECTRIC_SYSTEM,
    device_commands.electricsystem_scavair, 65, 20)

--Missing Argument
--elements["C_PosLightSwitchMode.007"]= default_2bis_position_tumb(_("Fuel 4 Pos ON/OFF"), 	devices.ELECTRIC_SYSTEM, device_commands.MPS_Fuel4Pos		xx, 20)
--fuel 4 pos sw

-- Fuel --------------------------------------------------------------------------------

elements["C_fuel_cutoff_lever"]       = multiposition_switch(_("Fuel Valve"), devices.FUEL_INTERFACE,
    EFM_commands.fuelsystem_fuel_valve, 251, 2, 1.0, false, 0.0, 1, false)

elements["C_Fuel_Selector_Lever"]     = multiposition_switch(_("Fuel Transfer Selection"), devices.FUEL_INTERFACE,
    device_commands.fuel_transfer, 255, 3, 0.5, false, 0.0, 100, false)


-- Radios ------------------------------------------------------------------------
-- AN/Arc-210 ------------
elements["C_arc210_knob_1"]   = default_axis_limited(_("ARC210 Vol"), devices.AN_ARC_210,
    device_commands.ARC210_Vol, 651, 0, 0.05, true, false, { 0.0, 1.0 })
elements["C_arc210_knob_2"]   = multiposition_switch(_("ARC210 Mode"), devices.AN_ARC_210,
    device_commands.ARC210_Mode, 652, 6, 0.2, false, 0.0, 100, false)
elements["C_arc210_knob_3"]   = default_button_axis(_("ARC210 Chan/Freq"), devices.AN_ARC_210,
    device_commands.ARC210_Channel_Push,device_commands.ARC210_Channel_Axis,1000,653, 20)
elements["C_arc210_knob_4"]   = multiposition_switch(_("ARC210 Prst"), devices.AN_ARC_210,
    device_commands.ARC210_Freq_Mode, 654, 7, 1.0 / 6.0, false, 0.0, 100, false)
elements["C_arc210_button_1"] = default_button(_("ARC210 >"), devices.AN_ARC_210,
    device_commands.ARC210_Button_1, 655, 20)
elements["C_arc210_button_2"] = default_button(_("ARC210 -"), devices.AN_ARC_210,
    device_commands.ARC210_Button_2, 656, 20)
elements["C_arc210_button_3"] = default_button(_("ARC210 Load"), devices.AN_ARC_210,
    device_commands.ARC210_Load, 657, 20)

-- AN/Arc-182 ------------
elements["C_arc182_switch_1"] = default_2bis_position_tumb(_("ARC182 SQL"), devices.AN_ARC_182,
    device_commands.ARC182_Sql, 621, 20)
    
elements["C_arc182_switch_2"] = springloaded_3_pos_tumb(_("ARC182 10MHz"), devices.AN_ARC_182,
    device_commands.ARC182_10MHz_down,device_commands.ARC182_10MHz_up,622,20)
elements["C_arc182_switch_3"] = springloaded_3_pos_tumb(_("ARC182 1MHz"), devices.AN_ARC_182,
    device_commands.ARC182_1MHz_down,device_commands.ARC182_1MHz_up,623,20)
elements["C_arc182_switch_4"] = springloaded_3_pos_tumb(_("ARC182 100KHz"), devices.AN_ARC_182,
    device_commands.ARC182_100KHz_down,device_commands.ARC182_100KHz_up,624,20)
elements["C_arc182_switch_5"] = springloaded_3_pos_tumb(_("ARC182 10KHz"), devices.AN_ARC_182,
    device_commands.ARC182_10KHz_down,device_commands.ARC182_10KHz_up,625,20)

elements["C_arc182_switch_6"] = default_2bis_position_tumb(_("ARC182 AM/FM"), devices.AN_ARC_182,
    device_commands.ARC182_AM_FM, 626, 20)
elements["C_arc182_knob_1"]   = default_axis_limited(_("ARC182 VOL"), devices.AN_ARC_182,
    device_commands.ARC182_Vol, 627, 0, 0.05, true, false, { 0.0, 1.0 })
elements["C_arc182_knob_2"]   = multiposition_switch(_("ARC182 CHANNEL"), devices.AN_ARC_182,
    device_commands.ARC182_Freq_Mode, 628, 5, 0.25, false, 0.0, 100, false)
elements["C_arc182_knob_2_top"]   = default_axis(_("ARC182 Preset"), devices.AN_ARC_182,
    device_commands.ARC182_Preset, 631, 0, 0.1, true, true, true)
    elements["C_arc182_knob_3"]   = default_axis_limited(_("ARC182 BRT"), devices.AN_ARC_182,
    device_commands.ARC182_Brt, 629, 0, 0.05, true, false, { 0.0, 1.0 })
elements["C_arc182_knob_4"]   = multiposition_switch(_("ARC182 MODE"), devices.AN_ARC_182,
    device_commands.ARC182_Mode, 630, 8, 1.0 / 7.0, false, 0.0, 100, false)

-- AN/Arc-186 ------------
elements["C_arc186_knob_1"]   = default_axis_limited(_("ARC186 VOL"), devices.AN_ARC_186,
    device_commands.ARC186_Vol, 601, 0, 0.05, true, false, { 0.0, 1.0 })
elements["C_arc186_knob_2"]   = multiposition_switch(_("ARC186 MODE"), devices.AN_ARC_186,
    device_commands.ARC186_Mode, 602, 4, 1.0 / 3.0, false, 0.0, 100, false)


elements["C_arc186_knob_3"] = multiposition_switch(_("ARC186 10MHz"), devices.AN_ARC_186,
    device_commands.ARC186_10M, 603, 13, 1.0 / 12.0, false, 0.0, 100, true)
elements["C_arc186_knob_4"] = multiposition_switch(_("ARC186 1MHz"), devices.AN_ARC_186,
    device_commands.ARC186_1M, 604, 10, 1.0 / 9.0, false, 0.0, 100, true)
elements["C_arc186_knob_5"] = multiposition_switch(_("ARC186 100KHz"), devices.AN_ARC_186,
    device_commands.ARC186_100K, 605, 10, 1.0 / 9.0, false, 0.0, 100, true)
elements["C_arc186_knob_6"] = multiposition_switch(_("ARC186 10KHz"), devices.AN_ARC_186,
    device_commands.ARC186_10K, 606, 4, 1.0 / 3.0, false, 0.0, 100, true)

elements["C_arc186_knob_7"] = multiposition_switch(_("ARC186 TR/DF"), devices.AN_ARC_186,
    device_commands.ARC186_POWER, 607, 3, 0.5, false, 0.0, 100, false)
elements["C_arc186_wheel"]  = multiposition_switch(_("ARC186 WHEEL"), devices.AN_ARC_186,
    device_commands.ARC186_Wheel, 608, 20, 1 / 19.0, false, 0.0, 100, false)
elements["C_arc186_switch"] = default_2bis_position_tumb(_("ARC186 TONE"), devices.AN_ARC_186,
    device_commands.ARC186_Tone, 609, 20)


elements["C_fqi_switch"] = default_button(_("FQI, AUX"), devices.FUEL_INTERFACE,
    device_commands.fqi_aux, 67, 20)


-- RWR -----------------------------------------------------------------------------
elements["C_RWR_Brightness_PTR"] = default_axis_limited(_("RWR, Brightness"), devices.RWR, device_commands.RWRBrightness,
    72, 0.5)

-- CounterMeasures
elements["C_Switch_CMWS"]        = multiposition_switch(_("CMWS Arm/Safe"), devices.WEAPON_SYSTEM,
    device_commands.FlareArmSafe, 660, 2, 1.0, false, 0.0, 20, true)
elements["C_CMWS_Disp"]          = default_button(_("Flare Dispense"), devices.WEAPON_SYSTEM, device_commands.DropFlare,
    661, 20)

-- ARMAMENT ------------------------------------------------------------------------
--add function : default_2bis_position_tumb arg => 0 to 1 & 1 to 0

elements["C_arm_panel_switch_1"]      = default_2bis_position_tumb(_("LEFT PWR/OFF"), devices.WEAPON_SYSTEM,
    device_commands.LEFT_gun_pwr, 143, 20)
elements["C_arm_panel_switch_2"]      = default_2bis_position_tumb(_("LEFT ARM/OFF"), devices.WEAPON_SYSTEM,
    device_commands.LEFT_gun_arm, 144, 20)
elements["C_arm_panel_switch_3"]      = default_2bis_position_tumb(_("LEFT NORM/CLEAR"), devices.WEAPON_SYSTEM,
    device_commands.LEFT_gun_clear, 145, 20)
elements["C_arm_panel_switch_4"]      = default_2bis_position_tumb(_("RIGHT PWR/OFF"), devices.WEAPON_SYSTEM,
    device_commands.RIGHT_gun_pwr, 146, 20)
elements["C_arm_panel_switch_5"]      = default_2bis_position_tumb(_("RIGHT ARM/OFF"), devices.WEAPON_SYSTEM,
    device_commands.RIGHT_gun_arm, 147, 20)
elements["C_arm_panel_switch_6"]      = default_2bis_position_tumb(_("RIGHT NORM/CLEAR"), devices.WEAPON_SYSTEM,
    device_commands.RIGHT_gun_clear, 148, 20)

elements["AMS_PWR_Switch"]            = default_2bis_position_tumb(_("AMS Pwr"), devices.WEAPON_SYSTEM,
    device_commands.AMS_PWR, 150, 20)
elements["C_AMS_Button_1"]            = default_button(_("AMS Button 1"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Button_1, 151, 20)
elements["C_AMS_Button_2"]            = default_button(_("AMS Button 2"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Button_2, 152, 20)
elements["C_AMS_Button_3"]            = default_button(_("AMS Button 3"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Button_3, 153, 20)
elements["C_AMS_Button_4"]            = default_button(_("AMS Button 4"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Button_4, 154, 20)
elements["C_AMS_Button_5"]            = default_button(_("AMS Button 5"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Button_5, 155, 20)
elements["C_AMS_Button_6"]            = default_button(_("AMS Button 6"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Button_6, 156, 20)
elements["C_AMS_Button_7"]            = default_button(_("AMS Button 7"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Button_7, 157, 20)
elements["C_AMS_ArmSafeSwitch"]       = default_2bis_position_tumb(_("AMS Arm"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Arm, 158, 20)
elements["C_AMS_RKT_RangeKnob"]       = default_axis_limited(_("AMS RKT Range"), devices.WEAPON_SYSTEM,
    device_commands.AMS_RKT_Range, 159, 0, 0.05, true, false, { 0.05, 0.95 })
elements["C_AMS_RKT_RPL-SGL_Switch"]  = default_2bis_position_tumb(_("AMS RKT RPL-SGL"), devices.WEAPON_SYSTEM,
    device_commands.AMS_RKT_RPL_SGL, 160, 20)
elements["C_AMS_RKT_SGL-PAIR_Switch"] = default_2bis_position_tumb(_("AMS RKT SGL-PAIR"), devices.WEAPON_SYSTEM,
    device_commands.AMS_RKT_SGL_PAIR, 161, 20)

elements["C_AMS_RKT_Preset_Switch"]   = multiposition_switch(_("AMS RKT Preset"), devices.WEAPON_SYSTEM,
    device_commands.AMS_RKT_Preset, 162, 3, 0.5, false, 0.0, 100, false)
elements["C_AMS_RKT_LR_Switch"]       = multiposition_switch(_("AMS RKT LR"), devices.WEAPON_SYSTEM,
    device_commands.AMS_RKT_LR, 163, 3, 0.5, false, 0.0, 100, false)

elements["C_AMS_Cover_Jettison"]      = default_red_cover(_("AMS Jett. Cover"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Jettison_Cover, 164, 20)
elements["C_AMS_Jetison_Switch"]      = default_2bis_position_tumb(_("AMS Jettison"), devices.WEAPON_SYSTEM,
    device_commands.AMS_Jettison_Switch, 165, 20)


-- Clock ---------------------------------------------------------------------------
elements["C_Clock_DimKnob"]  = default_axis_limited(_("Clock, Brightness"), devices.DIGITAL_CLOCK,
    device_commands.clock_brightness, 75, 20)
elements["C_Clock_Button_1"] = default_button(_("Clock, SELECT"), devices.DIGITAL_CLOCK, device_commands.clock_slct, 76,
    20)
elements["C_Clock_Button_2"] = default_button(_("Clock, CONTROL"), devices.DIGITAL_CLOCK, device_commands.clock_ctrl,
    77, 20)

-- ICS -----------------------------------------------------------------------------
elements["C_ics_MIC"]        = multiposition_switch(_("ICS MIC"), devices.INTERCOM_INTERFACE,
    device_commands.ICS_MIC, 670, 2, 1.0, false, 0.0, 100, false)

elements["C_ics_knob_1"]     = default_axis_limited(_("ICS Nav B"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_NavB,
    671, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_2"]     = default_axis_limited(_("ICS Nav A"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_NavA,
    672, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_3"]     = default_axis_limited(_("ICS Monitor 5"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_Mon5,
    673, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_4"]     = default_axis_limited(_("ICS Monitor 4"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_Mon4,
    674, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_5"]     = default_axis_limited(_("ICS Monitor 3"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_Mon3,
    675, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_6"]     = default_axis_limited(_("ICS Monitor 2"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_Mon2,
    676, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_7"]     = default_axis_limited(_("ICS Monitor 1"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_Mon1,
    677, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_8"]     = multiposition_switch(_("ICS Select"), devices.INTERCOM_INTERFACE,
    device_commands.ICS_Select, 678, 8, 1.0 / 7.0, false, 0.0, 100, false)
elements["C_ics_knob_9"]     = default_axis_limited(_("ICS Vox"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_Vox,
    679, 0, 0.05, true, false, { 0, 1 })
elements["C_ics_knob_10"]    = multiposition_switch(_("ICS Mode"), devices.INTERCOM_INTERFACE,
    device_commands.ICS_Mode, 680, 4, 1.0 / 3.0, false, 0.0, 100, false)
elements["C_ics_vol_knob"]     = default_axis_limited(_("ICS Volume"),
    devices.INTERCOM_INTERFACE, device_commands.ICS_Vol,
    681, 0, 0.05, true, false, { 0, 1 })

-- APR39 -----------------------------------------------------------------------------
elements["C_apr39_switch_1"] = default_2bis_position_tumb(_("PWR ON/OFF"), devices.RWR, device_commands.RWRPower, 381,
    20)
elements["C_apr39_switch_2"] = default_2bis_position_tumb(_("DSCRM ON/OFF"), devices.RWR, device_commands.RWR_DSCRM,
    382, 20)
elements["C_apr39_knob"]     = default_axis_limited(_("AUDIO"), devices.RWR, device_commands.RWRLoudness, 383, 0, 0.05,
    true, false, { 0, 1 })


-- TNL3100 ------------------------------------------------------------------------
elements["C_GPS_Loran_knob_PWR"] = default_axis_limited(_("TNL3100 Power")      ,devices.NAVIGATION, device_commands.TNL3100_PWR, 130, 0, 0.1, false, false, { 0.0, 1.0 })
elements["C_GPS_Loran_button_1"] = default_button(_("TNL3100 Nav")              ,devices.NAVIGATION, device_commands.TNL3100_NAV,     131, 20)
elements["C_GPS_Loran_button_2"] = default_button(_("TNL3100 WPT")              ,devices.NAVIGATION, device_commands.TNL3100_WPT,     132, 20)
elements["C_GPS_Loran_button_3"] = default_button(_("TNL3100 APT/VOR")          ,devices.NAVIGATION, device_commands.TNL3100_APT_VOR, 133, 20)
elements["C_GPS_Loran_button_4"] = default_button(_("TNL3100 D")                ,devices.NAVIGATION, device_commands.TNL3100_D,       134, 20)
elements["C_GPS_Loran_button_5"] = default_button(_("TNL3100 FPL")              ,devices.NAVIGATION, device_commands.TNL3100_FPL,     135, 20)
elements["C_GPS_Loran_button_6"] = default_button(_("TNL3100 CALC")             ,devices.NAVIGATION, device_commands.TNL3100_CALC,    136, 20)
elements["C_GPS_Loran_button_7"] = default_button(_("TNL3100 AUX")              ,devices.NAVIGATION, device_commands.TNL3100_AUX,     137, 20)
elements["C_GPS_Loran_button_8"] = default_button(_("TNL3100 MSG")              ,devices.NAVIGATION, device_commands.TNL3100_MSG,     138, 20)
elements["C_GPS_Loran_button_9"] = default_button(_("TNL3100 ENT")              ,devices.NAVIGATION, device_commands.TNL3100_ENT,     139, 20)

elements["C_GPS_Loran_knob_1"] = default_axis(_("TNL3100 Outer Knob")           ,devices.NAVIGATION, device_commands.TNL3100_OUTER, 140, 0, 0.1, false, true, true)
elements["C_GPS_Loran_knob_2"] = default_axis(_("Inner Knob")                   ,devices.NAVIGATION, device_commands.TNL3100_INNER, 141, 0, 0.1, false, true, true)

-- Argus7000 -------------------------------------------------

elements["C_ArgusButton1"] = default_button(_("Argus7000 DEP"), devices.NAVIGATION, 
    device_commands.argus_dep,     110, 20)
elements["C_ArgusButton2"] = default_button(_("Argus7000 ENR"), devices.NAVIGATION, 
    device_commands.argus_enr,     111, 20)
elements["C_ArgusButton3"] = default_button(_("Argus7000 ARR"), devices.NAVIGATION, 
    device_commands.argus_arr,     112, 20)
elements["C_ArgusButton4"] = default_button(_("Argus7000 AUX"), devices.NAVIGATION, 
    device_commands.argus_aux,     113, 20)

elements["C_ArgusKnob"]   = default_button_axis_limited(_("Argus7000 Power/Brightness"), devices.NAVIGATION,
    device_commands.argus_power,device_commands.argus_dim,115,114, 20)  

elements["C_WARNING_LIGHT_TEST"]            = default_button(_("Warning Light Tests"), devices.ELECTRIC_SYSTEM,
    device_commands.warning_lights_test, 235, 20)

elements["C_G1"]            = default_button(_("Drop Smoke Grenade"), devices.WEAPON_SYSTEM,
    device_commands.drop_g1, 1000, 20)
elements["C_G2"]            = default_button(_("Drop Smoke Grenade"), devices.WEAPON_SYSTEM,
    device_commands.drop_g2, 1000, 20)
elements["C_G3"]            = default_button(_("Drop Smoke Grenade"), devices.WEAPON_SYSTEM,
    device_commands.drop_g3, 1000, 20)
elements["C_G4"]            = default_button(_("Drop Smoke Grenade"), devices.WEAPON_SYSTEM,
    device_commands.drop_g4, 1000, 20)
