dofile(LockOn_Options.script_path.."TNL3100/TNL3100_typedefs.lua")
local TNL3100_WPT = {}
TNL3100_WPT.__index = TNL3100_WPT

function TNL3100_WPT.new()
    return setmetatable({

        waypoint_selection = 1,
        waypoint_type_selection = WPT_TYPES.airport,
        mode = WPT_MODE.selection,
        user_menu_selection = WPT_USERMENU_SEL.edit,
        create_menu_selection = WPT_CREATEMENU_SEL.ownpos,
        edit_selection =1,
        flash_timer = 0,
        timer = 0

    }, TNL3100_WPT)
end

function TNL3100_WPT:editing()
    return self.mode == WPT_MODE.edit or self.mode == WPT_MODE.create_edit 
end

function TNL3100_WPT:draw(state)
    if self.mode == WPT_MODE.selection then
        if self.waypoint_type_selection ==WPT_TYPES.airport then 
            ap,_ = state.airports:get()
            draw_airport_waypoint(ap, self.timer)
        elseif self.waypoint_type_selection ==WPT_TYPES.user then
            wp ,_ = state.user_waypoints:get()
            draw_user_waypoint(wp, self.timer,1,true)
        end
    elseif self:editing() then 
        draw_user_waypoint(state.temp_wp, self.timer, self.edit_selection,self.flash_timer>0.25)
    elseif self.mode == WPT_MODE.user_menu then 
        print_wpt_user_menu(self.user_menu_selection)
    elseif self.mode == WPT_MODE.create_menu then
        print_wpt_create_menu(self.create_menu_selection)
    end
end

function TNL3100_WPT:inc_wpt_create_menu()
    if self.create_menu_selection == WPT_CREATEMENU_SEL.ownpos then 
        self.create_menu_selection = WPT_CREATEMENU_SEL.latlon
    elseif self.create_menu_selection == WPT_CREATEMENU_SEL.latlon then 
        self.create_menu_selection = WPT_CREATEMENU_SEL.wp_bear_dist
    elseif self.create_menu_selection == WPT_CREATEMENU_SEL.wp_bear_dist then 
        self.create_menu_selection = WPT_CREATEMENU_SEL.ownpos
    end
end

function TNL3100_WPT:dec_wpt_create_menu()
    if self.create_menu_selection == WPT_CREATEMENU_SEL.ownpos then 
        self.create_menu_selection = WPT_CREATEMENU_SEL.wp_bear_dist
    elseif self.create_menu_selection == WPT_CREATEMENU_SEL.latlon then 
        self.create_menu_selection = WPT_CREATEMENU_SEL.ownpos
    elseif self.create_menu_selection == WPT_CREATEMENU_SEL.wp_bear_dist then 
        self.create_menu_selection = WPT_CREATEMENU_SEL.latlon
    end
end

function TNL3100_WPT:update(timestep)
    self.flash_timer = self.flash_timer +timestep
    if self.flash_timer >0.5 then self.flash_timer=0.0 end
    self.timer=self.timer+timestep
end

function TNL3100_WPT:Setcommand(command, value, state)
    
    if command == device_commands.TNL3100_OUTER then 
        if value > 0 then

            if self.waypoint_type_selection == WPT_TYPES.user and self.mode == WPT_MODE.selection then 
                self.mode = WPT_MODE.user_menu
                self.user_menu_selection = WPT_USERMENU_SEL.edit
            elseif self.mode == WPT_MODE.user_menu then
                if self.user_menu_selection == WPT_USERMENU_SEL.edit then 
                    self.user_menu_selection = WPT_USERMENU_SEL.create
                elseif self.user_menu_selection == WPT_USERMENU_SEL.create then 
                    self.user_menu_selection = WPT_USERMENU_SEL.delete
                elseif self.user_menu_selection == WPT_USERMENU_SEL.delete then 
                    self.mode = WPT_MODE.selection
                end
            elseif self.mode == WPT_MODE.create_menu then 
                self:inc_wpt_create_menu()
            elseif self:editing() then 
                self.edit_selection = self.edit_selection + 1
                if self.edit_selection > 18 then 
                    self.edit_selection = 1
                end
            end
        else
            if self.waypoint_type_selection == WPT_TYPES.user and self.mode == WPT_MODE.selection then
                print_message_to_user(self.user_menu_selection)
                self.mode = WPT_MODE.user_menu
                self.user_menu_selection = WPT_USERMENU_SEL.delete
            elseif self.mode == WPT_MODE.user_menu then
                if self.user_menu_selection == WPT_USERMENU_SEL.edit then 
                    self.mode = WPT_MODE.selection
                elseif self.user_menu_selection == WPT_USERMENU_SEL.create then 
                    self.user_menu_selection = WPT_USERMENU_SEL.edit
                elseif self.user_menu_selection == WPT_USERMENU_SEL.delete then 
                    self.user_menu_selection = WPT_USERMENU_SEL.create
                end
            elseif self.mode == WPT_MODE.create_menu then 
                self:dec_wpt_create_menu()
            elseif self:editing() then 
                self.edit_selection = self.edit_selection - 1
                if self.edit_selection < 1 then 
                    self.edit_selection = 18
                end
            end
        end
    elseif command == device_commands.TNL3100_INNER then -- handle swapping of status modes
        if self.mode == WPT_MODE.selection then
            if value > 0 then
                state:next_wp(self.waypoint_type_selection)
            elseif value < 0 then
                state:previous_wp(self.waypoint_type_selection)
            end
        elseif self.mode == WPT_MODE.user_menu then 
            self.mode = WPT_MODE.selection
        elseif self:editing() then 
            local sel = self.edit_selection
            local delta = -1
            if value > 0 then delta =1 end
            if sel <=4 then 
                state.temp_wp.name=change_char_at(state.temp_wp.name,sel,delta)
            elseif sel >4 and sel <=11 then
                local new_val = change_latlon(state.temp_wp.point.lat,sel-4,delta)
                state.temp_wp.point.lat = new_val
            elseif sel >11 then
                local new_val = change_latlon(state.temp_wp.point.lon,sel-11,delta)
                state.temp_wp.point.lon = new_val
            end
        end
        
    elseif command == device_commands.TNL3100_ENT and value <0.5 then
        if self.mode == WPT_MODE.user_menu then 
            if self.user_menu_selection == WPT_USERMENU_SEL.delete then
                state:delete_wp()
                self.mode = WPT_MODE.selection
            elseif self.user_menu_selection == WPT_USERMENU_SEL.create then
                self.mode = WPT_MODE.create_menu
                self.create_menu_selection = WPT_CREATEMENU_SEL.ownpos
            elseif self.user_menu_selection == WPT_USERMENU_SEL.edit then
                print("Edit")
                self.mode = WPT_MODE.edit
                self.edit_selection = 1
                local wp = state.user_waypoints:get()
                state.temp_wp.name = wp.name
                state.temp_wp.point = {x = wp.point.x,y=wp.point.y,lon = wp.point.lon,lat = wp.point.lat}
                state.temp_wp.alt = wp.alt
            end
        elseif self.mode == WPT_MODE.edit then
            state:updateWPFromLatLon(state.temp_wp)
            state.user_waypoints:set(state.temp_wp)
            self.mode = WPT_MODE.selection 
        elseif self.mode == WPT_MODE.create_edit then
            state:updateWPFromLatLon(state.temp_wp)
            state:add_user_waypoint(state.temp_wp)
            self.mode = WPT_MODE.selection 
        elseif self.mode == WPT_MODE.create_menu then
            if self.create_menu_selection == WPT_CREATEMENU_SEL.ownpos or
                self.create_menu_selection == WPT_CREATEMENU_SEL.latlon then 
                state.temp_wp = state:createWPHere()
                self.mode = WPT_MODE.create_edit
            end
        elseif self.mode == WPT_MODE.selection then
            state.entered_a_wp = true
            local selection
            if self.waypoint_type_selection ==WPT_TYPES.airport then 
                _,selection = state.airports:get()
            else
                _,selection = state.user_waypoints:get()
            end
            state.entered_wp = selection
        end
    end
end


return TNL3100_WPT
