dofile(LockOn_Options.script_path.."command_defs.lua")

local fuel_valve_open = false


local dev = GetSelf()
local sensor_data = get_base_data()
local update_time_step = 0.1  
make_default_activity(update_time_step)

local LOW_FUEL = get_param_handle("LOW_FUEL")
local EXT_FUEL = get_param_handle("EXT_FUEL")
local INT_FUEL = get_param_handle("INT_FUEL")
local IND_FUEL = get_param_handle("IND_FUEL")
local dc_elec = get_param_handle("DC_POWER_AVAIL")
local SHOW_AUX_FQ = get_param_handle("SHOW_AUX_FQ")
local FQI_STR = get_param_handle("FQI_STR")

local view_mode = 0 --0 int, 1 ext

local WARNING_FUEL_LOW  = get_param_handle("Warning_Fuel_Low")
local WARNING_TEST_PRESSED  = get_param_handle("WARNING_TEST_PRESSED")

local t_fqi = 5.2

local fuel_transfer =false
local dc_ok = false

dev:listen_command(EFM_commands.fuelsystem_fuel_valve)
dev:listen_command(Keys.fuel_valve_on)
dev:listen_command(Keys.fuel_valve_off)
dev:listen_command(Keys.fuel_valve_toggle)
dev:listen_command(Keys.fuel_transfer_on)
dev:listen_command(Keys.fuel_transfer_off)
dev:listen_command(Keys.fuel_transfer_toggle)
dev:listen_command(Keys.fuel_aux)

function post_initialize()
	local birth = LockOn_Options.init_conditions.birth_place
	if birth=="GROUND_HOT" or birth=="AIR_HOT" then 			  
		dev:performClickableAction(EFM_commands.fuelsystem_fuel_valve,0.0,true)
        dispatch_action(nil, EFM_commands.fuelsystem_fuel_valve,0.0)
        fuel_valve_open = true
    elseif birth=="GROUND_COLD" then
		dev:performClickableAction(EFM_commands.fuelsystem_fuel_valve,1.0,true)
        dispatch_action(nil, EFM_commands.fuelsystem_fuel_valve,1.0)
		fuel_valve_open = false
    end
    dev:performClickableAction(device_commands.fuel_transfer,0.5,true)
    dispatch_action(nil, EFM_commands.fuel_transfer,0.0)
end

function SetCommand(command,value)
    if command == EFM_commands.fuelsystem_fuel_valve then 
        if value < 0.5 then 
            fuel_valve_open =true
        else
            fuel_valve_open =false
        end
    end
    if command == Keys.fuel_valve_on then 
	    dev:performClickableAction(EFM_commands.fuelsystem_fuel_valve,0.0,true)
        dispatch_action(nil, EFM_commands.fuelsystem_fuel_valve,0.0)
	end
	if command == Keys.fuel_valve_off then 
        dev:performClickableAction(EFM_commands.fuelsystem_fuel_valve,1.0,true)
        dispatch_action(nil, EFM_commands.fuelsystem_fuel_valve,1.0)
	end
	if command == Keys.fuel_valve_toggle then
        if fuel_valve_open then 
            dev:performClickableAction(EFM_commands.fuelsystem_fuel_valve,1.0,true)
            dispatch_action(nil, EFM_commands.fuelsystem_fuel_valve,1.0)
            fuel_valve_open =true
        else
            dev:performClickableAction(EFM_commands.fuelsystem_fuel_valve,0.0,true)
            dispatch_action(nil, EFM_commands.fuelsystem_fuel_valve,0.0)
        end
	end
   
    if command == Keys.fuel_transfer_on then 
        dev:performClickableAction(device_commands.fuel_transfer,1.0,true)
    end
    if command == Keys.fuel_transfer_off then 
        dev:performClickableAction(device_commands.fuel_transfer,0.5,true)
    end
    if command == Keys.fuel_transfer_toggle then 
        if fuel_transfer then 
            dev:performClickableAction(device_commands.fuel_transfer,0.5,true)
        else
            dev:performClickableAction(device_commands.fuel_transfer,1.0,true)
        end
    end
    if command == device_commands.fuel_transfer then 
        if value > 0.6 or value < 0.4 then 
            dispatch_action(nil, EFM_commands.fuel_transfer,1.0)
            fuel_transfer = true
        else
            dispatch_action(nil, EFM_commands.fuel_transfer,0.0)
            fuel_transfer = false
        end
    end

    if command == Keys.fuel_aux then
        dev:performClickableAction(device_commands.fqi_aux,1.0,true)
    end
    if command == device_commands.fqi_aux then 
        t_fqi=0.0
    end
	
end

function update()
    if t_fqi <=5 then 
        t_fqi =t_fqi+update_time_step
        view_mode = 1
    else
        view_mode = 0
    end
    dc_ok = dc_elec:get() > 0.5
    if dc_ok then
        if LOW_FUEL:get() >0.5 or WARNING_TEST_PRESSED:get()>0.5 then 
            WARNING_FUEL_LOW:set(1.0)
        else
            WARNING_FUEL_LOW:set(0.0)
        end
    else
        WARNING_FUEL_LOW:set(0.0)
    end
    

    if view_mode == 0 then 
        IND_FUEL:set(INT_FUEL:get())
        SHOW_AUX_FQ:set(0)
    else
        IND_FUEL:set(EXT_FUEL:get())
        SHOW_AUX_FQ:set(1)
    end

end

need_to_be_closed = false 