dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.common_script_path .. "devices_defs.lua")
dofile(LockOn_Options.common_script_path .. "../../../Database/wsTypes.lua")

local dev          = GetSelf()

local WEAPONS_CURRENT     = get_param_handle("WEAPONS_CURRENT")

local L_gun_pwr           = false
local R_gun_pwr           = false
local L_gun_arm           = false
local R_gun_arm           = false
local L_gun_fire_to_clr   = false
local R_gun_fire_to_clr   = false

local ams_power           = false
local ams_safe            = true
local rockets_side        = 1 --0: left, 1: both, 2: right
local rockets_pairs = false  --single/pairs
local rockets_ripple = false  --single/ripple
local current_side = 0  --0:left , 1:right

local barrel_rate = 4000.0/60.0/6
local barrel_speed_l = 0.0
local barrel_speed_r = 0.0
local barrel_pos_l =0.0
local barrel_pos_r =0.0

local gun_trigger = false
local rocket_trigger = false
local WeaponSystem = GetSelf()
local update_rate = 0.01


local L_OUT = 9
local L_IN = L_OUT + 1
local R_IN = L_OUT + 2
local R_OUT = L_OUT + 3



local FL_GUNNER = 9
local FR_GUNNER = 10
local RL_GUNNER = 11
local RR_GUNNER = 12

local jettison_cover = true

local flares_equipped = 0

local flares_armed = false
local flares_pressed = false
local flare_delay = 0.5
local flare_time = 1.0

local g_color = {
	[1]=get_param_handle("G4_color"),
	[2]=get_param_handle("G3_color"),
	[3]=get_param_handle("G2_color"),
	[4]=get_param_handle("G1_color")
}

local g_count = {
	[1]=get_param_handle("G4_count"),
	[2]=get_param_handle("G3_count"),
	[3]=get_param_handle("G2_count"),
	[4]=get_param_handle("G1_count"),
}

local color_arg = {}
color_arg['{AH6_SMOKE_RED}'] = 0.0
color_arg['{AH6_SMOKE_BLUE}'] = 0.25
color_arg['{AH6_SMOKE_GREEN}'] = 0.5
color_arg['{AH6_SMOKE_YELLOW}'] = 0.75

local dc_elec = get_param_handle("DC_POWER_AVAIL")

make_default_activity(update_rate)

local shoot_doorgun1 = get_param_handle("SHOOT_DOOR_GUN1")
local shoot_doorgun2 = get_param_handle("SHOOT_DOOR_GUN2")
local shoot_doorgun3 = get_param_handle("SHOOT_DOOR_GUN3")
local shoot_doorgun4 = get_param_handle("SHOOT_DOOR_GUN4")

local AIM_MARK_VISIBLE = get_param_handle("AIM_MARK_VISIBLE")
local AIM_OFFSET = get_param_handle("AIM_OFFSET")
local DELTA_F = get_param_handle("DELTA_F")

local use_aiming_mark = get_plugin_option_value("AH-6J", "AH6AimingMark", "local")
local aiming_mark_offset = get_plugin_option_value("AH-6J", "AH6AimingMarkOffset", "local")
local aiming_mark_keyoffset = 0.0

WeaponSystem:listen_command(Keys.gunsight_up)
WeaponSystem:listen_command(Keys.gunsight_down)

WeaponSystem:listen_command(Keys.FireOn)
WeaponSystem:listen_command(Keys.FireOff)
WeaponSystem:listen_command(Keys.RocketFireOn)
WeaponSystem:listen_command(Keys.RocketFireOff)

WeaponSystem:listen_command(Keys.Master_arm_on)
WeaponSystem:listen_command(Keys.Master_arm_off)
WeaponSystem:listen_command(Keys.Master_arm_toggle)

WeaponSystem:listen_command(Keys.left_gun_pwr_on)
WeaponSystem:listen_command(Keys.left_gun_pwr_off)
WeaponSystem:listen_command(Keys.left_gun_pwr_toggle)
WeaponSystem:listen_command(Keys.right_gun_pwr_on)
WeaponSystem:listen_command(Keys.right_gun_pwr_off)
WeaponSystem:listen_command(Keys.right_gun_pwr_toggle)
WeaponSystem:listen_command(Keys.left_gun_arm_on)
WeaponSystem:listen_command(Keys.left_gun_arm_off)
WeaponSystem:listen_command(Keys.left_gun_arm_toggle)
WeaponSystem:listen_command(Keys.right_gun_arm_on)
WeaponSystem:listen_command(Keys.right_gun_arm_off)
WeaponSystem:listen_command(Keys.right_gun_arm_toggle)
WeaponSystem:listen_command(Keys.left_gun_ftclr_norm)
WeaponSystem:listen_command(Keys.left_gun_ftclr_on)
WeaponSystem:listen_command(Keys.left_gun_ftclr_toggle)
WeaponSystem:listen_command(Keys.right_gun_ftclr_norm)
WeaponSystem:listen_command(Keys.right_gun_ftclr_on)
WeaponSystem:listen_command(Keys.right_gun_ftclr_toggle)
WeaponSystem:listen_command(Keys.ams_power_on)
WeaponSystem:listen_command(Keys.ams_power_off)
WeaponSystem:listen_command(Keys.ams_power_toggle)
WeaponSystem:listen_command(Keys.ams_rockets_ripple_on)
WeaponSystem:listen_command(Keys.ams_rockets_ripple_off)
WeaponSystem:listen_command(Keys.ams_rockets_ripple_toggle)
WeaponSystem:listen_command(Keys.ams_rockets_single)
WeaponSystem:listen_command(Keys.ams_rockets_pair)
WeaponSystem:listen_command(Keys.ams_rockets_pair_toggle)
WeaponSystem:listen_command(Keys.ams_rockets_side_left)
WeaponSystem:listen_command(Keys.ams_rockets_side_right)
WeaponSystem:listen_command(Keys.ams_rockets_side_both)
WeaponSystem:listen_command(Keys.ams_rockets_side_toggle)


WeaponSystem:listen_command(Keys.jettison_cover)
WeaponSystem:listen_command(Keys.jettison)

WeaponSystem:listen_command(Keys.DropFlare)
WeaponSystem:listen_command(Keys.FlareArmSafe)
WeaponSystem:listen_command(Keys.FlareArm)
WeaponSystem:listen_command(Keys.FlareSafe)

WeaponSystem:listen_command(Keys.drop_g1)
WeaponSystem:listen_command(Keys.drop_g2)
WeaponSystem:listen_command(Keys.drop_g3)
WeaponSystem:listen_command(Keys.drop_g4)

WeaponSystem:listen_command(Keys.drop_gunner)

WeaponSystem:listen_command(device_commands.DropFlare)
WeaponSystem:listen_command(device_commands.FlareArmSafe)
WeaponSystem:listen_command(device_commands.AMS_RKT_SGL_PAIR)

local sounds = {}
local dc_ok
local current = 0.0


function play_sound(name)
	for k, v in pairs(sounds) do
		if k == name then
			sounds[k]:play_once()
		else
			sounds[k]:stop()
		end
	end
end

local function launch_grenade(station)
	local info = WeaponSystem:get_station_info(station)
	local n = info.count
	if n>1 then 
		WeaponSystem:launch_station(station)
	end
	--WeaponSystem:launch_station(station)
end

local function update_grenades()
	for i = 1, 4 do
		local info = WeaponSystem:get_station_info(i-1+4)
		local n = info.count
		if n> 1 then 
			set_aircraft_draw_argument_value(130+i-1, 1)
			g_count[i]:set(1)
		else
			set_aircraft_draw_argument_value(130+i-1, 0)
			g_count[i]:set(0)
		end

		--print_message_to_user(n)
		local value = color_arg[info.CLSID]
		--print_message_to_user(value)
		if value == nil then
			value = 0.0
		end
		g_color[i]:set(value)
	end
end

local function update_gunner()
	local gunner_on_board = false
	local gunnerLInfo = WeaponSystem:get_station_info(FL_GUNNER-1)
	if gunnerLInfo.weapon.level2 == wsType_Shell then
		if shoot_doorgun1:get() ==1 then
			WeaponSystem:launch_station(FL_GUNNER-1)
		end
		gunner_on_board = true
	end
	local gunnerRInfo = WeaponSystem:get_station_info(FR_GUNNER-1)
	if gunnerRInfo.weapon.level2 == wsType_Shell then
		if shoot_doorgun2:get() ==1 then 
			WeaponSystem:launch_station(FR_GUNNER-1)
		end
		gunner_on_board = true
	end

	local gunnerLInfo = WeaponSystem:get_station_info(RL_GUNNER-1)
	if gunnerLInfo.weapon.level2 == wsType_Shell then
		if shoot_doorgun3:get() ==1 then
			WeaponSystem:launch_station(RL_GUNNER-1)
		end
		gunner_on_board = true
	end
	local gunnerRInfo = WeaponSystem:get_station_info(RR_GUNNER-1)
	if gunnerRInfo.weapon.level2 == wsType_Shell then
		if shoot_doorgun4:get() ==1 then 
			WeaponSystem:launch_station(RR_GUNNER-1)
		end
		gunner_on_board = true
	end

	if gunner_on_board then 
		set_aircraft_draw_argument_value(605, 0.0)
	else
		set_aircraft_draw_argument_value(605, 1.0)
	end


end

local function update_gun()
	local L_gunInfo = WeaponSystem:get_station_info(L_IN - 1)
	local R_gunInfo = WeaponSystem:get_station_info(R_IN - 1)

	local L_gunOutInfo = WeaponSystem:get_station_info(L_OUT - 1)
	local R_gunOutInfo = WeaponSystem:get_station_info(R_OUT - 1)

	local left_shootable = (rockets_side == 0 or rockets_side ==1)
	local right_shootable = (rockets_side == 1 or rockets_side ==2)
	if L_gunOutInfo.weapon.level2 == wsType_Shell then -- prevent shooting if left gun isn't mounted
		if gun_trigger and dc_ok and ams_power and not ams_safe and L_gun_pwr and L_gun_arm and left_shootable then
			current = current + 1
			WeaponSystem:launch_station(L_OUT - 1)
		end
	end

	if R_gunOutInfo.weapon.level2 == wsType_Shell then -- prevent shooting if left gun isn't mounted
		if gun_trigger and dc_ok and ams_power and not ams_safe and R_gun_pwr and R_gun_arm and right_shootable then
			current = current + 1
			WeaponSystem:launch_station(R_OUT - 1)
		end
	end


	if L_gunInfo.weapon.level2 == wsType_Shell then -- prevent shooting if left gun isn't mounted
		
		if gun_trigger and dc_ok and ams_power and not ams_safe and L_gun_pwr and L_gun_arm and left_shootable then
			barrel_speed_l = barrel_speed_l + 0.025
			if barrel_speed_l >= 1.0 then
				barrel_speed_l = 1.0
				if not L_gun_fire_to_clr then
					current = current + 1
					WeaponSystem:launch_station(L_IN - 1)
				else
					--print_message_to_user('LEFT CLEAR : ' .. tostring(L_gun_clr), 0.2)
				end
			end
		else
			barrel_speed_l = barrel_speed_l - 0.02
			if barrel_speed_l < 0.0 then
				barrel_speed_l = 0.0
			end
		end
		barrel_pos_l = barrel_pos_l + barrel_speed_l * barrel_rate * update_rate
		if barrel_pos_l > 1 then
			barrel_pos_l = barrel_pos_l - 1
		end
		set_aircraft_draw_argument_value(510,barrel_pos_l) --argument anpassen
	end

	if R_gunInfo.weapon.level2 == wsType_Shell then -- prevent shooting if left gun isn't mounted
		if gun_trigger and dc_ok and ams_power and not ams_safe and R_gun_pwr and R_gun_arm and right_shootable then
			barrel_speed_r = barrel_speed_r + 0.025
			if barrel_speed_r >= 1.0 then
				barrel_speed_r = 1.0
				if not R_gun_fire_to_clr then
					current = current + 1
					WeaponSystem:launch_station(R_IN - 1)
				else
					--print_message_to_user('LEFT CLEAR : ' .. tostring(L_gun_clr), 0.2)
				end
			end
		else
			barrel_speed_r = barrel_speed_r - 0.02
			if barrel_speed_r < 0.0 then
				barrel_speed_r = 0.0
			end
		end
		barrel_pos_r = barrel_pos_r + barrel_speed_r * barrel_rate * update_rate
		if barrel_pos_r > 1 then
			barrel_pos_r = barrel_pos_r - 1
		end
		set_aircraft_draw_argument_value(511,barrel_pos_r) --argument anpassen
	end
end

local interval = 0.15
local timer = interval
local salve = 7
local rockets_left = 1



local function rockets_L()
	local pInfo1 = WeaponSystem:get_station_info(L_OUT - 1)
	local pInfo2 = WeaponSystem:get_station_info(L_IN - 1)
	return pInfo1.weapon.level2 == wsType_NURS or pInfo2.weapon.level2 == wsType_NURS or
		   pInfo1.weapon.level2 == wsType_Missile or pInfo2.weapon.level2 == wsType_Missile
end

local function rockets_R()
	local pInfo1 = WeaponSystem:get_station_info(R_OUT - 1)
	local pInfo2 = WeaponSystem:get_station_info(R_IN - 1)
	return pInfo1.weapon.level2 == wsType_NURS or pInfo2.weapon.level2 == wsType_NURS or 
		   pInfo1.weapon.level2 == wsType_Missile or pInfo2.weapon.level2 == wsType_Missile
end

local function update_rockets()

	local pInfo1 = WeaponSystem:get_station_info(L_OUT - 1)
	local pInfo2 = WeaponSystem:get_station_info(L_IN - 1)
	local pInfo3 = WeaponSystem:get_station_info(R_IN - 1)
	local pInfo4 = WeaponSystem:get_station_info(R_OUT - 1)
	timer = timer - update_rate
	local r_l = rockets_L()
	local r_r = rockets_R()
	if timer < -1.0 then timer = -1.0 end

	if dc_ok and ams_power and not ams_safe then
		local shoot_left = false
		local shoot_right = false
		if timer < 0 then
			if rocket_trigger == true and rockets_left > 0 then
				timer = interval
				if rockets_pairs then
					if rockets_side == 0 then 
						shoot_left = true
					elseif rockets_side == 1 then 
						shoot_left = true
						shoot_right = true
					else
						shoot_right = true
					end
				else
					-- does the actual side makes sense?
					if current_side == 0 and not r_l then
						current_side = 1
					end
					if current_side == 1 and not r_r then
						current_side = 0
					end

					if rockets_side == 0 then
						shoot_left = true
						if r_r then 
							current_side = 1
						end
					elseif rockets_side == 1 then
						if current_side == 0 then
							shoot_left = true
							if r_r then 
								current_side = 1
							end
						else
							shoot_right = true
							if r_l then
								current_side = 0
							end
						end
					else
						shoot_right = true
						if r_l then 
							current_side = 0
						end
					end
				end
				rockets_left = rockets_left - 1
			else
				rocket_trigger = false
				if rockets_ripple then 
					rockets_left = salve
				else
					rockets_left = 1
				end
			end
		end

		if pInfo1.weapon.level2 == wsType_NURS or pInfo1.weapon.level2 == wsType_Missile then
			if shoot_left == true then
				WeaponSystem:launch_station(L_OUT - 1)
			end
		end
		if pInfo2.weapon.level2 == wsType_NURS or pInfo2.weapon.level2 == wsType_Missile then
			if shoot_left == true then
				WeaponSystem:launch_station(L_IN - 1)
			end
		end
		if pInfo3.weapon.level2 == wsType_NURS or pInfo3.weapon.level2 == wsType_Missile then
			if shoot_right == true then
				WeaponSystem:launch_station(R_IN - 1)
			end
		end
		if pInfo4.weapon.level2 == wsType_NURS or pInfo4.weapon.level2 == wsType_Missile then
			if shoot_right == true then
				WeaponSystem:launch_station(R_OUT - 1)   
			end
		end

	end
end

local function update_flares()
	flares_equipped = get_aircraft_property("FlaresEquipped")
	if flares_equipped > 0.5 then
		get_param_handle("FLARES_EQUIPPED"):set(1.0)
		local n_f = WeaponSystem:get_flare_count()
		local n_c = WeaponSystem:get_chaff_count()
		local n = n_f
		if n_c > n_f then n = n_c end
		local arg_val = 1.0 - (30 - n) / 30.0 * 0.9
		set_aircraft_draw_argument_value(127, arg_val)

		if flares_armed then
			if flares_pressed then
				if flare_time >= flare_delay then
					if dc_ok then
						if n_f > 0 then
							dev:drop_flare(1, 0)
						end
						if n_c > 0 then
							dev:drop_chaff(1, 0)
						end
						flare_time = 0.0
					end
				else
					flare_time = flare_time + update_rate
				end
			else
				flare_time = 1.0
			end
		else
			flare_time = 1.0
		end
	else
		get_param_handle("FLARES_EQUIPPED"):set(0.0)
		set_aircraft_draw_argument_value(127, 0.0)
	end
end


function post_initialize()
	sndhost = create_sound_host("COCKPIT_ARMS", "HEADPHONES", -1.0, 1.0, 0)


	dev:performClickableAction(device_commands.AMS_Arm, 0.0, true)

	dev:performClickableAction(device_commands.RIGHT_gun_clear, 1.0, true)
	dev:performClickableAction(device_commands.LEFT_gun_clear, 1.0, true)
	dev:performClickableAction(device_commands.AMS_RKT_LR, 0.5, true)
	dev:performClickableAction(device_commands.AMS_RKT_RPL_SGL, 0.0, true)
	dev:performClickableAction(device_commands.AMS_RKT_SGL_PAIR, 1.0, true)

	--dev:performClickableAction(device_commands.AMS_RKT_Range, 0.342, true)	-- start position SQ
end

local function update_delta_f()
	local delta_f =0
	if (get_aircraft_type() == "AH-6J") then 
		local pInfo1 = WeaponSystem:get_station_info(L_OUT - 1)
		local pInfo2 = WeaponSystem:get_station_info(L_IN - 1)
		if pInfo1.CLSID ~= "<CLEAN>" then delta_f = delta_f+0.033 end
		if pInfo2.CLSID ~= "<CLEAN>" then delta_f = delta_f+0.033 end
	end
	local pDoor1 = WeaponSystem:get_station_info(0)
	local pDoor2 = WeaponSystem:get_station_info(1)
	
	if pDoor1.CLSID =="<CLEAN>" then delta_f = delta_f+0.033 end
	if pDoor2.CLSID =="<CLEAN>" then delta_f = delta_f+0.033 end

	DELTA_F:set(delta_f)
end

function update()
	current = 0
	dc_ok = dc_elec:get() > 0.5
	
	-- both	
	update_grenades()
	update_delta_f()
	update_flares()
	
	local weaponed= false
	
	if (get_aircraft_type() == "AH-6J") then
		update_gun()
		update_rockets()
		local pInfo1 = WeaponSystem:get_station_info(L_OUT - 1)
		local pInfo2 = WeaponSystem:get_station_info(L_IN - 1)
		local pInfo3 = WeaponSystem:get_station_info(R_IN - 1)
		local pInfo4 = WeaponSystem:get_station_info(R_OUT - 1)
		local gunInfo = WeaponSystem:get_station_info(FL_GUNNER-1)
		if pInfo1.weapon.level2 == wsType_Shell  or pInfo1.weapon.level2 == wsType_NURS or 
			pInfo1.weapon.level2 == wsType_Missile then
			weaponed =true
		end
		if pInfo2.weapon.level2 == wsType_Shell  or pInfo2.weapon.level2 == wsType_NURS or 
			pInfo2.weapon.level2 == wsType_Missile then
			weaponed =true
		end
		if pInfo3.weapon.level2 == wsType_Shell  or pInfo3.weapon.level2 == wsType_NURS or 
			pInfo3.weapon.level2 == wsType_Missile then
			weaponed =true
		end
		if pInfo4.weapon.level2 == wsType_Shell  or pInfo4.weapon.level2 == wsType_NURS or 
			pInfo4.weapon.level2 == wsType_Missile then
			weaponed =true
		end
	else
		update_gunner()
	end

	
	
	if use_aiming_mark or weaponed then
		AIM_MARK_VISIBLE:set(1.0)
		local val =aiming_mark_offset/200.0+aiming_mark_keyoffset
		if val > 0.5 then val =0.5 end
		if val < -0.5 then val =-0.5 end
		AIM_OFFSET:set(val)
	else
		AIM_MARK_VISIBLE:set(0.0)
	end

	WEAPONS_CURRENT:set(current)
end

function SetCommand(command, value)
	if flares_equipped > 0.5 then
		if command == Keys.DropFlare or command == device_commands.DropFlare then
			if value > 0.5 then flares_pressed = true else flares_pressed = false end
		end

		if command == Keys.FlareArm then
			dev:performClickableAction(device_commands.FlareArmSafe, 1.0, true)
		end

		if command == Keys.FlareSafe then
			dev:performClickableAction(device_commands.FlareArmSafe, 0.0, true)
		end

		if command == Keys.FlareArmSafe then
			if flares_armed then
				dev:performClickableAction(device_commands.FlareArmSafe, 0.0, true)
			else
				dev:performClickableAction(device_commands.FlareArmSafe, 1.0, true)
			end
		end

		if command == device_commands.FlareArmSafe then
			flares_armed = value > 0.5
		end
	end

	if command == Keys.FireOn then
		gun_trigger = true
	end
	if command == Keys.FireOff then
		gun_trigger = false
	end

	if command == Keys.RocketFireOn then
		rocket_trigger = true
	end
	if command == Keys.RocketFireOff then
		rocket_trigger = false
	end


	if command == Keys.left_gun_pwr_on then 
		dev:performClickableAction(device_commands.LEFT_gun_pwr, 1.0, true)
	end
	if command == Keys.left_gun_pwr_off then 
		dev:performClickableAction(device_commands.LEFT_gun_pwr, 0.0, true)
	end
	if command == Keys.left_gun_pwr_toggle then
		if L_gun_pwr then 
			dev:performClickableAction(device_commands.LEFT_gun_pwr, 0.0, true)
		else
			dev:performClickableAction(device_commands.LEFT_gun_pwr, 1.0, true)
		end
	end
	if command == device_commands.LEFT_gun_pwr then
		L_gun_pwr = value > 0.5
	end

	if command == Keys.left_gun_arm_on then 
		dev:performClickableAction(device_commands.LEFT_gun_arm, 1.0, true)
	end
	if command == Keys.left_gun_arm_off then 
		dev:performClickableAction(device_commands.LEFT_gun_arm, 0.0, true)
	end
	if command == Keys.left_gun_arm_toggle then
		if L_gun_arm then 
			dev:performClickableAction(device_commands.LEFT_gun_arm, 0.0, true)
		else
			dev:performClickableAction(device_commands.LEFT_gun_arm, 1.0, true)
		end
	end
	if command == device_commands.LEFT_gun_arm then
		L_gun_arm = value > 0.5
	end

	if command == Keys.left_gun_ftclr_norm then 
		dev:performClickableAction(device_commands.LEFT_gun_clear, 1.0, true)
	end
	if command == Keys.left_gun_ftclr_on then 
		dev:performClickableAction(device_commands.LEFT_gun_clear, 0.0, true)
	end
	if command == Keys.left_gun_ftclr_toggle then
		if L_gun_fire_to_clr then 
			dev:performClickableAction(device_commands.LEFT_gun_clear, 1.0, true)
		else
			dev:performClickableAction(device_commands.LEFT_gun_clear, 0.0, true)
		end
	end
	if command == device_commands.LEFT_gun_clear then
		L_gun_fire_to_clr = value < 0.5
	end

	if command == Keys.right_gun_pwr_on then 
		dev:performClickableAction(device_commands.RIGHT_gun_pwr, 1.0, true)
	end
	if command == Keys.right_gun_pwr_off then 
		dev:performClickableAction(device_commands.RIGHT_gun_pwr, 0.0, true)
	end
	if command == Keys.right_gun_pwr_toggle then
		if R_gun_pwr then 
			dev:performClickableAction(device_commands.RIGHT_gun_pwr, 0.0, true)
		else
			dev:performClickableAction(device_commands.RIGHT_gun_pwr, 1.0, true)
		end
	end
	if command == device_commands.RIGHT_gun_pwr then
		R_gun_pwr = value > 0.5
	end

	if command == Keys.right_gun_arm_on then 
		dev:performClickableAction(device_commands.RIGHT_gun_arm, 1.0, true)
	end
	if command == Keys.right_gun_arm_off then 
		dev:performClickableAction(device_commands.RIGHT_gun_arm, 0.0, true)
	end
	if command == Keys.right_gun_arm_toggle then
		if R_gun_arm then 
			dev:performClickableAction(device_commands.RIGHT_gun_arm, 0.0, true)
		else
			dev:performClickableAction(device_commands.RIGHT_gun_arm, 1.0, true)
		end
	end
	if command == device_commands.RIGHT_gun_arm then
		R_gun_arm = value > 0.5
	end

	if command == Keys.right_gun_ftclr_norm then 
		dev:performClickableAction(device_commands.RIGHT_gun_clear, 1.0, true)
	end
	if command == Keys.right_gun_ftclr_on then 
		dev:performClickableAction(device_commands.RIGHT_gun_clear, 0.0, true)
	end
	if command == Keys.right_gun_ftclr_toggle then
		if R_gun_fire_to_clr then 
			dev:performClickableAction(device_commands.RIGHT_gun_clear, 1.0, true)
		else
			dev:performClickableAction(device_commands.RIGHT_gun_clear, 0.0, true)
		end
	end
	if command == device_commands.RIGHT_gun_clear then
		R_gun_fire_to_clr = value < 0.5
	end

	if command == Keys.Master_arm_on then
		dev:performClickableAction(device_commands.AMS_Arm, 1.0, true)
	end

	if command == Keys.Master_arm_off then
		dev:performClickableAction(device_commands.AMS_Arm, 0.0, true)
	end
	if command == Keys.Master_arm_toggle then
		if ams_safe then
			dev:performClickableAction(device_commands.AMS_Arm, 1.0, true)
		else
			dev:performClickableAction(device_commands.AMS_Arm, 0.0, true)
		end
	end
	if command == device_commands.AMS_Arm then
		ams_safe = value < 0.5
	end

	


	if command == Keys.drop_gunner then
		if (get_aircraft_type() == "MH-6J") then
			print_message_to_user("drop")
			WeaponSystem:emergency_jettison(9-1)
			WeaponSystem:emergency_jettison(10-1)
			WeaponSystem:emergency_jettison(11-1)
			WeaponSystem:emergency_jettison(12-1)
		end
	end


	if command == Keys.jettison then
		dev:performClickableAction(device_commands.AMS_Jettison_Switch, 1.0, true)
	end
	if command == device_commands.AMS_Jettison_Switch then
		if not jettison_cover and ams_power then
			if value > 0.5 then
				if (get_aircraft_type() == "AH-6J") then 
					WeaponSystem:emergency_jettison(L_OUT-1)
					WeaponSystem:emergency_jettison(R_OUT-1)
				end
			end
		end
	end

	if command == Keys.jettison_cover then
		if jettison_cover then
			dev:performClickableAction(device_commands.AMS_Jettison_Cover, 1.0, true)
		else
			dev:performClickableAction(device_commands.AMS_Jettison_Cover, 0.0, true)
		end
	end
	if command == device_commands.AMS_Jettison_Cover then
		if value > 0.5 then
			jettison_cover = false
		else
			jettison_cover = true
		end
	end


	if command == Keys.ams_power_on then
		dev:performClickableAction(device_commands.AMS_PWR, 1.0, true)
	end
	if command == Keys.ams_power_off then
		dev:performClickableAction(device_commands.AMS_PWR, 0.0, true)
	end
	if command == Keys.ams_power_toggle then
		if ams_power then
			dev:performClickableAction(device_commands.AMS_PWR, 0.0, true)
		else
			dev:performClickableAction(device_commands.AMS_PWR, 1.0, true)
		end
	end
	if command == device_commands.AMS_PWR then
		ams_power = value > 0.5
	end

	if command == Keys.ams_rockets_ripple_on then
		dev:performClickableAction(device_commands.AMS_RKT_RPL_SGL, 1.0, true)
	end
	if command == Keys.ams_rockets_ripple_off then
		dev:performClickableAction(device_commands.AMS_RKT_RPL_SGL, 0.0, true)
	end
	if command == Keys.ams_rockets_ripple_toggle then
		if rockets_ripple then
			dev:performClickableAction(device_commands.AMS_RKT_RPL_SGL, 0.0, true)
		else
			dev:performClickableAction(device_commands.AMS_RKT_RPL_SGL, 1.0, true)
		end
	end
	if command == device_commands.AMS_RKT_RPL_SGL then
		rockets_ripple =  value>0.5
	end

	if command == Keys.ams_rockets_single then
		dev:performClickableAction(device_commands.AMS_RKT_SGL_PAIR, 1.0, true)
	end
	if command == Keys.ams_rockets_pair then
		dev:performClickableAction(device_commands.AMS_RKT_SGL_PAIR, 0.0, true)
	end
	if command == Keys.ams_rockets_pair_toggle then
		if rockets_pairs then
			dev:performClickableAction(device_commands.AMS_RKT_SGL_PAIR, 1.0, true)
		else
			dev:performClickableAction(device_commands.AMS_RKT_SGL_PAIR, 0.0, true)
		end
	end
	if command == device_commands.AMS_RKT_SGL_PAIR then
		rockets_pairs= value <0.5
	end

	if command == Keys.ams_rockets_side_left then
		dev:performClickableAction(device_commands.AMS_RKT_LR, 0.0, true)
	end
	if command == Keys.ams_rockets_side_both then
		dev:performClickableAction(device_commands.AMS_RKT_LR, 0.5, true)
	end
	if command == Keys.ams_rockets_side_right then
		dev:performClickableAction(device_commands.AMS_RKT_LR, 1,0, true)
	end
	if command == Keys.ams_rockets_side_toggle then
		if rockets_side == 0 then 
			dev:performClickableAction(device_commands.AMS_RKT_LR, 0.5, true)
		elseif rockets_side == 1 then 
			dev:performClickableAction(device_commands.AMS_RKT_LR, 1.0, true)
		elseif rockets_side == 2 then 
			dev:performClickableAction(device_commands.AMS_RKT_LR, 0.0, true)
		end
	end
	if command == device_commands.AMS_RKT_LR then
		--0: left, 1: both, 2: right
		rockets_side = 0
		if value > 0.3 and value < 0.7 then rockets_side = 1 end
		if value > 0.7 then rockets_side = 2 end
	end

	if command == Keys.drop_g1 or command == device_commands.drop_g1 then 
		launch_grenade(7)
	end

	if command == Keys.drop_g2 or command == device_commands.drop_g2 then
		launch_grenade(6)
	end

	if command == Keys.drop_g3 or command == device_commands.drop_g3 then
		launch_grenade(5)
	end

	if command == Keys.drop_g4 or command == device_commands.drop_g4 then
		launch_grenade(4)
	end

	if command == Keys.gunsight_up then
		aiming_mark_keyoffset = aiming_mark_keyoffset+0.002
		if aiming_mark_keyoffset >0.5 then aiming_mark_keyoffset =0.5 end
	end

	if command == Keys.gunsight_down then
		aiming_mark_keyoffset = aiming_mark_keyoffset-0.002
		if aiming_mark_keyoffset <-0.5 then aiming_mark_keyoffset =-0.5 end
	end

	if command == device_commands.AMS_RKT_Range then
		--print_message_to_user('AMS_RKT_Range : ' .. value, 5)
	end
	if command == device_commands.AMS_RKT_Preset then
		--print_message_to_user('AMS_RKT_Preset : ' .. value, 5)
	end
	if command == device_commands.AMS_Button_1 then
		--print_message_to_user('AMS_Button_1 : ' .. value, 5)
	end
	if command == device_commands.AMS_Button_2 then
		--print_message_to_user('AMS_Button_2 : ' .. value, 5)
	end
	if command == device_commands.AMS_Button_3 then
		--print_message_to_user('AMS_Button_3 : ' .. value, 5)
	end
	if command == device_commands.AMS_Button_4 then
		--print_message_to_user('AMS_Button_4 : ' .. value, 5)
	end
	if command == device_commands.AMS_Button_5 then
		--print_message_to_user('AMS_Button_5 : ' .. value, 5)
	end
	if command == device_commands.AMS_Button_6 then
		--print_message_to_user('AMS_Button_6 : ' .. value, 5)
	end
	if command == device_commands.AMS_Button_7 then
		--print_message_to_user('AMS_Button_7 : ' .. value, 5)
	end
end



need_to_be_closed = false -- close lua state after initialization
