dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."math_tools.lua")
dofile(LockOn_Options.common_script_path..'Radio.lua')
--dofile(LockOn_Options.script_path.."utils.lua")

package.cpath 	= package.cpath..";".. LockOn_Options.script_path.. "..\\..\\bin\\?.dll"
require('cefmRadio')
local pos_select=2
local power=1
local loudness1 = 1.0
local loudness2 = 1.0
local loudness3 = 1.0
local master_loudness = 1.0

local dev = GetSelf()


local update_time_step = 0.02 --update will be called once per second
local INTERCOM = nil
make_default_activity(update_time_step)

dev:listen_command(Keys.ptt)
dev:listen_command(Keys.ptt_voice)
dev:listen_command(Keys.inc_intercom_select)
dev:listen_command(Keys.dec_intercom_select)
dev:listen_command(Keys.intercom_select1)
dev:listen_command(Keys.intercom_select2)
dev:listen_command(Keys.intercom_select3)
dev:listen_command(Keys.intercom_mon1_inc)
dev:listen_command(Keys.intercom_mon1_dec)
dev:listen_command(Keys.intercom_mon2_inc)
dev:listen_command(Keys.intercom_mon2_dec)
dev:listen_command(Keys.intercom_mon3_inc)
dev:listen_command(Keys.intercom_mon3_dec)
dev:listen_command(Keys.intercom_vol_inc)
dev:listen_command(Keys.intercom_vol_dec)
dev:listen_command(Keys.intercom_on)
dev:listen_command(Keys.intercom_off)
dev:listen_command(Keys.intercom_onoff_toggle)

local PPT_PILOT = get_param_handle("PPT_PILOT")
local PPT_COPILOT = get_param_handle("PPT_COPILOT")

local RADIO1_ICS = get_param_handle("RADIO1_ICS")
local RADIO2_ICS = get_param_handle("RADIO3_ICS")
local RADIO3_ICS = get_param_handle("RADIO3_ICS")


local INTERCOM_SELECT = get_param_handle("INTERCOM_SELECT")
INTERCOM_SELECT:set(pos_select)

function post_initialize()
	INTERCOM = GetDevice(devices.INTERCOM)
	dev:performClickableAction(device_commands.ICS_Mon1,0.8,true)
	dev:performClickableAction(device_commands.ICS_Mon2,0.8,true)
	dev:performClickableAction(device_commands.ICS_Mon3,0.8,true)
	dev:performClickableAction(device_commands.ICS_Vol,1.0,true)
	dev:performClickableAction(device_commands.ICS_Mode,1.0,true)
	dev:performClickableAction(device_commands.ICS_Select,2.0/7.0,true)
end

function SetCommand(command,value)
	if command == Keys.intercom_mon3_inc then 
		loudness3 = loudness3 +0.0015
		if loudness3>1.0 then loudness3 =1.0 end
		dev:performClickableAction(device_commands.ICS_Mon3,loudness3,true)
	end
	if command == Keys.intercom_mon3_dec then 
		loudness3 = loudness3 -0.0015
		if loudness3<0.0 then loudness3 =0.0 end
		dev:performClickableAction(device_commands.ICS_Mon3,loudness3,true)
	end
	if command == device_commands.ICS_Mon3 then
		loudness3 = value
	end


	if command == Keys.intercom_mon2_inc then 
		loudness2 = loudness2 +0.0015
		if loudness2>1.0 then loudness2 =1.0 end
		dev:performClickableAction(device_commands.ICS_Mon2,loudness2,true)
	end
	if command == Keys.intercom_mon2_dec then 
		loudness2 = loudness2 -0.0015
		if loudness2<0.0 then loudness2 =0.0 end
		dev:performClickableAction(device_commands.ICS_Mon2,loudness2,true)
	end
	if command == device_commands.ICS_Mon2 then
		loudness2 = value
	end

	if command == Keys.intercom_mon1_inc then 
		loudness1 = loudness1 +0.0015
		if loudness1>1.0 then loudness1 =1.0 end
		dev:performClickableAction(device_commands.ICS_Mon1,loudness1,true)
	end
	if command == Keys.intercom_mon1_dec then 
		loudness1 = loudness1 -0.0015
		if loudness1<0.0 then loudness1 =0.0 end
		dev:performClickableAction(device_commands.ICS_Mon1,loudness1,true)
	end
	if command == device_commands.ICS_Mon1 then
		loudness1 = value
	end

	if command == Keys.intercom_vol_inc then 
		master_loudness = master_loudness +0.0015
		if master_loudness>1.0 then master_loudness =1.0 end
		dev:performClickableAction(device_commands.ICS_Vol,master_loudness,true)
	end
	if command == Keys.intercom_vol_dec then 
		master_loudness = master_loudness -0.0015
		if master_loudness<0.0 then master_loudness =0.0 end
		dev:performClickableAction(device_commands.ICS_Vol,master_loudness,true)
	end
	if command == device_commands.ICS_Vol then
		master_loudness = value
	end


	if command == Keys.intercom_on then 
		dev:performClickableAction(device_commands.ICS_Mode,1,true)
	end
	if command == Keys.intercom_off then 
		dev:performClickableAction(device_commands.ICS_Mode,0,true)
	end
	if command == Keys.intercom_onoff_toggle then 
		if power >0.5 then 
			dev:performClickableAction(device_commands.ICS_Mode,0,true)
		else
			dev:performClickableAction(device_commands.ICS_Mode,1,true)
		end
	end
	if command == device_commands.ICS_Mode then
		power = value
	end


	if command == Keys.intercom_select1 then
		pos_select = 2
		dev:performClickableAction(device_commands.ICS_Select,pos_select/7.0,true)
	end
	if command == Keys.intercom_select2 then
		pos_select = 3
		dev:performClickableAction(device_commands.ICS_Select,pos_select/7.0,true)
	end
	if command == Keys.intercom_select3 then
		pos_select = 4
		dev:performClickableAction(device_commands.ICS_Select,pos_select/7.0,true)
	end
	if command == Keys.inc_intercom_select then
		pos_select = pos_select+1
		if pos_select > 8 then pos_select = 8 end
		dev:performClickableAction(device_commands.ICS_Select,pos_select/7.0,true)
	end
	if command == Keys.dec_intercom_select then
		pos_select = pos_select-1
		if pos_select < 0 then pos_select = 0 end
		dev:performClickableAction(device_commands.ICS_Select,pos_select/7.0,true)
	end
	if command == device_commands.ICS_Select then 
		pos_select = math.floor(value*7+0.1)
		INTERCOM_SELECT:set(pos_select)
	end
	

	if command == Keys.ptt then 
		if value > 0.5 then 
			cefmRadio.PTT()
			PPT_PILOT:set(1.0)
			PPT_COPILOT:set(1.0)
		else
			PPT_PILOT:set(0.0)
			PPT_COPILOT:set(0.0)
		end
	end

	if command == Keys.ptt_voice then 
		if value > 0.5 then 
			cefmRadio.PTT_VOIP(true)
		else
			cefmRadio.PTT_VOIP(false)
		end
	end

	if command == device_commands.ICS_MIC then
		--print_message_to_user(tostring(command).." : "..tostring(value), 5)
	end
	if command == device_commands.ICS_NavB then
		--print_message_to_user(tostring(command).." : "..tostring(value), 5)
	end
	if command == device_commands.ICS_NavA then
		--print_message_to_user(tostring(command).." : "..tostring(value), 5)
	end
	if command == device_commands.ICS_Mon5 then
		--print_message_to_user(tostring(command).." : "..tostring(value), 5)
	end
	if command == device_commands.ICS_Mon4 then
		--print_message_to_user(tostring(command).." : "..tostring(value), 5)
	end
	if command == device_commands.ICS_Vox then
		--print_message_to_user(tostring(command).." : "..tostring(value), 5)
	end

end

function update()
	RADIO1_ICS:set(master_loudness*loudness1*power)
	RADIO2_ICS:set(master_loudness*loudness2*power)
	RADIO3_ICS:set(master_loudness*loudness3*power)
end


need_to_be_closed = false -- close lua state after initialization

