dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.script_path .. "devices.lua")

dofile(LockOn_Options.script_path .. "..\\..\\default_radio_presets.lua")

package.cpath = package.cpath .. ";" .. LockOn_Options.script_path .. "..\\..\\bin\\?.dll"
require('cefmRadio')

local COM6 = nil
local COM7 = nil
local COM8 = nil
local INTERCOM = nil

local dev = GetSelf()
local dc_ok = false
local radio_power = get_param_handle("RADIO_POWER_AVAIL")
local INTERCOM_SELECT = get_param_handle("INTERCOM_SELECT")

local ANARC210_POWER = get_param_handle("ANARC210_POWER")
local ANARC210_C = get_param_handle("ARC210_C")
local ANARC210_LC = get_param_handle("ARC210_LC")
local ANARC210_AC = get_param_handle("ARC210_AC")

local ANARC210_TC_0 = get_param_handle("ANARC210_TC_0")
local ANARC210_TC_1 = get_param_handle("ANARC210_TC_1")
local ANARC210_TC_2 = get_param_handle("ANARC210_TC_2")
local ANARC210_TC_3 = get_param_handle("ANARC210_TC_3")
local ANARC210_TC_4 = get_param_handle("ANARC210_TC_4")

local ANARC210_FREQ_0 = get_param_handle("ANARC210_FREQ_0")
local ANARC210_FREQ_1 = get_param_handle("ANARC210_FREQ_1")
local ANARC210_FREQ_2 = get_param_handle("ANARC210_FREQ_2")
local ANARC210_FREQ_3 = get_param_handle("ANARC210_FREQ_3")
local ANARC210_FREQ_4 = get_param_handle("ANARC210_FREQ_4")
local ANARC210_FREQ_5 = get_param_handle("ANARC210_FREQ_5")

local ANARC210_PRESET = get_param_handle("ANARC210_PRESET")
local ANARC210_PRESET_1 = get_param_handle("ANARC210_PRESET_1")
local ANARC210_PRESET_2 = get_param_handle("ANARC210_PRESET_2")

local ANARC210_POWER = get_param_handle("ANARC210_POWER")
local RADIO3_ICS = get_param_handle("RADIO3_ICS")

local cursor_pos = 1
local line_cursor_pos =1

local tri_cursor_pos_0 = 0
local tri_cursor_pos_2 = 1
local tri_cursor_pos_3 = 1
local tri_cursor_pos_4 = 0

local ind_10MHz = 0
local ind_1MHz = 0
local ind_100KHz = 0
local ind_10KHz = 0

local frequency_mode = 4
local frequency = 30.0

local preset = 1

local radio_presets

local modulation = 0        --0 FM 1 AM
local modulation_switch = 0 --0 FM 1 AM

local volume = 0.5
local intercom_select = 2

local mode = 0

dev:listen_command(Keys.arc210_vol_inc)
dev:listen_command(Keys.arc210_vol_dec)
dev:listen_command(Keys.arc210_channel_inc)
dev:listen_command(Keys.arc210_channel_dec)
dev:listen_command(Keys.arc210_channel_push)
dev:listen_command(Keys.arc210_freq_mode_inc)
dev:listen_command(Keys.arc210_freq_mode_dec)
dev:listen_command(Keys.arc210_mode_inc)
dev:listen_command(Keys.arc210_mode_dec)
dev:listen_command(Keys.arc210_button1)
dev:listen_command(Keys.arc210_button2)

ANARC210_POWER:set(1)
ANARC210_C:set(cursor_pos)
ANARC210_AC:set(0)

local function update_communicator()
  if intercom_select == 4 then
    if frequency <155 then 
      if modulation == 0 then
        INTERCOM:set_communicator(devices.COM6)
        INTERCOM:make_setup_for_communicator()
        cefmRadio.SetCurrentCommunicator(2)
        -- print_message_to_user("Enable Com6 210FM")
        -- print_message_to_user(COM3:get_frequency()/1E6)
      else
        INTERCOM:set_communicator(devices.COM7)
        INTERCOM:make_setup_for_communicator()
        cefmRadio.SetCurrentCommunicator(3)
        -- print_message_to_user("Enable Com7 210AM")
        -- print_message_to_user(COM4:get_frequency()/1E6)
      end
    else
      INTERCOM:set_communicator(devices.COM8)
      INTERCOM:make_setup_for_communicator()
      cefmRadio.SetCurrentCommunicator(4)
      -- print_message_to_user("Enable Com8 210 UHF")
      -- print_message_to_user(COM5:get_frequency()/1E6)
    end
  end
end


local function GetRadioChannels()
  if get_aircraft_mission_data == nil then
    return get_default_radio_presets()[3]
  end
  local radio = get_aircraft_mission_data("Radio")
  if radio == nil then
    return get_default_radio_presets()[3]
  end
  if radio[3] == nil then
    return get_default_radio_presets()[3]
  end
  if radio[3].channels then
    return radio[3].channels
  end
  return get_default_radio_presets()[3]
end


local function get_display_numbers_from_freq(freq)
  local mhz_100 = math.floor(freq / 100.0 + 0.0001)
  local mhz_10 = math.floor((freq - mhz_100 * 100) / 10.0 + 0.001)
  local mhz_1 = math.floor((freq - mhz_100 * 100 - mhz_10 * 10) + 0.01)
  local khz_100 = math.floor((freq - mhz_100 * 100 - mhz_10 * 10 - mhz_1) * 10 + 0.1)
  local khz_10 = math.floor((freq - mhz_100 * 100 - mhz_10 * 10 - mhz_1 - khz_100 * 0.1) * 100 + 0.1)
  local khz_1 = math.floor((freq - mhz_100 * 100 - mhz_10 * 10 - mhz_1 - khz_100 * 0.1 - khz_10 * 0.01) * 1000 + 0.1)
  return mhz_100, mhz_10, mhz_1, khz_100, khz_10, khz_1
end

local function update_frequency()
  local old_modulation = modulation
  if frequency_mode == 3 then
    frequency = radio_presets[preset]
  elseif frequency_mode == 4 then
    frequency = (
      (ind_10MHz + 3) * 10 + ind_1MHz * 1 +
      ind_100KHz * 0.100 + ind_10KHz * 0.025)
    if frequency < 88 then
      modulation = 0
    elseif frequency >= 118 and frequency < 156 then
        modulation = 1
    elseif frequency >= 255 then
        modulation = modulation_switch
        COM8:set_modulation(modulation)
    end
  elseif frequency_mode == 5 then
    frequency = 243.0
    modulation = 1
  elseif frequency_mode == 6 then
    frequency = 121.5
    modulation = 1
  end

  if old_modulation ~= modulation then
    update_communicator()
  end
  COM6:set_frequency(frequency * 1E6)
  COM7:set_frequency(frequency * 1E6)
  COM8:set_frequency(frequency * 1E6)
  
  local mhz_100, mhz_10, mhz_1, khz_100, khz_10, khz_1 = get_display_numbers_from_freq(frequency)
  ANARC210_FREQ_0:set(mhz_100)
  ANARC210_FREQ_1:set(mhz_10)
  ANARC210_FREQ_2:set(mhz_1)
  ANARC210_FREQ_3:set(khz_100)
  ANARC210_FREQ_4:set(khz_10)
  ANARC210_FREQ_5:set(khz_1)

  local ip1 = math.floor(preset/10.0 + 0.01)
  local ip2 = math.floor(preset-10*ip1+0.01)
  ANARC210_PRESET_1:set(ip1)
  ANARC210_PRESET_2:set(ip2)
  
end


local function increase_10MHz()
  if frequency_mode == 4 then
    ind_10MHz = ind_10MHz + 1
    if ind_10MHz > 36 then ind_10MHz = 0 end
    update_frequency()
  end
end
local function decrease_10MHz()
  if frequency_mode == 4 then
    ind_10MHz = ind_10MHz - 1
    if ind_10MHz < 0 then ind_10MHz = 36 end
    update_frequency()
  end
end

local function increase_1MHz()
  if frequency_mode == 4 then
    ind_1MHz = ind_1MHz + 1
    if ind_1MHz > 9 then ind_1MHz = 0 end
    update_frequency()
  end
end
local function decrease_1MHz()
  if frequency_mode == 4 then
    ind_1MHz = ind_1MHz - 1
    if ind_1MHz < 0 then ind_1MHz = 9 end
    update_frequency()
  end
end

local function increase_100KHz()
  if frequency_mode == 4 then
    ind_100KHz = ind_100KHz + 1
    if ind_100KHz > 9 then ind_100KHz = 0 end
    update_frequency()
  end
end
local function decrease_100KHz()
  if frequency_mode == 4 then
    ind_100KHz = ind_100KHz - 1
    if ind_100KHz < 0 then ind_100KHz = 9 end
    update_frequency()
  end
end

local function increase_10KHz()
  if frequency_mode == 4 then
    ind_10KHz = ind_10KHz + 1
    if ind_10KHz > 3 then ind_10KHz = 0 end
    update_frequency()
  end
end
local function decrease_10KHz()
  if frequency_mode == 4 then
    ind_10KHz = ind_10KHz - 1
    if ind_10KHz < 0 then ind_10KHz = 3 end
    update_frequency()
  end
end


local update_time_step = 0.01
make_default_activity(update_time_step)



function post_initialize()
  radio_presets = GetRadioChannels()
  
  COM6 = GetDevice(devices.COM6)
  COM7 = GetDevice(devices.COM7)
  COM8 = GetDevice(devices.COM8)
  INTERCOM = GetDevice(devices.INTERCOM)

  local birth = LockOn_Options.init_conditions.birth_place
  if birth == "GROUND_HOT" or birth == "AIR_HOT" then
    dev:performClickableAction(device_commands.ARC210_Mode, 3.0/5.0, true)
  elseif birth == "GROUND_COLD" then
    dev:performClickableAction(device_commands.ARC210_Mode, 0.0, true)
  end
  dev:performClickableAction(device_commands.ARC210_Vol, 0.5, true)
  dev:performClickableAction(device_commands.ARC210_Freq_Mode, 4.0/6.0, true)

end

function SetCommand(command, value)
  
  if command == Keys.arc210_vol_inc then 
    volume = volume + 0.0015
    if volume > 1.0 then volume = 1.0 end
    dev:performClickableAction(device_commands.ARC210_Vol,volume,true)
  end
  if command == Keys.arc210_vol_dec then 
    volume = volume - 0.0015
    if volume < 0.0 then volume = 0.0 end
    dev:performClickableAction(device_commands.ARC210_Vol,volume,true)
  end
  if command == device_commands.ARC210_Vol then
    volume = value
    cefmRadio.SetVolume(5, volume*RADIO3_ICS:get())
    cefmRadio.SetVolume(6, volume*RADIO3_ICS:get())
    cefmRadio.SetVolume(7, volume*RADIO3_ICS:get())
  end

  if command == Keys.arc210_mode_inc then 
    mode = mode+1
    if mode > 5 then mode = 5 end
    dev:performClickableAction(device_commands.ARC210_Mode,mode/5.0,true)
  end
  if command == Keys.arc210_mode_dec then 
    mode = mode-1
    if mode < 0 then mode = 0 end
    dev:performClickableAction(device_commands.ARC210_Mode,mode/5.0,true)
  end
  if command == device_commands.ARC210_Mode then
    mode = math.floor(value*5.0+0.1)
  end

  if command == Keys.arc210_channel_inc then 
    dev:performClickableAction(device_commands.ARC210_Channel_Axis,0.0015,true)
  end
  if command == Keys.arc210_channel_dec then 
    dev:performClickableAction(device_commands.ARC210_Channel_Axis,-0.0015,true)
  end
  if command == device_commands.ARC210_Channel_Axis then
    if frequency_mode == 3 then
      if value >0 then 
        preset = preset + 1
        if preset > 20 then preset =1 end
      elseif value < 0 then 
        preset = preset - 1
        if preset < 1 then preset =20 end
      end
      update_frequency()
    elseif frequency_mode == 4 then
      if value > 0 then
        if cursor_pos == 1 then
          increase_10MHz()
        elseif cursor_pos == 2 then
          increase_1MHz()
        elseif cursor_pos == 3 then
          increase_100KHz()
        elseif cursor_pos == 4 then
          increase_10KHz()
        end
      elseif value < 0 then
        if cursor_pos == 1 then
          decrease_10MHz()
        elseif cursor_pos == 2 then
          decrease_1MHz()
        elseif cursor_pos == 3 then
          decrease_100KHz()
        elseif cursor_pos == 4 then
          decrease_10KHz()
        end
      end
    end
  end

  if command == device_commands.ARC210_Channel_Push or command == Keys.arc210_channel_push then
    if frequency_mode == 4 then 
      if value == 0 then
        cursor_pos = cursor_pos + 1
        if cursor_pos > 4 then cursor_pos = 1 end
      end
    end
  end

  if command == Keys.arc210_freq_mode_inc then 
    frequency_mode = frequency_mode+1
    if frequency_mode > 6 then frequency_mode = 6 end
    dev:performClickableAction(device_commands.ARC210_Freq_Mode,frequency_mode/6.0,true)
  end
  if command == Keys.arc210_freq_mode_dec then 
    frequency_mode = frequency_mode-1
    if frequency_mode < 0 then frequency_mode = 0 end
    dev:performClickableAction(device_commands.ARC210_Freq_Mode,frequency_mode/6.0,true)
  end
  if command == device_commands.ARC210_Freq_Mode then
    frequency_mode = math.floor(value*6.0+0.1)
    update_frequency()
  end

  if command == device_commands.ARC210_Button_1 or  command == Keys.arc210_button1 then
    if value == 0 then 
      line_cursor_pos = line_cursor_pos+1
      if line_cursor_pos > 4 then line_cursor_pos =0 end
    end
  end

  if command == device_commands.ARC210_Button_2 or command == Keys.arc210_button2 then
    if value == 0 then 
      if line_cursor_pos ==0 then
        if tri_cursor_pos_0 ==0 then tri_cursor_pos_0 =1 else tri_cursor_pos_0 = 0 end
      elseif line_cursor_pos ==1 then
        if modulation_switch < 0.5 then 
          modulation_switch = 1
        else 
          modulation_switch = 0
        end
        update_frequency()
      elseif line_cursor_pos ==2 then
        if tri_cursor_pos_2 ==0 then tri_cursor_pos_2 =1 else tri_cursor_pos_2 = 0 end
      elseif line_cursor_pos ==3 then
        if tri_cursor_pos_3 ==0 then tri_cursor_pos_3 =1 else tri_cursor_pos_3 = 0 end
      elseif line_cursor_pos ==4 then
        if tri_cursor_pos_4 ==0 then tri_cursor_pos_4 =1 else tri_cursor_pos_4 = 0 end
      end
    end
  end

  if command == device_commands.ARC210_Load then
    -- no effect
  end
end

function update()
  local actual_power = radio_power:get() > 0.5
  
  local enable_radios = false
  local enable_display = false
  if (actual_power ==true) then
    if mode == 3 then
      enable_radios = true
    end
    if mode > 1 then enable_display = true end
  end
  if enable_radios then 
    cefmRadio.SetPower(5, true)
    cefmRadio.SetPower(6, true)
    cefmRadio.SetPower(7, true)
  else
    cefmRadio.SetPower(5, false)
    cefmRadio.SetPower(6, false)
    cefmRadio.SetPower(7, false)
  end
  
  if enable_display then
    ANARC210_POWER:set(1.0)
  else
    ANARC210_POWER:set(0.0)
  end

  if frequency_mode == 4 then 
    ANARC210_C:set(cursor_pos)
  else
    ANARC210_C:set(0)
  end

  ANARC210_LC:set(line_cursor_pos)
  ANARC210_TC_0:set(tri_cursor_pos_0)
  ANARC210_TC_1:set(modulation)
  ANARC210_TC_2:set(tri_cursor_pos_2)
  ANARC210_TC_3:set(tri_cursor_pos_3)
  ANARC210_TC_4:set(tri_cursor_pos_4)

  if frequency_mode ==3 then 
    ANARC210_PRESET:set(1)
  else
    ANARC210_PRESET:set(0)
  end

  local actual_intercom_select = INTERCOM_SELECT:get()
  if intercom_select ~= actual_intercom_select then
    intercom_select = actual_intercom_select
    update_communicator()
  end
end

need_to_be_closed = false
