dofile(LockOn_Options.common_script_path.."elements_defs.lua")



local LEVEL = 1

local screen = MakeMaterial(nil,{150,0,0,255})

local greenColor = {20,250,20,220}
local font7segment = MakeFont({used_DXUnicodeFontData = "font7segment"}, greenColor)
local dispmat =  MakeMaterial(nil,greenColor)

local avionics_otf = {class = "ceUITTF", ttf = LockOn_Options.script_path.."Ressources/hp-simplified-hans-regular.ttf", size = 40}
FONT  = MakeFont(avionics_otf, {0,255,0,215})

local Width = 0.051936
local Height = 0.01747


local verts = {}
verts [1]= {-0.5*Width   , 0.5*Height}
verts [2]= { 0.5*Width   , 0.5*Height}
verts [3]= { 0.5*Width   ,-0.5*Height}
verts [4]= {-0.5*Width   ,-0.5*Height}

-- background
local base = CreateElement "ceMeshPoly"
base.name = create_guid_string()
base.material = screen
base.vertices = verts
base.indices = {0,1,2,2,3,0}
base.init_pos = {0,0.0,0}
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
base.level = LEVEL
base.isdraw	   = true
base.isvisible = false
base.element_params = {
	"ANARC210_POWER"
}
base.controllers = {
	{"parameter_in_range",0,0.9,1.1}
}
Add(base)


local function add_lines(parent, verts, width,visarg,visvalue)
	local element 			= CreateElement "ceSimpleLineObject"
	element.name 			    = create_guid_string()
	element.material 		    = dispmat
	element.width			    = width
	element.vertices          = verts
	element.init_pos 		    = {0.0,0.0, 0.0}
	element.parent_element    = parent
	element.use_mipfilter             = true
	element.additive_alpha            = true
	element.h_clip_relation  = h_clip_relations.REWRITE_LEVEL
	element.level			= LEVEL
	element.element_params    = {
		visarg,
		"RADIO_LIGHTS"
	}
	element.controllers 	    = {
		{"parameter_in_range",0,visvalue-0.01,visvalue+0.01},
		--{"opacity_using_parameter",1}
	}
	Add(element)
end

local function add_digit(parent, x,y,width,height, controller, visarg, visvalue)
	local digit           = CreateElement "ceStringPoly"
	digit.name            = create_guid_string()
	digit.material        = font7segment
	digit.alignment       = "LeftBottom"
	digit.init_pos		 = {x,y,0}
	digit.stringdefs      = {height,width, 0, 0}  -- {size vertical, horizontal, 0, 0}
	digit.formats         = {"%1.0f"} 
	digit.value =8
	if visarg ==nil then 
		digit.element_params  = {
			controller,
			"ANARC210_POWER",
			"RADIO_LIGHTS"
		}
		digit.controllers     = {
			{"text_using_parameter",0,0},
			--{"parameter_compare_with_number", 1, 1},
			--{"opacity_using_parameter",2}
		}  
	else
		digit.element_params  = {
			controller,
			"ANARC210_POWER",
			"RADIO_LIGHTS",
			visarg
		}
		digit.controllers     = {
			{"text_using_parameter",0,0},
			--{"parameter_compare_with_number", 1, 1},
			--{"opacity_using_parameter",2},
			{"parameter_in_range",3,visvalue-0.01,visvalue+0.01},
		}  
	end



	digit.h_clip_relation  = h_clip_relations.REWRITE_LEVEL
	digit.level			= LEVEL
	digit.parent_element  = parent
	Add(digit)
end

local delta_x = 0.0047
local cut = 0.0004
local y_offset = 0.000
local x_offset = 0.00
local spacing = 0.0004
add_lines(base.name,{{x_offset+(0-3)*delta_x+cut,y_offset},{x_offset+(0-2)*delta_x-cut,y_offset}},
	0.00025,"ARC210_C",1)
add_lines(base.name,{{x_offset+(1-3)*delta_x+cut,y_offset},{x_offset+(1-2)*delta_x-cut,y_offset}},
	0.00025, "ARC210_C",1)
add_lines(base.name,{{x_offset+(2-3)*delta_x+cut,y_offset},{x_offset+(2-2)*delta_x-cut,y_offset}},
	0.00025,"ARC210_C",2)
add_lines(base.name,{{x_offset+(3-3)*delta_x+cut,y_offset},{x_offset+(3-2)*delta_x-cut,y_offset}},
	0.00025,"ARC210_C",3)
add_lines(base.name,{{x_offset+(4-3)*delta_x+cut,y_offset},{x_offset+(4-2)*delta_x-cut,y_offset}},
	0.00025,"ARC210_C",4)
add_lines(base.name,{{x_offset+(5-3)*delta_x+cut,y_offset},{x_offset+(5-2)*delta_x-cut,y_offset}},
	0.00025, "ARC210_C",4)
-- for i = 0, 5, 1 do
-- 	add_lines(base.name,{
-- 		{(i-3)*delta_x+cut,y_offset},
-- 		{(i-2)*delta_x-cut,y_offset}},0.00015)
-- end
for i = 0, 5, 1 do
	add_digit(base.name,(i-3)*delta_x+cut,y_offset+spacing,delta_x-2*cut,Height*0.5-y_offset-2*spacing,"ANARC210_FREQ_"..i)
end

add_digit(base.name,-0.002+(-5)*delta_x+cut,spacing,delta_x-2*cut,Height*0.5-2*spacing,"ANARC210_PRESET_"..1,"ANARC210_PRESET",1)
add_digit(base.name,-0.002+(-4)*delta_x+cut,spacing,delta_x-2*cut,Height*0.5-2*spacing,"ANARC210_PRESET_"..2,"ANARC210_PRESET",1)


local x0 = 0.0
local y0 = y_offset+1.5*spacing
local size = 0.0015

verts [1]= {x0-0.5*size, y0}
verts [2]= {x0, y0+0.5*size}
verts [3]= {x0+0.5*size, y0}
verts [4]= {x0,y0-0.5*size}
-- verts={
-- 	{x0-0.5*size, y0},
-- 	{x0, y0+0.5*size},
-- 	{x0+0.5*size, y0},
-- 	{x0,y0-0.5*size},
	
-- }

local dot = CreateElement "ceMeshPoly"
dot.name = create_guid_string()
dot.parent_element  = base.name
dot.material = dispmat
dot.vertices = verts
dot.indices = {0,1,2,2,3,0}
dot.init_pos = {0,0.0,0}
dot.h_clip_relation = h_clip_relations.REWRITE_LEVEL
dot.level = LEVEL
dot.isdraw	   = true
dot.isvisible = true
dot.element_params = {
	"ANARC210_POWER",
	"RADIO_LIGHTS"
}
dot.controllers = {
	--{"parameter_compare_with_number", 0, 1},
	{"opacity_using_parameter",1}
}
Add(dot)


local text_y1 = -0.002
local text_y2 = -0.0055

local text_x1 = -0.022
local text_x2 = -0.013
local text_x3 = -0.005
local text_x4 = 0.003
local text_x5 = 0.012

local small_font = 0.0025

local function add_text(x,y,text, fontsize)
	local text_el           = CreateElement "ceStringPoly"
	text_el.name            = create_guid_string()
	text_el.parent_element = base.name
	text_el.material        = FONT
	text_el.init_pos        = {x,y,0.0}		
	text_el.alignment       = "LeftCenter"
	text_el.stringdefs      = {fontsize,0.75*fontsize, 0, 0}  -- {size vertical, horizontal, 0, 0}
	text_el.value         = text
	text_el.element_params  = {
		"ANARC210_POWER",
		"RADIO_LIGHTS"
	}
	text_el.controllers    = {
	--	{"parameter_in_range",0,0.9,1.1},
		{"opacity_using_parameter",1}
	}
	Add(text_el)
end

add_text(text_x1,text_y1,"TIME",small_font)
add_text(text_x1,text_y2,"CPS",small_font)

add_text(text_x2,text_y1,"AM",small_font)
add_text(text_x2,text_y2,"FM",small_font)

add_text(text_x3,text_y1,"H",small_font)
add_text(text_x3,text_y2,"L",small_font)

add_text(text_x4,text_y1,"SHQ",small_font)
add_text(text_x4,text_y2,"RCV",small_font)

add_text(text_x5,text_y1,"LE",small_font)
add_text(text_x5,text_y2,"OFST",small_font)


add_text(0.015,0.0065,"SHQ1",1.0*small_font)
add_text(0.015,0.003,"FAULT",1.0*small_font)

local function add_tri(x,y,visarg,visvalue)
	local w = 0.0015 
	local h = 0.002 
	local verts ={
		[1]= {x-w, y+h*0.5},
		[2]= {x, y},
		[3]= {x-w, y-h*0.5},
	}

	local tri = CreateElement "ceMeshPoly"
	tri.name = create_guid_string()
	tri.parent_element  = base.name
	tri.material = dispmat
	tri.vertices = verts
	tri.indices = {0,1,2}
	tri.init_pos = {0,0.0,0}
	tri.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	tri.level = LEVEL
	tri.isdraw	   = true
	tri.isvisible = true
	tri.element_params = {
		visarg,
		"RADIO_LIGHTS"
	}
	tri.controllers = {
		{"parameter_in_range",0,visvalue-0.01,visvalue+0.01},
		{"opacity_using_parameter",1}
	}
	Add(tri)
end

add_tri(text_x1,text_y1,"ANARC210_TC_0",0)
add_tri(text_x1,text_y2,"ANARC210_TC_0",1)
add_tri(text_x2,text_y1,"ANARC210_TC_1",1)
add_tri(text_x2,text_y2,"ANARC210_TC_1",0)
add_tri(text_x3,text_y1,"ANARC210_TC_2",0)
add_tri(text_x3,text_y2,"ANARC210_TC_2",1)
add_tri(text_x4,text_y1,"ANARC210_TC_3",0)
add_tri(text_x4,text_y2,"ANARC210_TC_3",1)
add_tri(text_x5,text_y1,"ANARC210_TC_4",0)
add_tri(text_x5,text_y2,"ANARC210_TC_4",1)


add_lines(base.name,{
	{text_x1,text_y2-0.6*small_font},
	{text_x1+0.8*delta_x,text_y2-0.6*small_font}},0.00025,"ARC210_LC",0)

add_lines(base.name,{
	{text_x2,text_y2-0.6*small_font},
	{text_x2+0.8*delta_x,text_y2-0.6*small_font}},0.00025,"ARC210_LC",1)

add_lines(base.name,{
	{text_x3,text_y2-0.6*small_font},
	{text_x3+0.8*delta_x,text_y2-0.6*small_font}},0.00025,"ARC210_LC",2)

add_lines(base.name,{
	{text_x4,text_y2-0.6*small_font},
	{text_x4+0.8*delta_x,text_y2-0.6*small_font}},0.00025,"ARC210_LC",3)

add_lines(base.name,{
	{text_x5,text_y2-0.6*small_font},
	{text_x5+0.8*delta_x,text_y2-0.6*small_font}},0.00025,"ARC210_LC",4)