dofile(LockOn_Options.script_path.."command_defs.lua")

local dev = GetSelf()
local sensor_data = get_base_data()
local update_time_step = 0.2


local dc_elec = get_param_handle("DC_POWER_AVAIL")
local CLOCK_POWER = get_param_handle("CLOCK_POWER")

local M880A_Bright = 0.7

local GMTBlinkH = get_param_handle("GMT_BLINK_H")
local GMTMS = get_param_handle("GMT_MS")

local LTBlinkHH = get_param_handle("LT_BLINK_HH")
local LTBlinkH = get_param_handle("LT_BLINK_H")
local LTBlinkMM = get_param_handle("LT_BLINK_MM")
local LTBlinkM = get_param_handle("LT_BLINK_M")

local GMThour = get_param_handle("GMT_HOURS")	-- first line display
local GMTmin = get_param_handle("GMT_MINS")
local GMTsec = get_param_handle("GMT_SECS")

local LTDhour = get_param_handle("LT_DHOURS")		--second line display
local LThour = get_param_handle("LT_HOURS")		--second line display
local LTDmin = get_param_handle("LT_DMINS")
local LTmin = get_param_handle("LT_MINS")

local GMTmode = get_param_handle("GMT_MODE")
local LTmode = get_param_handle("LT_MODE")
local ELmode = get_param_handle("EL_MODE")

local displayMode = {GMTmode, LTmode, ELmode}
local displayModeIndex = 0
local clockDisplayMode = get_param_handle("clockDisplayMode") -- 0:GMT, 1:LocalTime, 2: ElapsedTime

local runCountUP = false
local runCountDOWN = false
local elapseTime = 0
local startTime = 0	--3599
local alarm = false
local countDownMode = false
local compt = 0
local setGMTTime = false
local setCountDown = false
local digitCount = 0
local Timer = {0,0,0,0}
local countTime = 0

theatre  = get_terrain_related_data("name")

local GMToffset = 0
local LToffset = 0
local timeOffset = 0

function post_initialize()
	if theatre == 'Caucasus' then
		GMToffset = -3
	elseif theatre == 'Nevada' then
		GMToffset = 8
	elseif theatre == 'Persian Gulf' then
		GMToffset = -4
	--elseif theatre == 'Syria' then -- syria doesnt seem to be registered as a theatre 
		--GMToffset = -2
	end
	--print_message_to_user(theatre)
	local birth = LockOn_Options.init_conditions.birth_place
	if birth=="GROUND_HOT" or birth=="AIR_HOT" then
		LTBlinkHH:set(M880A_Bright)
		LTBlinkH:set(M880A_Bright)
		LTBlinkMM:set(M880A_Bright)
		LTBlinkM:set(M880A_Bright)
		displayMode[1]:set(M880A_Bright)
    elseif birth=="GROUND_COLD" then
		LTBlinkHH:set(0)
		LTBlinkH:set(0)
		LTBlinkMM:set(0)
		LTBlinkM:set(0)
		displayMode[1]:set(0)	-- Set GMT Marker by default
	end
	GMTBlinkH:set(M880A_Bright)
	GMTMS:set(M880A_Bright)
	displayMode[2]:set(0)
	displayMode[3]:set(0)
	dev:performClickableAction(device_commands.clock_brightness,M880A_Bright,true)
end

dev:listen_command(device_commands.AltimeterSet)
dev:listen_command(Keys.clock_SLCT_CTRL)

function SetCommand(command,value)

    if command == device_commands.AltimeterSet then
		if alt_setting > ALT_PRESSURE_MAX then
		
		elseif alt_setting < ALT_PRESSURE_MIN then
			
		end
	end
	
	if command == device_commands.clock_brightness then
		M880A_Bright = value + 0.1
		GMTBlinkH:set(M880A_Bright)
		GMTMS:set(M880A_Bright)
		if LTBlinkHH:get() > 0 then
			LTBlinkHH:set(M880A_Bright)
		end
		if LTBlinkH:get() > 0 then
			LTBlinkH:set(M880A_Bright)
		end
		if LTBlinkMM:get() > 0 then
			LTBlinkMM:set(M880A_Bright)
		end
		if LTBlinkM:get() > 0 then
			LTBlinkM:set(M880A_Bright)
		end
		if displayMode[1]:get() > 0 then
			displayMode[1]:set(M880A_Bright)
		end
		if displayMode[2]:get() > 0 then
			displayMode[2]:set(M880A_Bright)
		end
		if displayMode[2]:get() > 0 then
			displayMode[2]:set(M880A_Bright)
		end		

	end
	
	if dc_elec:get() > 0.5 then	
	
		if command == device_commands.clock_slct then	
			if value == 1 then
				if displayModeIndex == 0 and setGMTTime then
					resetGMTTimeSet()
					
				elseif displayModeIndex == 2 and setCountDown then
					if digitCount < 4 then
						digitCount = digitCount + 1
						if digitCount == 2 then 
							LTBlinkHH:set(M880A_Bright)
						elseif digitCount == 3 then 
							LTBlinkH:set(M880A_Bright)
						elseif digitCount == 4 then 
							LTBlinkMM:set(M880A_Bright)								
						end
					else
						setCountDown = false
						LTBlinkM:set(M880A_Bright)
						countTime = elapseTime
					end
					
				elseif displayModeIndex == 2 and countDownMode and runCountDOWN then
					runCountDOWN = not runCountDOWN
					resetCountDown()
					
				else	--Announcer
					displayMode[displayModeIndex + 1]:set(0)
					displayModeIndex = displayModeIndex + 1
					if displayModeIndex > 2 then 
						displayModeIndex = 0
					end
					displayMode[displayModeIndex + 1]:set(M880A_Bright)
				end
			end
		end
	
		if command == device_commands.clock_ctrl then
			if value == 1 then
				if displayModeIndex == 0 and setGMTTime then	
					GMToffset = GMToffset + 1
					
				elseif displayModeIndex == 2 then
					if countDownMode then
						if setCountDown then
							Timer[digitCount] = Timer[digitCount] + 1
							if (digitCount == 1 or digitCount == 3) and Timer[digitCount] > 5 then
								Timer[digitCount] = 0
							elseif (digitCount == 2 or digitCount == 4) and Timer[digitCount] > 9 then
								Timer[digitCount] = 0
							end				
							elapseTime = Timer[1] * 600 + Timer[2] * 60 + Timer[3] * 10 + Timer[4]
							
						elseif runCountDOWN then		
							runCountDOWN = not runCountDOWN
							resetCountDown()
						else
							runCountDOWN = not runCountDOWN
							startTime = get_absolute_model_time()
						end

					else
						runCountUP = not runCountUP
						startTime = get_absolute_model_time()
						if not runCountUP then
							elapseTime = 0
						end
					end
				end
			end
		end
	
		if command == Keys.clock_SLCT_CTRL then
			if displayModeIndex == 0 then			-- GMT Setting
				print_message_to_user('GMT Time Setting', 5)
				setGMTTime = true
				
			elseif displayModeIndex == 2 then
				countDownMode = true
				print_message_to_user('Count Down Mode', 5)
				digitCount = 1
				setCountDown = true
				elapseTime = 0
			end
		end
	end
end

function resetCountDown()
	alarm = false
	setCountDown = false
	countDownMode = false
	elapseTime = 0
	Timer = {0,0,0,0}
	LTBlinkHH:set(M880A_Bright)
	LTBlinkH:set(M880A_Bright)
	LTBlinkMM:set(M880A_Bright)
	LTBlinkM:set(M880A_Bright)
end

function resetGMTTimeSet()
	setGMTTime = false
	GMTBlinkH:set(M880A_Bright)
end

function update()
	local GMT_hour, LT_hour, minut, second, dummy
	

	if dc_elec:get() > 0.5 then	-- Batt On - Clock Initialization
		CLOCK_POWER:set(1)
		displayMode[1]:set(M880A_Bright)	
		LTBlinkHH:set(M880A_Bright)
		LTBlinkH:set(M880A_Bright)
		LTBlinkMM:set(M880A_Bright)
		LTBlinkM:set(M880A_Bright)
	else
		CLOCK_POWER:set(0)
	end
	
	
	local abstime = get_absolute_model_time() -- gives local time of day in seconds
	
	if runCountUP then
		elapseTime = abstime - startTime
	elseif runCountDOWN then
		local ecartTime = abstime - startTime
		elapseTime = countTime - ecartTime	
		if elapseTime < 0 then
			elapseTime = elapseTime * -1
			alarm = true
		end
	end
	
	LT_hour, dummy = math.modf(abstime / 3600)
	if abstime + GMToffset * 3600 > 86399 then
		GMToffset = GMToffset - 24
	end
	abstime = abstime + GMToffset * 3600
	GMT_hour, dummy = math.modf(abstime / 3600)
	minut, dummy = math.modf(dummy * 60)
	second = math.floor(dummy * 60 + 0.1)

	GMThour:set(GMT_hour)
    GMTmin:set(minut)
	GMTsec:set(second)
	
	if displayModeIndex == 0 then
		if setGMTTime then
			GMTblinkHour()
		end
		int1, frac1 = math.modf(GMT_hour / 10)
		LTDhour:set(math.floor(int1))
		LThour:set(frac1 * 10)
		int1, frac1 = math.modf(minut / 10)
		LTDmin:set(math.floor(int1))
		LTmin:set(frac1 * 10)
		
	elseif displayModeIndex == 1 then
		int1, frac1 = math.modf(LT_hour / 10)
		LTDhour:set(math.floor(int1))
		LThour:set(frac1 * 10)	
		int1, frac1 = math.modf(minut / 10)
		LTDmin:set(math.floor(int1))
		LTmin:set(frac1 * 10)

	elseif displayModeIndex == 2 then
		hour, dummy = math.modf(elapseTime / 3600)
		minut, dummy = math.modf(dummy * 60)
		second = math.floor(dummy * 60 + 0.1)
	
		if alarm then
			blinkAlarm()
		end
		
		if setCountDown then
			LTblinkSet()
		end
		
		if hour > 0 then
			int1, frac1 = math.modf(hour / 10)
			LTDhour:set(math.floor(int1))
			LThour:set(frac1 * 10)
			int1, frac1 = math.modf(minut / 10)
			LTDmin:set(math.floor(int1))
			LTmin:set(frac1 * 10)
		else
			int1, frac1 = math.modf(minut / 10)
			LTDhour:set(math.floor(int1))
			LThour:set(frac1 * 10)
			int1, frac1 = math.modf(second / 10)
			LTDmin:set(math.floor(int1))
			LTmin:set(frac1 * 10)
		end		
	end
	clockDisplayMode:set(displayModeIndex)

	

end

function blinkAlarm()
	compt = compt + 0.2
	if compt < 0.6 then
		LTBlinkHH:set(0)
		LTBlinkH:set(0)
		LTBlinkMM:set(0)
		LTBlinkM:set(0)
	elseif compt < 1.2 then
		LTBlinkHH:set(M880A_Bright)
		LTBlinkH:set(M880A_Bright)
		LTBlinkMM:set(M880A_Bright)		
		LTBlinkM:set(M880A_Bright)		
	else
		compt = 0
	end
end

function LTblinkSet()
	compt = compt + 0.2
	if compt < 0.6 then
		if digitCount == 1 then
			LTBlinkHH:set(0)
		elseif digitCount == 2 then
			LTBlinkH:set(0)
		elseif digitCount == 3 then
			LTBlinkMM:set(0)
		elseif digitCount == 4 then
			LTBlinkM:set(0)			
		end
	elseif compt < 1.2 then
		if digitCount == 1 then
			LTBlinkHH:set(M880A_Bright)
		elseif digitCount == 2 then
			LTBlinkH:set(M880A_Bright)
		elseif digitCount == 3 then
			LTBlinkMM:set(M880A_Bright)
		elseif digitCount == 4 then
			LTBlinkM:set(M880A_Bright)			
		end
	else
		compt = 0
	end
end

function GMTblinkHour()
	compt = compt + 0.2
	if compt < 0.6 then
		GMTBlinkH:set(0)
	elseif compt < 1.2 then
		GMTBlinkH:set(M880A_Bright)
	else
		compt = 0
	end
end

make_default_activity(update_time_step)

need_to_be_closed = false 