dofile(LockOn_Options.common_script_path .. "elements_defs.lua")

SetScale(METERS)
local orangeColor = { 255, 40, 20, 220 }


local font7segment   = MakeFont({ used_DXUnicodeFontData = "DSEG7Classic-bold" }, orangeColor)
local font14segment  = MakeFont({ used_DXUnicodeFontData = "DSEG14Classic-italic" }, orangeColor)

local center         = { 0.0, 0.0, 0.0 } --- {L/R,U/D,forward/back}

local verts          = {}
local dx             = .013
local dy             = .0088
verts[1]             = { -dx, -dy }
verts[2]             = { -dx, dy }
verts[3]             = { dx, dy }
verts[4]             = { dx, -dy }

local base           = CreateElement "ceMeshPoly"
base.name            = "base"
base.vertices        = verts
base.indices         = { 0, 1, 2, 2, 3, 0 }
base.init_pos        = center
base.material        = MakeMaterial(nil, { 255, 3, 3, 255 })
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
base.level           = 6
base.isdraw          = true
base.change_opacity  = false
base.isvisible       = false
base.element_params  = { "DC_POWER_AVAIL" }
base.controllers     = { { "parameter_in_range", 0, 0.9, 1.1 } }
Add(base)



local fontsize             = 0.011
local FuelAmount           = CreateElement "ceStringPoly"
FuelAmount.name            = create_guid_string()
FuelAmount.material        = font7segment
FuelAmount.alignment       = "RightCenter"
FuelAmount.init_pos        = { dx - 0.25 * fontsize, -0.1 * 0.75 * fontsize, 0 }
FuelAmount.stringdefs      = { fontsize, 0.85 * fontsize, -0.15 * fontsize, 0 } -- {size vertical, horizontal, 0, 0}
FuelAmount.formats         = { "%03.0f" }
FuelAmount.element_params  = {
	"IND_FUEL",
	"FQI_BRIGHTNESS",
	"SHOW_AUX_FQ",
}
FuelAmount.controllers     = {
	{ "text_using_parameter",    0, 0 },
	{ "opacity_using_parameter", 1 },
	--{"parameter_in_range",2,-0.1,0.5}
}
FuelAmount.h_clip_relation = h_clip_relations.REWRITE_LEVEL
FuelAmount.level           = 6
FuelAmount.parent_element  = base.name
Add(FuelAmount)

local FuelPeriod           = CreateElement "ceStringPoly"
FuelPeriod.name            = create_guid_string()
FuelPeriod.material        = font7segment
FuelPeriod.alignment       = "RightCenter"
FuelPeriod.init_pos        = { dx - 0.25 * fontsize, -0.1 * 0.75 * fontsize, 0 }
FuelPeriod.stringdefs      = { fontsize, 0.85 * fontsize, -0.18 * fontsize, 0 } -- {size vertical, horizontal, 0, 0}
FuelPeriod.formats         = { "%s" }
FuelPeriod.value           = ". "
FuelPeriod.element_params  = {
	"FQI_BRIGHTNESS",
}
FuelPeriod.controllers     = {
	{ "opacity_using_parameter", 0 },
}
FuelPeriod.h_clip_relation = h_clip_relations.REWRITE_LEVEL
FuelPeriod.level           = 6
FuelPeriod.parent_element  = base.name
Add(FuelPeriod)

local smaller_fontsize = 0.006
local text             = CreateElement "ceStringPoly"
text.name              = create_guid_string()
text.material          = font14segment
text.alignment         = "CenterCenter"
text.init_pos          = { -0.0 * smaller_fontsize, -1.3 * 0.75 * fontsize, 0 }
text.stringdefs        = { smaller_fontsize, 0.75 * smaller_fontsize, -0.1 * smaller_fontsize, 0 } -- {size vertical, horizontal, 0, 0}
text.value             = "  A"
text.element_params    = {
	"SHOW_AUX_FQ",
	"FQI_BRIGHTNESS"
}
text.controllers       = {
	{ "parameter_in_range",      0, 0.5, 1.1 },
	{ "opacity_using_parameter", 1 }
}
text.h_clip_relation   = h_clip_relations.REWRITE_LEVEL
text.level             = 6
text.parent_element    = base.name
Add(text)




local numSegments = 20

local Xsize = 0.0025
local Ysize = Xsize * 0.53
local rx = 0.023
local ry = 0.023
local dr = 0.0055
local y_offset = 0.000
local max_fuel = 400
for i = 0, numSegments - 1 do
	local segment1           = CreateElement "ceMeshPoly"
	segment1.name            = "segment_" .. i
	local a1                 = 198 / 180 * ((i - 1) / (numSegments) + 1.5 / 360) * math.pi
	local a2                 = 198 / 180 * ((i) / (numSegments) - 1.5 / 360) * math.pi
	local cos1               = math.cos(a1)
	local sin1               = math.sin(a1)
	local cos2               = math.cos(a2)
	local sin2               = math.sin(a2)

	segment1.init_pos        = { 0, 0, 0.000 }
	segment1.init_rot        = { 0 }
	segment1.element_params  = {
		"INT_FUEL",
		"FQI_BRIGHTNESS"
	}
	segment1.controllers     = {
		{ "parameter_in_range",      0, (i + 0.5) * max_fuel / (numSegments), max_fuel },
		{ "opacity_using_parameter", 1 }
	}
	segment1.vertices        = {
		{ -rx * cos1,    -ry * sin1 + y_offset },
		{ -(rx - dr) * cos1, -(ry - dr) * sin1 + y_offset },
		{ -(rx - dr) * cos2, -(ry - dr) * sin2 + y_offset },
		{ -rx * cos2,    -ry * sin2 + y_offset } }
	segment1.indices         = { 0, 2, 1, 2, 0, 3 }
	segment1.material        = MakeMaterial(nil, orangeColor)
	segment1.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	segment1.level           = 6
	segment1.parent_element  = base.name
	segment1.additive_alpha  = false
	Add(segment1)
end
