dofile(LockOn_Options.common_script_path.."elements_defs.lua")

local radian_to_degree = 57.2957795

SetScale(METERS) 

DEFAULT_LEVEL = 6
NOCLIP_LEVEL  = DEFAULT_LEVEL - 1
CLIPPED_LEVEL = DEFAULT_LEVEL + 1

local FONT    = MakeFont({used_DXUnicodeFontData = "font7segment"},{0,255,0,215})
center={0,0,0}  --- {L/R,U/D,forward/back}


local function AddElement(object, clip)
	object.use_mipfilter    = true
	if clip ~=0 then 
		object.h_clip_relation  = h_clip_relations.COMPARE
	else
		object.h_clip_relation  = h_clip_relations.REWRITE_LEVEL
	end
	object.level = DEFAULT_LEVEL+clip
    Add(object)
end

local verts = {}
local dx=0.065351
local dy=0.093868 

local y_bl =0.5*dy-43/293*dy



verts [1]= {-0.5*dx,-0.5*dy}
verts [2]= {-0.5*dx,0.5*dy}
verts [3]= {0.5*dx,0.5*dy}
verts [4]= {0.5*dx,-0.5*dy}

local dispmat =  MakeMaterial(nil,{5,240,5,255})

local avionics_otf = {class = "ceUITTF", ttf = LockOn_Options.script_path.."Ressources/hp-simplified-hans-regular.ttf", size = 40}
FONT  = MakeFont(avionics_otf, {0,255,0,215})

--local FONT    = MakeFont({used_DXUnicodeFontData = "font7segment"},{0,255,0,215})

local line_width =0.0002
local line_width_plane =0.0001

local base 			 	 = CreateElement "ceMeshPoly"
base.name 			 = "base"
base.vertices 		 = verts
base.indices 		 = {0,1,2,2,3,0}
base.init_pos		 = center   
base.material		 = MakeMaterial(nil,{5,5,5,255})
base.level = DEFAULT_LEVEL
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
base.isdraw			 = true
base.change_opacity  = false
base.isvisible		 = false
base.element_params  = {
	"ARGUS_POWER",
}  
base.controllers     = {
	{"parameter_in_range",0,0.9,1.1}
} 
Add(base)

local center_clipping_mask				= CreateElement "ceMeshPoly"
center_clipping_mask.name				= create_guid_string()
center_clipping_mask.parent_element = base.name
center_clipping_mask.primitivetype		= "triangles"
center_clipping_mask.vertices			= {{-0.5*dx, y_bl-line_width}, {0.5*dx, y_bl-line_width}, {0.5*dx, -y_bl+line_width}, {-0.5*dx, -y_bl+line_width},}
center_clipping_mask.indices			= {0,1,3,  1,2,3}
center_clipping_mask.init_pos			= {0.0, 0.0, 0.0}
center_clipping_mask.material			= MakeMaterial(nil,{255,255,5,255})
center_clipping_mask.level = DEFAULT_LEVEL
center_clipping_mask.h_clip_relation = h_clip_relations.INCREASE_IF_LEVEL
center_clipping_mask.change_opacity	= false
center_clipping_mask.collimated		= false 
center_clipping_mask.isvisible		= false--erstmal zum testen, dann auf false
Add(center_clipping_mask)


local center_base		= CreateElement "ceSimple"
center_base.parent_element = base.name
center_base.name  			= create_guid_string()
center_base.init_pos		= {0.0, 0.0, 0.0}
center_base.element_params = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_ENR_ENABLED",
	"NOT_ENABLED"
}
center_base.level = DEFAULT_LEVEL
center_base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
center_base.controllers    = {
	{"opacity_using_parameter",0},
	{"move_up_down_using_parameter",1,-0.2119*dy},
	{"parameter_in_range",2, -0.1,0.5},
}
Add(center_base)


local function add_circle(parent,clip, position,radius, width, arc_start, arc_end, init_rotation, num_segments, dashed, material, visible)
    local arc_s = 0 or arc_start
	local arc_e = 360 or arc_end
	local ring = CreateElement "ceCircle"
    ring.name = create_guid_string()
    ring.init_pos = position
    ring.init_rot = init_rotation or {90} -- 90 since center point is 90 deg right
    ring.parent_element = parent
    ring.radius = {radius+ width, radius- width}
    ring.arc = {math.rad(arc_s), math.rad(arc_e)}
    ring.segment = math.pi * 4 / (num_segments or 32) 
    ring.gap = math.pi * 4 / (num_segments or 32) 
    ring.segment_detail = 4 
    ring.dashed = false or dashed
    ring.material = material or dispmat
    ring.visible = true or visible
	ring.element_params    = {
		"ARGUS_BRIGHTNESS",
	}
	ring.controllers	= {
		{"opacity_using_parameter",0}
	}
    AddElement(ring,clip)
end


local function add_lines(parent, clip, verts, width,x_shift, y_shift, dir)
	local element 			= CreateElement "ceSimpleLineObject"
	element.name 			    = create_guid_string()
	element.material 		    = dispmat
	element.width			    = width
	element.vertices          = verts
	element.init_pos 		    = {0.0,0.0, 0.0}
	element.parent_element    = parent
	element.use_mipfilter             = true
	element.additive_alpha            = true
	if x_shift ~=nil then 
		element.element_params    = {
			"ARGUS_BRIGHTNESS",
			x_shift,
			y_shift,
		}
		element.controllers 	    = {
			{"opacity_using_parameter",0},
			{"move_left_right_using_parameter",1,dir*dx},
			{"move_up_down_using_parameter",2,dir* dx},
		}
	else
		element.element_params    = {
			"ARGUS_BRIGHTNESS",
		}
		element.controllers 	    = {
			{"opacity_using_parameter",0},
		}
	end
	AddElement(element,clip)
end

local function add_horline(parent, height, width)
	add_lines(parent, 0,{{-dx*0.5,height}, {dx*0.5,height}}, width)
end
add_horline(base.name,-0.5*dy+43/293*dy, line_width)
add_horline(base.name,0.5*dy-43/293*dy, line_width)


---Bottom Rect---------------------------------
local bottomrect_base		= CreateElement "ceSimple"
bottomrect_base.parent_element = base.name
bottomrect_base.name  			= create_guid_string()
bottomrect_base.init_pos		= {0.0, 0.0, 0.0}
bottomrect_base.element_params = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_ENR_ENABLED"
}
bottomrect_base.level = DEFAULT_LEVEL
bottomrect_base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
bottomrect_base.controllers    = {
	{"opacity_using_parameter",0},
	{"parameter_in_range",1, 0.9,1.1},
}
Add(bottomrect_base)

local y0= -0.5*dy+43/293*dy
local y1= -0.5*dy+43/293*dy-21.5/293*dy
local x0 = 0.204433*dx

add_lines(bottomrect_base.name,0,{
	{-x0,y0},
	{-x0,y1},
	{x0,y1},
	{x0,y0},
},line_width)

--- Graphic Indicator ----------------------------------
local bottomrect_ind_base		= CreateElement "ceSimple"
bottomrect_ind_base.parent_element = bottomrect_base.name
bottomrect_ind_base.name  			= create_guid_string()
bottomrect_ind_base.init_pos		= {0.0, 0.0, 0.0}
bottomrect_ind_base.element_params = {
	"ARGUS_CROSSTRACK_MODE",
	"ARGUS_BRIGHTNESS",
}
bottomrect_ind_base.controllers    = {
	{"parameter_in_range",0, -0.1,0.5},
	{"opacity_using_parameter",1},
}
bottomrect_ind_base.level = DEFAULT_LEVEL
bottomrect_ind_base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
Add(bottomrect_ind_base)


local bottomrect_clipping_mask				= CreateElement "ceMeshPoly"
bottomrect_clipping_mask.name				= create_guid_string()
bottomrect_clipping_mask.parent_element = bottomrect_ind_base.name
bottomrect_clipping_mask.primitivetype		= "triangles"
bottomrect_clipping_mask.vertices			= {{-x0, y1}, {x0, y1}, {x0, y0}, {-x0, y0},}
bottomrect_clipping_mask.indices			= {0,1,3,  1,2,3}
bottomrect_clipping_mask.init_pos			= {0.0, 0.0, 0.0}
bottomrect_clipping_mask.material			= MakeMaterial(nil,{255,255,5,255})
bottomrect_clipping_mask.level = DEFAULT_LEVEL 
bottomrect_clipping_mask.h_clip_relation = h_clip_relations.INCREASE_IF_LEVEL
bottomrect_clipping_mask.change_opacity	= false
bottomrect_clipping_mask.collimated		= false 
bottomrect_clipping_mask.isvisible		= false--erstmal zum testen, dann auf false
Add(bottomrect_clipping_mask)

local x_start = -(203*0.5-64)/203.0*dx
local x_end = -(203*0.5-85)/203.0*dx
y0= -0.5*dy+41/293*dy
y1= -0.5*dy+43/293*dy-19/293*dy

add_circle(bottomrect_ind_base.name,0,{0,0.5*(y0+y1),0.0},0.5*15/293*dy,line_width)

for i = 0, 4, 1 do
	local x = x_start+i*(x_end-x_start)/3
	add_lines(bottomrect_ind_base.name,0,{{-x,y0},{-x,y1}},line_width)
	add_lines(bottomrect_ind_base.name,0,{{x,y0},{x,y1}},line_width)
end

verts = {{0,y0},{-0.002,y1},{0.002,y1}}
local tri 			 	 = CreateElement "ceMeshPoly"
tri.name 			 = create_guid_string()
tri.parent_element    = bottomrect_ind_base.name
tri.vertices 		 = verts
tri.indices 		 = {0,1,2}
tri.init_pos		 = {0,0,0} 
tri.material		 = dispmat
tri.isdraw			 = true
tri.change_opacity  = false
tri.isvisible		 = true
tri.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_CROSSTRACK_DIST"
}  
tri.controllers     = {
	{"opacity_using_parameter",0},
	{"move_left_right_using_parameter",1,x0},
} 
AddElement(tri,1)

---Text indicator
---
local bottomrect_text_base		= CreateElement "ceSimple"
bottomrect_text_base.parent_element = bottomrect_base.name
bottomrect_text_base.name  			= create_guid_string()
bottomrect_text_base.init_pos		= {0.0, 0.5*(y0+y1), 0.0}
bottomrect_text_base.element_params = {
	"ARGUS_CROSSTRACK_MODE",
	"ARGUS_BRIGHTNESS",
}
bottomrect_text_base.controllers    = {
	{"parameter_in_range",0, 0.5,1.1},
	{"opacity_using_parameter",1},
}
bottomrect_text_base.level = DEFAULT_LEVEL
bottomrect_text_base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
Add(bottomrect_text_base)

local ctd_fontsize_small = 0.0045
local ctd_fontsize = 0.0065
local dir_text           = CreateElement "ceStringPoly"
dir_text.name            = create_guid_string()
dir_text.parent_element = bottomrect_text_base.name
dir_text.material        = FONT
dir_text.init_pos        = {-0.9*x0,0,0.0}		
dir_text.alignment       = "LeftCenter"
dir_text.stringdefs      = {ctd_fontsize,0.9 * ctd_fontsize, 0, 0}  -- {size vertical, horizontal, 0, 0}
dir_text.formats = {"%s"}
dir_text.element_params  = {
	"ARGUS_CROSSTRACK_DIR",
	"ARGUS_BRIGHTNESS",
}
dir_text.controllers    = {
	{"text_using_parameter",0,0},
	{"opacity_using_parameter",1},
}
AddElement(dir_text,0)

local val_text           = CreateElement "ceStringPoly"
val_text.name            = create_guid_string()
val_text.parent_element = bottomrect_text_base.name
val_text.material        = FONT
val_text.init_pos        = {0.9*x0-1.5*ctd_fontsize_small*0.8,0,0.0}		
val_text.alignment       = "RightCenter"
val_text.stringdefs      = {ctd_fontsize,0.8 * ctd_fontsize, 0, 0}  -- {size vertical, horizontal, 0, 0}
val_text.formats = {"%.1f"}
val_text.element_params  = {
	"ARGUS_CROSSTRACK_DIST",
	"ARGUS_BRIGHTNESS",
}
val_text.controllers    = {
	{"text_using_parameter",0,0},
	{"opacity_using_parameter",1},
}
AddElement(val_text,0)


local valnm_text           = CreateElement "ceStringPoly"
valnm_text.name            = create_guid_string()
valnm_text.parent_element = bottomrect_text_base.name
valnm_text.material        = FONT
valnm_text.init_pos        = {0.95*x0,-0.001,0.0}		
valnm_text.alignment       = "RightCenter"
valnm_text.stringdefs      = {ctd_fontsize_small,0.8 * ctd_fontsize_small, 0, 0}  -- {size vertical, horizontal, 0, 0}
valnm_text.value = "NM"
valnm_text.element_params  = {
	"ARGUS_CROSSTRACK_DIST",
	"ARGUS_BRIGHTNESS",
}
valnm_text.controllers    = {
	{"text_using_parameter",0,0},
	{"opacity_using_parameter",1},
}
AddElement(valnm_text,0)





----------------------------------------------------S---------
----------------------------------------------------------------

local adf_compass_base		= CreateElement "ceSimple"
adf_compass_base.parent_element = center_base.name
adf_compass_base.name  			= create_guid_string()
adf_compass_base.init_pos		= {0.0, 0.0, 0.0}
adf_compass_base.element_params = {
	"ARGUS_BRIGHTNESS",
	"CURRENT_HDG",
	"ADF_DISP_ENABLED",
}
adf_compass_base.controllers    = {
	{"opacity_using_parameter",0},
	{"rotate_using_parameter", 1,1.0/radian_to_degree},
	{"parameter_in_range",2, 0.9,1.1},
}
Add(adf_compass_base)

local r = 0.5*dx
local l1 = 0.005
local l2 = 0.002
local l3 = 0.003
local subs = {
	[0] =l1,
	[1] =l2,
	[2] =l3,
	[3] =l2,
	[4] =l3,
	[5] =l2,
}
local n =11
for i = 0, n, 1 do
	for i_s, v in pairs(subs) do
		local alpha = (i/(n+1) + i_s/(6.0*(n+1)))*360.0/radian_to_degree
		local cos = math.cos(alpha)
		local sin = math.sin(alpha)
		x0 = r*cos
		y0 = r*sin
		x1 = (r-v)*cos
		y1 = (r-v)*sin
		add_lines(adf_compass_base.name,1,{{x0,y0},{x1,y1}},line_width)
	end
	local alpha = (-0.25+i/(n+1))*360.0/radian_to_degree
	local cos = math.cos(-alpha)
	local sin = math.sin(-alpha)
	x0 = (r-0.0075)*cos
	y0 = (r-0.0075)*sin
	local num           = CreateElement "ceStringPoly"
	num.name            = create_guid_string()
	num.parent_element = adf_compass_base.name
	num.material        = FONT
	num.init_pos        = {x0,y0,0.0}		
	num.alignment       = "CenterCenter"
	num.stringdefs      = {0.0055,0.75 * 0.0055, 0, 0}  -- {size vertical, horizontal, 0, 0}
	num.value = i/(n+1)*36
	num.formats         = {"%02d"} 
	num.element_params  = {
		"ARGUS_BRIGHTNESS",
		"CURRENT_HDG",
	}
	num.controllers    = {
		{"opacity_using_parameter",0},
	    {"rotate_using_parameter", 1,-1.0/radian_to_degree},
	}
	AddElement(num,1)
end
-------------------------------------------------------------

local adf_needle_base		= CreateElement "ceSimple"
adf_needle_base.parent_element = base.name
adf_needle_base.name  			= create_guid_string()
adf_needle_base.init_pos		= {0.0, 0.0, 0.0}
adf_needle_base.element_params = {
	"ARGUS_BRIGHTNESS",
	"CURRENT_HDG", 
	"ADF_DISP_ENABLED"
}  -- Only enable gunsight if power in bus
adf_needle_base.controllers    = {
	{"opacity_using_parameter",0},
	{"rotate_using_parameter", 1,-1.0/radian_to_degree},
	{"parameter_in_range",2, 0.5,1.1},
}
Add(adf_needle_base)

local s_w = 0.001
verts={
	{-s_w,r-0.0115},
	{-s_w,r-0.008},
	{-0.0045,r-0.008},
	{0.0,r},
	{0.0045,r-0.008},
	{s_w,r-0.008},
	{s_w,r-0.0115},
}

add_lines(adf_needle_base.name,1,verts,1.5*line_width)

verts={
	{-s_w,-r+0.014},
	{-s_w,-r+0.0055},
	{0.0,-r+0.005},
	{s_w,-r+0.0055},
	{s_w,-r+0.014},
}
add_lines(adf_needle_base.name,1,verts,1.5*line_width)

verts={
	{0.0,-r+0.005},
	{0.0,-r},
}
add_lines(adf_needle_base.name,1,verts,1.5*line_width)



local not_text           = CreateElement "ceStringPoly"
not_text.name            = create_guid_string()
not_text.parent_element = base.name
not_text.material        = FONT
not_text.init_pos        = {0,0.1*dy,0.0}		
not_text.alignment       = "CenterCenter"
not_text.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
not_text.value         = "NOT"
not_text.element_params  = {
	"ARGUS_BRIGHTNESS",
	"NOT_ENABLED"
}
not_text.controllers    = {
	{"opacity_using_parameter",0},
	{"parameter_in_range",1, 0.5,1.1},
}
AddElement(not_text,0)

local not_text2          = CreateElement "ceStringPoly"
not_text2.name            = create_guid_string()
not_text2.parent_element = base.name
not_text2.material        = FONT
not_text2.init_pos        = {0,-0.1*dy,0.0}		
not_text2.alignment       = "CenterCenter"
not_text2.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
not_text2.value         = "IMPLEMENTED"
not_text2.element_params  = {
	"ARGUS_BRIGHTNESS",
	"NOT_ENABLED"
}
not_text2.controllers    = {
	{"opacity_using_parameter",0},
	{"parameter_in_range",1, 0.5,1.1},
}
AddElement(not_text2,0)

-------------------------------------------------------------
-------------------------------------------------------------
--Mag Bearing------------------------------------------------
x0 = (85-203*0.5)/203*dx
local x1 = (135-203*0.5)/203*dx
y0= 0.5*dy-34/293*dy
y1= 0.5*dy-2/293*dy


add_lines(base.name,0,{
	{0.0,y_bl},
	{-0.001,y0},
	{x0,y0},
	{x0,y1},
	{x1,y1},
	{x1,y0},
	{0.001,y0},
	{0.0,y_bl}},
	line_width)

local bearing_num           = CreateElement "ceStringPoly"
bearing_num.name            = create_guid_string()
bearing_num.parent_element = base.name
bearing_num.material        = FONT
bearing_num.init_pos        = {0.0055*0.5,0.5*dy-24/293*dy,0.0}		
bearing_num.alignment       = "CenterCenter"
bearing_num.stringdefs      = {0.007,0.70 * 0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
bearing_num.formats         = {"%03.0f°"} 
bearing_num.element_params  = {
	"ARGUS_BRIGHTNESS",
	"CURRENT_HDG",
}
bearing_num.controllers    = {
	{"opacity_using_parameter",0},
    {"text_using_parameter",1,0},
}

AddElement(bearing_num, 0)

local mag_text           = CreateElement "ceStringPoly"
mag_text.name            = create_guid_string()
mag_text.parent_element = base.name
mag_text.material        = FONT
mag_text.init_pos        = {0.0055*0.5,0.5*dy-9/293*dy,0.0}		
mag_text.alignment       = "CenterCenter"
mag_text.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
mag_text.value         = "MAG"
mag_text.element_params  = {
	"ARGUS_BRIGHTNESS"
}
mag_text.controllers    = {
	{"opacity_using_parameter",0},
}
AddElement(mag_text,0)


-------------------------------------------------------------
-------------------------------------------------------------
--- WP data
local brg_text           = CreateElement "ceStringPoly"
brg_text.name            = create_guid_string()
brg_text.parent_element = base.name
brg_text.material        = FONT
brg_text.init_pos        = {-0.015,0.5*dy-20/293*dy,0.0}		
brg_text.alignment       = "LeftBottom"
brg_text.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
brg_text.value         = "BRG"
brg_text.element_params  = {
	"ARGUS_BRIGHTNESS"
}
brg_text.controllers    = {
	{"opacity_using_parameter",0},
}
AddElement(brg_text, 0)


local brg_num           = CreateElement "ceStringPoly"
brg_num.name            = create_guid_string()
brg_num.parent_element = base.name
brg_num.material        = FONT
brg_num.init_pos        = {-0.016,0.5*dy-20/293*dy,0.0}		
brg_num.alignment       = "RightBottom"
brg_num.stringdefs      = {0.007,0.70 * 0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
brg_num.formats         = {"%3.0f°"} 
brg_num.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_BRG"
}
brg_num.controllers    = {
	{"opacity_using_parameter",0},
    {"text_using_parameter",1,0},
}
AddElement(brg_num,0)

local dist_text           = CreateElement "ceStringPoly"
dist_text.name            = create_guid_string()
dist_text.parent_element = base.name
dist_text.material        = FONT
dist_text.init_pos        = {-0.0135,0.5*dy-41/293*dy,0.0}		
dist_text.alignment       = "LeftBottom"
dist_text.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
dist_text.value         = "NM"
dist_text.element_params  = {
	"ARGUS_BRIGHTNESS",
}
dist_text.controllers    = {
	{"opacity_using_parameter",0},
}
AddElement(dist_text, 0)

local dist_num           = CreateElement "ceStringPoly"
dist_num.name            = create_guid_string()
dist_num.parent_element = base.name
dist_num.material        = FONT
dist_num.init_pos        = {-0.015,0.5*dy-41/293*dy,0.0}		
dist_num.alignment       = "RightBottom"
dist_num.stringdefs      = {0.007,0.70 * 0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
dist_num.formats         = {"%3.1f"}
dist_num.element_params  = {
	"ARGUS_BRIGHTNESS",
 	"ARGUS_DIST"
}
dist_num.controllers    = {
	{"opacity_using_parameter",0},
    {"text_using_parameter",1,0},
}
AddElement(dist_num,0)


local speed_text           = CreateElement "ceStringPoly"
speed_text.name            = create_guid_string()
speed_text.parent_element = base.name
speed_text.material        = FONT
speed_text.init_pos        = {0.025,0.5*dy-20/293*dy,0.0}		
speed_text.alignment       = "LeftBottom"
speed_text.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
speed_text.value         = "KTS"
speed_text.element_params  = {
	"ARGUS_BRIGHTNESS",
}
speed_text.controllers    = {
	{"opacity_using_parameter",0},
}
AddElement(speed_text, 0)


local speed_num           = CreateElement "ceStringPoly"
speed_num.name            = create_guid_string()
speed_num.parent_element = base.name
speed_num.material        = FONT
speed_num.init_pos        = {0.025,0.5*dy-20/293*dy,0.0}		
speed_num.alignment       = "RightBottom"
speed_num.stringdefs      = {0.007,0.70 * 0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
speed_num.formats         = {"%3.0f"} 
speed_num.element_params  = {
	"ARGUS_BRIGHTNESS",
	"GROUND_SPEED_KTS"
}
speed_num.controllers    = {
	{"opacity_using_parameter",0},
    {"text_using_parameter",1,0},
}
AddElement(speed_num, 0)

local time_h         = CreateElement "ceStringPoly"
time_h.name            = create_guid_string()
time_h.parent_element = base.name
time_h.material        = FONT
time_h.formats = {"%s"}
time_h.init_pos        = {0.0125+2.05*0.0065,0.5*dy-41/293*dy,0.0}	
time_h.alignment       = "RightBottom"
time_h.stringdefs      = {0.0065,0.75 * 0.0065, 0, 0}  -- {size vertical, horizontal, 0, 0}
time_h.value         = {"--:--"} 
time_h.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ETA_HOURS",
	}
time_h.controllers     = {
	{"opacity_using_parameter",0},
	{"text_using_parameter",1,0},
}  
AddElement(time_h, 0)



local time_s           = CreateElement "ceStringPoly"
time_s.name            = create_guid_string()
time_s.parent_element = base.name
time_s.material        = FONT
time_s.formats = {"%s"}
time_s.init_pos        = {0.0125+2*0.0065,0.5*dy-41/293*dy,0.0}	
time_s.alignment       = "LeftBottom"
time_s.stringdefs      = {0.0050,0.75 * 0.0050, 0, 0}  -- {size vertical, horizontal, 0, 0}
time_s.value         = {":--"} 
time_s.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ETA_SECS",
}
time_s.controllers     = {
	{"opacity_using_parameter",0},  
	{"text_using_parameter",1,0},
}
AddElement(time_s, 0)





-------------------------------------------------------------
-------------------------------------------------------------

local adf_text           = CreateElement "ceStringPoly"
adf_text.name            = create_guid_string()
adf_text.parent_element = base.name
adf_text.material        = FONT
adf_text.init_pos        = {0.025,-0.5*dy+20/293*dy,0.0}
adf_text.alignment       = "LeftBottom"
adf_text.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
adf_text.value         = "ADF"
adf_text.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ADF_DISP_ENABLED"
}
adf_text.controllers    = {
	{"opacity_using_parameter",0},
	{"parameter_in_range",1,0.9,1.1}
}
AddElement(adf_text, 0)

local adf_num           = CreateElement "ceStringPoly"
adf_num.name            = create_guid_string()
adf_num.parent_element = base.name
adf_num.material        = FONT
adf_num.init_pos        = {0.025,-0.5*dy+20/293*dy,0.0}		
adf_num.alignment       = "RightBottom"
adf_num.stringdefs      = {0.0055,0.7 * 0.0055, -0.0005, 0}  -- {size vertical, horizontal, 0, 0}
adf_num.formats         = {"%3.1f°"}
adf_num.element_params  = {
	"ARGUS_BRIGHTNESS",
	"CURRENT_HDG",
	"ADF_DISP_ENABLED"
}
adf_num.controllers    = {
	{"opacity_using_parameter",0},
    {"text_using_parameter",1,0},
	{"parameter_in_range",2,0.9,1.1}
}
AddElement(adf_num, 0)


local te_text           = CreateElement "ceStringPoly"
te_text.name            = create_guid_string()
te_text.parent_element = base.name
te_text.material        = FONT
te_text.init_pos        = {0.027,-0.5*dy+20/293*dy,0.0}
te_text.alignment       = "LeftBottom"
te_text.stringdefs      = {0.0045,0.75 * 0.0045, 0, 0}  -- {size vertical, horizontal, 0, 0}
te_text.value         = "TE"
te_text.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_TRACK_HDG_ENABLED"
}
te_text.controllers    = {
	{"opacity_using_parameter",0},
	{"parameter_in_range",1,0.9,1.1}
}
AddElement(te_text, 0)

local TE_num           = CreateElement "ceStringPoly"
TE_num.name            = create_guid_string()
TE_num.parent_element = base.name
TE_num.material        = FONT
TE_num.init_pos        = {0.0275,-0.5*dy+20/293*dy,0.0}		
TE_num.alignment       = "RightBottom"
TE_num.stringdefs      = {0.0055,0.65 * 0.0055, -0.0003, 0}  -- {size vertical, horizontal, 0, 0}
TE_num.formats         = {"%s"} 
TE_num.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_TRACK_HDG",
	"ARGUS_TRACK_HDG_ENABLED"
}
TE_num.controllers    = {
	{"opacity_using_parameter",0},
    {"text_using_parameter",1,0},
	{"parameter_in_range",2,0.9,1.1}
}
AddElement(TE_num, 0)


local wpi_text           = CreateElement "ceStringPoly"
wpi_text.name            = create_guid_string()
wpi_text.parent_element = base.name
wpi_text.material        = FONT
wpi_text.init_pos        = {-0.032,-0.5*dy+20/293*dy,0.0}
wpi_text.alignment       = "LeftBottom"
wpi_text.stringdefs      = {0.0065,0.75 * 0.0065, 0, 0}  -- {size vertical, horizontal, 0, 0}
wpi_text.formats         = {"%s"}
wpi_text.value         = "----"
wpi_text.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_WPI_TEXT",
	"ARGUS_TRACK_HDG_ENABLED"
}
wpi_text.controllers    = {
	{"opacity_using_parameter",0},
	{"text_using_parameter",1,0},
	{"parameter_in_range",2,0.9,1.1}
}
AddElement(wpi_text, 0)



local mode_str           = CreateElement "ceStringPoly"
mode_str.name            = create_guid_string()
mode_str.parent_element = base.name
mode_str.material        = FONT
mode_str.init_pos        = {0.5*dx-0.001,-0.5*dy+1/293*dy,0.0}		
mode_str.alignment       = "RightBottom"
mode_str.stringdefs      = {0.006,0.75 * 0.006, 0, 0}  -- {size vertical, horizontal, 0, 0}
mode_str.formats         = {"%s"}
mode_str.element_params  = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_MODE_STR"
}
mode_str.controllers    = {
	{"opacity_using_parameter",0},
	{"text_using_parameter",1,0},
}
AddElement(mode_str, 0)

-------------------------------------------------------------
-------------------------------------------------------------

add_lines(center_base.name,1,{
	{0.0010312609374523163, -0.001101926201954484},
	{0.0010312609374523163, 0.0009481164743192494},
	{0.0003770232433453202, 0.0016625473508611321},
	{-0.0003770232433453202, 0.0016625473508611321},
	{-0.0010312609374523163, 0.0009481164743192494},
	{-0.0010312609374523163, -0.001101926201954484},
	{-0.00027304256218485534, -0.002374506089836359},
	{-0.0001874034060165286, -0.004562450107187033},
	{-0.0007713871309533715, -0.004562450107187033},
	{-0.0007713871309533715, -0.004964317660778761},
	{0.0007713871309533715, -0.004964317660778761},
	{0.0007713871309533715, -0.004562450107187033},
	{0.0001874034060165286, -0.004562450107187033},
	{0.00027304256218485534, -0.002374506089836359},
	{0.0010312609374523163, -0.001101926201954484}
	},line_width_plane)

add_lines(center_base.name,1,{{-0.0033105716574937105, 0.0010756702395156026},{0.0, 0.0}},line_width_plane)
add_lines(center_base.name,1,{{-0.002046046080067754, -0.0028161401860415936},	{0.0, 0.0}},line_width_plane)
add_lines(center_base.name,1,{{0.002046045381575823, -0.0028161401860415936},{0.0, 0.0}},line_width_plane)
add_lines(center_base.name,1,{{0.003310571191832423, 0.0010756697738543153},{0.0, 0.0}},line_width_plane)
add_lines(center_base.name,1,{{0.0, 0.0034809403587132692},{0.0, 0.0}},line_width_plane)


local enr_compass_base		= CreateElement "ceSimple"
enr_compass_base.parent_element = center_base.name
enr_compass_base.name  			= create_guid_string()
enr_compass_base.init_pos		= {0.0, 0.0, 0.0}
enr_compass_base.element_params = {
	"ARGUS_BRIGHTNESS",
	"CURRENT_HDG",
	"ARGUS_ENR_ENABLED"
}  -- Only enable gunsight if power in bus
enr_compass_base.controllers    = {
	{"opacity_using_parameter",0},
	{"rotate_using_parameter", 1,1.0/radian_to_degree},
	{"parameter_in_range",2, 0.5,1.1},
}
AddElement(enr_compass_base, 1)

r = y_bl*2*0.8
l1 = 0.008
l2 = 0.002
l3 = 0.003
subs = {
	[0] =l1,
	[1] =l2,
	[2] =l2,
	[3] =l3,
	[4] =l2,
	[5] =l2,
	[6] =l3,
	[7] =l2,
	[8] =l2,
}
local n =3
for i = 0, n, 1 do
	for i_s, v in pairs(subs) do
		local alpha = (i/(n+1) + i_s/((#subs+1)*(n+1)))*360.0/radian_to_degree
		local cos = math.cos(alpha)
		local sin = math.sin(alpha)
		local d0 =0.0
		if i_s == 0 then d0 =0.006 end
		x0 = (r-d0)*cos
		y0 = (r-d0)*sin
		x1 = (r-v)*cos
		y1 = (r-v)*sin
		add_lines(enr_compass_base.name,1,{{x0,y0},{x1,y1}},line_width)
	end
	local alpha = (-0.25+i/(n+1))*360.0/radian_to_degree
	local cos = math.cos(-alpha)
	local sin = math.sin(-alpha)
	x0 = (r-0.75 * 0.007*0.5)*cos
	y0 = (r-0.75 * 0.007*0.5)*sin
	local NESW ={
		[0] ="N",
		[1] ="E",
		[2] ="S",
		[3] ="W"
	}
	local num           = CreateElement "ceStringPoly"
	num.name            = create_guid_string()
	num.parent_element = enr_compass_base.name
	num.material        = FONT
	num.init_pos        = {x0,y0,0.0}		
	num.alignment       = "CenterCenter"
	num.stringdefs      = {0.0055,0.75 * 0.0065, 0, 0}  -- {size vertical, horizontal, 0, 0}
	num.value = NESW[i]
	num.formats         = {"%s"} 
	num.element_params  = {
		"ARGUS_BRIGHTNESS",
		"CURRENT_HDG"
	}
	num.controllers    = {
		{"opacity_using_parameter",0},
	    {"rotate_using_parameter", 1,-1.0/radian_to_degree},
	}
	AddElement(num, 1)
end



local i_wp = 2
for i_wp =1,50 do
	local wp_base		= CreateElement "ceSimple"
	wp_base.parent_element = enr_compass_base.name
	wp_base.name  		= create_guid_string()
	wp_base.init_pos	= {0.0, 0.0, 0.0}
	wp_base.element_params = {
		"ARGUS_BRIGHTNESS",
		"ARGUS_ENR_ENABLED",
		"ARGUS_WP_" .. i_wp .. "_DISP",
		"ARGUS_WP_" .. i_wp .. "_X",
		"ARGUS_WP_" .. i_wp .. "_Y",
		"SELF_X",
		"SELF_Y",
		"CURRENT_HDG"} 
	wp_base.controllers    = {
		{"opacity_using_parameter",0},
		{"parameter_in_range",1, 0.5,1.1},
		{"parameter_in_range",2, 0.5,1.1},
		{"move_left_right_using_parameter",4,dx},
		{"move_up_down_using_parameter",3,dx},
		{"move_left_right_using_parameter",6,-dx},
		{"move_up_down_using_parameter",5,-dx},
		{"rotate_using_parameter", 7,-1.0/radian_to_degree},
	}
	AddElement(wp_base, 1)

	local wp           = CreateElement "ceStringPoly"
	wp.name            = create_guid_string()
	wp.parent_element = wp_base.name
	wp.material        = FONT
	wp.init_pos        = {0.001,-0.001,0.0}
	wp.alignment       = "LeftTop"
	wp.stringdefs      = {0.0055,0.75 * 0.0055, 0, 0}  -- {size vertical, horizontal, 0, 0}
	wp.formats         = {"%s"}
	wp.element_params  = {
		"ARGUS_BRIGHTNESS",
		"ARGUS_WP_" .. i_wp .. "_NAME",
		"CURRENT_HDG"
	}
	wp.controllers    = {
		{"opacity_using_parameter",0},
		{"text_using_parameter",1,0},
		--{"rotate_using_parameter", 1,-1.0/radian_to1_degree},
	}
	AddElement(wp, 1)
	local v1 = 0.0015
	local v2 = 0.0005
	verts = {
		{-v1,0.0},
		{-v2,v2},
		{0,v1},
		{v2,v2},
		{v1,0},
		{v2,-v2},
		{0,-v1},
		{-v2,-v2},
		{-v1,0}
	}
	
	add_lines(wp_base.name,1,verts,line_width)

	if i_wp ~=50 then 
		local element 			= CreateElement "ceSimpleLineObject"
		element.name 			    = create_guid_string()
		element.material 		    = dispmat
		element.width			    = line_width
		element.vertices          = {{0.0,0.0},{0.0,0.0}}
		element.init_pos 		    = {0.0,0.0, 0.0}
		element.parent_element    = enr_compass_base.name
		element.use_mipfilter     = true
		element.additive_alpha    = true
		element.element_params    = {
			"ARGUS_BRIGHTNESS",
			"ARGUS_ENR_ENABLED",
			"ARGUS_WP_" .. i_wp -1 .. "_DISP",
			"ARGUS_WP_" .. i_wp  .. "_DISP",
			
			"ARGUS_WP_" .. i_wp -1 .. "_X",
			"ARGUS_WP_" .. i_wp -1 .. "_Y",
			"ARGUS_WP_" .. i_wp .. "_X",
			"ARGUS_WP_" .. i_wp .. "_Y",
			"SELF_X",
			"SELF_Y"
		}
		element.controllers 	    = {
			{"opacity_using_parameter",0},
			{"parameter_in_range",1, 0.5,1.1},
			{"parameter_in_range",2, 0.5,1.1},
			{"parameter_in_range",3, 0.5,1.1},
			{"line_object_set_point_using_parameters", 0,5, 4, dx, dx},
			{"line_object_set_point_using_parameters", 1,7, 6, dx, dx},
			{"move_left_right_using_parameter",9,-dx},
			{"move_up_down_using_parameter",8,-dx}
		}
		AddElement(element,1)
	end
end


--line from aircraft to actual waypoint
local to_wp 			= CreateElement "ceSimpleLineObject"
to_wp.name 			    = create_guid_string()
to_wp.material 		    = dispmat
to_wp.width			    = line_width*0.5
to_wp.vertices          = {{0.0,0.0},{0.0,0.0}}
to_wp.init_pos 		    = {0.0,0.0, 0.0}
to_wp.parent_element    = enr_compass_base.name
to_wp.use_mipfilter     = true
to_wp.additive_alpha    = true
to_wp.element_params    = {
	"ARGUS_BRIGHTNESS",
	"ARGUS_ENR_ENABLED",
	"ARGUS_SHOW_AC_WP",
	
	
	"ARGUS_AWP_X",
	"ARGUS_AWP_Y",
	"SELF_X",
	"SELF_Y"
}
to_wp.controllers 	    = {
	{"opacity_using_parameter",0},
	{"parameter_in_range",1, 0.5,1.1},
	{"parameter_in_range",2, 0.5,1.1},
	
	{"line_object_set_point_using_parameters", 0,4, 3, dx, dx},
	{"line_object_set_point_using_parameters", 1,6, 5, dx, dx},
	{"move_left_right_using_parameter",6,-dx},
	{"move_up_down_using_parameter",5,-dx}
}
AddElement(to_wp,1)

for i_ap =1,10 do
	local airport_base		= CreateElement "ceSimple"
	airport_base.parent_element = enr_compass_base.name
	airport_base.name  		= create_guid_string()
	airport_base.init_pos	= {0.0, 0.0, 0.0}
	airport_base.element_params = {
		"ARGUS_BRIGHTNESS",
		"ARGUS_ENR_ENABLED",
		"ARGUS_AP_" .. i_ap .. "_DISP",
		"ARGUS_AP_" .. i_ap .. "_X",
		"ARGUS_AP_" .. i_ap .. "_Y",
		"SELF_X",
		"SELF_Y",
		"CURRENT_HDG"} 
		airport_base.controllers    = {
		{"opacity_using_parameter",0},
		{"parameter_in_range",1, 0.5,1.1},
		{"parameter_in_range",2, 0.5,1.1},
		{"move_left_right_using_parameter",4,dx},
		{"move_up_down_using_parameter",3,dx},
		{"move_left_right_using_parameter",6,-dx},
		{"move_up_down_using_parameter",5,-dx},
		--{"rotate_using_parameter", 6,-1.0/radian_to_degree},
	}
	AddElement(airport_base, 1)

	local ap_name           = CreateElement "ceStringPoly"
	ap_name.name            = create_guid_string()
	ap_name.parent_element = airport_base.name
	ap_name.material        = FONT
	ap_name.init_pos        = {0.001,-0.001,0.0}
	ap_name.alignment       = "CenterCenter"
	ap_name.stringdefs      = {0.0055,0.75 * 0.0055, 0, 0}  -- {size vertical, horizontal, 0, 0}
	ap_name.formats         = {"%s"}
	ap_name.element_params  = {
		"ARGUS_BRIGHTNESS",
		"ARGUS_AP_" .. i_ap .. "_NAME",
		"CURRENT_HDG"
	}
	ap_name.controllers    = {
		{"opacity_using_parameter",0},
		{"text_using_parameter",1,0},
		{"rotate_using_parameter", 2,-1.0/radian_to_degree},
	}
	AddElement(ap_name, 1)


	for i_rw = 1,5 do
		local element 			= CreateElement "ceSimpleLineObject"
		element.name 			    = create_guid_string()
		element.material 		    = dispmat
		element.width			    = line_width
		element.vertices          = {{0.0,0.0},{0.0,0.0}}
		element.init_pos 		    = {0.0,0.0, 0.0}
		element.parent_element    = airport_base.name
		element.use_mipfilter     = true
		element.additive_alpha    = true
		element.element_params    = {
			"ARGUS_BRIGHTNESS",
			"ARGUS_ENR_ENABLED",
			"ARGUS_AP_" .. i_ap .. "_RW_"..i_rw.."_DISP",
			
			"ARGUS_AP_" .. i_ap .. "_RW_"..i_rw.."_XS",
			"ARGUS_AP_" .. i_ap .. "_RW_"..i_rw.."_YS",
			"ARGUS_AP_" .. i_ap .. "_RW_"..i_rw.."_XE",
			"ARGUS_AP_" .. i_ap .. "_RW_"..i_rw.."_YE",
		}
		element.controllers 	    = {
			{"opacity_using_parameter",0},
			{"parameter_in_range",1, 0.5,1.1},
			{"parameter_in_range",2, 0.5,1.1},
			{"line_object_set_point_using_parameters", 0,4, 3, dx, dx},
			{"line_object_set_point_using_parameters", 1,6, 5, dx, dx},
		}
		AddElement(element,1)
	end
end



