-- Class/type of objects added; They will appear as "Cargos" inside "Static Objects" in ME

local function add_cargo(f)
	if(f) then
		f.shape_table_data = 
		{
			{
				file  	    = f.ShapeName,
				life		= f.Life,
				username    = f.Name,
				desrt       = f.ShapeNameDestr,
			}
		}
		if f.ShapeNameDestr then
			f.shape_table_data[#f.shape_table_data + 1] = 
			{
				name  = f.ShapeName,
				file  = f.ShapeNameDestr,	
			}
		end
		
		
		f.mapclasskey 	= "P0091000352";
		f.attribute 		= {"Cargos"}; 
		f.category 		= 'Cargo';
		
		add_surface_unit(f)
		GT = nil;
	else
		error("Can't add cargo")
	end;
end


--Cargo Object List
----------------------------------------------


add_cargo({
Name 		 	=  "AH6_cargo",
--Name that will appear inside ME
DisplayName  	=  _("AH-6J Cargo"),
--Shape EDM name
ShapeName	 	=   "AH6_cargo",
ShapeNameDestr = "AH6_cargo",
Life		 	 	=  100,
Rate		 	=  100,
canExplode		= true,
mass			= 790,
minMass		= 700,
maxMass		= 990,
couldCargo		= true,
topdown_view 	=  topdown_view,
})

add_cargo({
Name 		 	=  "delta_cargo",
--Name that will appear inside ME
DisplayName  	=  _("Delta Crew"),
--Shape EDM name
ShapeName	 	=   "delta_cargo",
ShapeNameDestr = "delta_cargo",
Life		 	 	=  10,
Rate		 	=  10,
canExplode		= false,
mass			= 200,
minMass		= 180,
maxMass		= 300,
couldCargo		= true,
topdown_view 	=  topdown_view,
})
---------------------------------------------
--- You can continue adding more cargo objets to the database following the structure above, between dot lines. Remember to add also a new *.csv file for each to Data folder