--mount_vfs_model_path(current_mod_path.."/Shapes")

dofile("Scripts/Database/wsTypes.lua")
dofile(current_mod_path .. "/Weapons/AH-6_special_gear.lua")
dofile(current_mod_path .. "/Weapons/AH-6_guns.lua")
dofile(current_mod_path .. "/Weapons/AH-6_grenades.lua")


local doors = {
	category	= CAT_PODS,
	CLSID		= "{AH-6_DOORS}",
	attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
	Picture		= "icon_door.png",
	displayName	= _("Doors"),
	Weight_Empty	= 0,
	Weight			= 10, -- 200USG = 757.082 liter * 0.79kg/l fuel weight 
	Cx_pil			= 0.000956902,
	Elements  		= {{ShapeName = ""}}, 
}
declare_loadout(doors)



local gunners = {
	category	= CAT_PODS,
	CLSID		= "{AH-6_Gunners}",
	attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
	Picture		= "seat_icon_backrow.png",
	displayName	= _("4 x Gunners"),
	Weight_Empty	= 0,
	Weight			= 450, 
	Cx_pil			= 0.000956902,
	Elements  		= {{ShapeName = ""}}, 
}
declare_loadout(gunners)


local function fuel_tank_goliath(clsid)
	local data =
	{
		category         = CAT_FUEL_TANKS,
		CLSID            = clsid,
		attribute        = { wsType_Air, wsType_Free_Fall, wsType_FuelTank, WSTYPE_PLACEHOLDER },
		Picture          = "PTB.png",
		displayName      = _("Goliath Aux Fuel Tank"),
		Weight_Empty     = 20,
		Weight           = 20 + 185.65, 
		Cx_pil           = 0,
		shape_table_data =
		{
			{
				name = "AH_AUX_TANK",
				file = "ah6_auxtank",
				life = 1,
				fire = { 0, 1 },
				username = "AH_AUX_TANK",
				index = WSTYPE_PLACEHOLDER,
			},
		},
		Elements         =
		{
			{
				ShapeName = "ah6_auxtank",
			},
		},
	}
	declare_loadout(data)
end

fuel_tank_goliath("{AH6_GOLIATH}")


-- Hellfires


declare_loadout(
{
	category   			= CAT_MISSILES, 
	CLSID    				= "AH6_AGM_114K_R1", 
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
	Picture   			= "OH58D_AGM_114.png",  
	displayName  			= "1xAGM-114K",
	Cx_pil				=	0.001,
	Weight     			= 45.18+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
	Count 				= 1,
    settings 				= Get_LGU_GUISettings_Preset("WGU59"),	  
	Elements  = 
	{
	{
		--Position	=	{0.2689, 0.0, 0.0}, -- marche pas ici ?
		ShapeName	=	"OH58D_HRACK_R",
		IsAdapter   =   true,
	},
	{
		--Position	=	{0.4081,	0.4399,	0.212}, -- ext relatif position pylon
		--Position	=	{fwd/aft,	-up/down,	L/R}, -- ext relatif position pylon
		Position	=	{0.15,	-0.1,	0.165}, -- ext relatif position pylon			--- (0.35,	-0.1,	0.165},
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	-- {
		-- Position	=	{0.403,	-0.13,	-0.17}, -- int relatif position pylon
		-- ShapeName	=	"OH58D_AGM114K",
		-- Rotation    =   {0.0,0.0,0.0},
	-- },
	},
})

declare_loadout(
 {
  category   			= CAT_MISSILES,
  CLSID    				= "AH6_AGM_114K_R",
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
  Picture   			= "OH58D_AGM_114.png",
  displayName  			= "2xAGM-114K",
  Cx_pil				=	0.001,
  Weight     			= (2*45.18)+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
  Count 				= 2,
  settings 				= Get_LGU_GUISettings_Preset("WGU59"),
  Elements  = 
  {
	{
		--Position	=	{0.2689, 0.0, 0.0}, -- marche pas ici ?
		ShapeName	=	"OH58D_HRACK_R",
		IsAdapter   =   true,
	},
	{
		--Position	=	{fwd/aft,	-up/down,	L/R}, -- ext relatif position pylon				
		--Position	=	{0.4081,	0.4399,	0.212}, -- ext relatif position pylon
		Position	=	{0.15,	-0.1,	0.165}, -- ext relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	{
		Position	=	{0.15,	-0.1,	-0.17}, -- int relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
  },
 }
)

declare_loadout(
 {
  category   			= CAT_MISSILES,
  CLSID    				= "AH6_AGM_114K_L1",
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
  Picture   			= "OH58D_AGM_114.png",
  displayName  			= "1xAGM-114K",
  Cx_pil				= 0.001,
  Weight     			= 45.18+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
  Count 				= 1,
  settings 				= Get_LGU_GUISettings_Preset("WGU59"),     
  Elements  = 
  {
	{
		--Position	=	{0,	0,	0},
		ShapeName	=	"OH58D_HRACK_L",
		IsAdapter   =   true,
	},
	{
		Position	=	{0.15,	-0.1,	-0.165}, -- ext relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	-- {
		-- Position	=	{0.403,	-0.13,	0.2}, -- int relatif position pylon
		-- ShapeName	=	"OH58D_AGM114K",
		-- Rotation    =   {0.0,0.0,0.0},
	-- },
  },
 }
)

declare_loadout(
 {
  category   			= CAT_MISSILES,
  CLSID    				= "AH6_AGM_114K_L",   
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
  Picture   			= "OH58D_AGM_114.png",
  displayName  			= "2xAGM-114K",
  Cx_pil				=	0.001,
  Weight     			= (2*45.18)+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
  Count 				= 2,
  settings 				= Get_LGU_GUISettings_Preset("WGU59"), 
  Elements  = 
  {
	{
		--Position	=	{0,	0,	0},
		ShapeName	=	"OH58D_HRACK_L",
		IsAdapter   =   true,
	},
	{
		Position	=	{0.15,	-0.1,	-0.165}, -- ext relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	{
		Position	=	{0.15,	-0.1,	0.17}, -- int relatif position pylon 0.20
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},   
	},
  },
 }
)